.ig
$Header: 03.t,v 1.1 88/05/21 18:39:36 papowell Locked $
$log$
..
.LG
.NH 1
Spool Directories, Programs, and Permissions
.SM
.PP
Each spool queue has a spool directory that contains the
control and data files associated with a job.
The permissions and ownerships of
spool directories and PLP software are intended to allow only PLP programs
to read,
write,
or remove jobs from the spool directory.
The strategy used to protect
spooling information is as follows:
.IP 1). 4
Each spool queue directory is owned by user
.I daemon
and group
.I daemon .
The spool queue directory permissions are 0755, i.e.-
user (daemon)
.L rwx ,
group (daemon)
.L rx ,
and other
.L rx.
These could be restricted to 0600,
user (daemon) rw only,
as PLP programs run SUID
.IR root .
.IP 2). 4
All PLP programs which modify or read the entries in the
spool queue directories run SUID
.IR root .
The SUID
.I root
is needed on most UNIX implementations in
order to change the file ownership and group information.
.IP 3). 4
Control and data files in the spooling directories have owner
.I daemon 
and
group
.IR daemon ,
and are mode 0600.
This ensures control and data files are not readable or modifiable by an
ordinary user and that no ordinary user can remove files except through
.IR lprm .
.IP 4). 4
Each spool queue has a
.I lock
file which controls queueing and printing.
If the
.I lock
has
.I "owner execute"
permission set then unspooling is disabled;
if it has
.I "group execute"
permissions set then spooling is disabled;
if it has
.I "other execute"
permissions set then the spool queue should be reordered for
unspooling purposes. These attributes are controlled using the
.I lpc
command.
.IP 5). 4
Prevention of multiple instances of a spool queue server is done by
using the
.IR fcntl (2),
.IR lockf (3),
or
.IR flock (2)
facility.
When a server starts,
it will try and lock the
.I lock
file using one of the above locking mechanisms;
if the lock fails then another server is active.
.IP 6). 4
The active server process records its
.I "process id"
and the name of the control file being processed in the
.I lock
file.
This information is used by
.I lpq
to report the queue activity.
.IP 7). 4
Before processing a job,
the server process will lock the job's control file.
This prevents multiple PLP programs such as 
.I lprm
and
.I lpd
from operating on the same job simultaneously.
.IP 8). 4
If there are multiple servers for a single queue,
the spool queue lock file is used to control spool activities,
and individual printer server lock files are used to control the printers.
.IP 9). 4
Each spool queue has a
.I status
file which is used to record the current status of the server process and
any LP-pipe processes.
This information is displayed by
.I lpq
and
.IR lpc .
.IP 10). 4
A server process is setuid
.I root
and its process group is its process id.
Any subprocesses that it forks will be in the same process group.
The
.I lprm
program uses 
.IR killpg \|(2)
or
.IR kill \|(2)
to signal an active server process.
This will effect all subprocesses as well as the original server process.
