.ig
$Header: 02.t,v 1.1 88/05/21 18:39:32 papowell Locked $
$log$
..
.LG
.NH 1
The PLP Programs
.SM
.PP
The following section outlines the operation of the
.IR lpd \|(8)
line printer
.IR daemon ,
and the
.IR lpr \|(1),
.IR lpq \|(1),
.IR lprm \|(1),
and
.IR lpc \|(1)
utility programs.
.NH 2
lpd \- Line Printer Dameon Program
.PP
The 
.IR lpd \|(8)
program is usually invoked at boot time from the
.L /etc/rc
or
.L /etc/rc.local
startup file,
and acts as a server or
.I daemon
for coordinating and controlling
the spooling queues configured in the printcap file or files.
Figure 2.1 is a section of 
.L sh (1)
script typically used to start the
.I lpd
daemon.
.KF
.in +1i
.L
.SM
.nf
.ta 4n +4n +4n +4n +4n +4n +4n +4n +4n +4n +4n +4n 8i
# Start up the lpd daemon
if [ -x /usr/local/bin/lpd ]; then
    /usr/local/bin/lpd && echo -n ' printer'	\> /dev/console
fi
.LG
.in -1i
.R
.ce
Figure 2.1  Startup File Command for LPD
.KE
.PP


When
.I lpd
is started,
it checks to see if there is an active
.I lpd
daemon already running by trying to lock the
.L /var/spool/lpd/lpd.lock.hostname
file.
If no daemon is present,
.I lpd
forks a server process for each non-empty spool queue in the
.IR printcap \|(5)
data base,
and then listens for service requests on specific
Internet domain port.
The Internet port number is found using the
.IR getservbyname \|(3)
facility.
The
.I "Advanced Tuturial on Interprocess Communications"
distributed with Berkeley UNIX 4.3 BSD 
(and reprinted by SUN Microsystems) provides an excellent
tutorial on interprocess communications.
See  the manual pages for
.IR socket \|(2)
and 
.IR services \|(5)
for more information on sockets and service specifications.
.PP

.I lpd
can also be started from
.IR inetd \|(8)
using the
.L -i
command-line option. If it is used in this fashion, it will not
start a sub-server for each non-empty queue at startup.
.PP

When a connection is made to the 
.I lpd
port by a requesting process (usually called a client),
.I lpd
forks a server process to carry out the request and
continues to listen for new requests.
The Table 2.1 shows the requests
understood by
.IR lpd .
The first byte of a request is a binary number
specifying the request type,
and the following characters up to a terminating a new line ('\en') character
are the request.
.KF
.TS
box center;
l | l.
Request	Interpretation
_
^Aprinter\en	start a server for the queue
^Bprinter\en	receive and queue a job from another host
^Cprinter [users ...] [jobs ...]\en	return short form of printer queue status
^Dprinter [users ...] [jobs ...]\en	return long form of printer queue status
^Eprinter person [users ...] [jobs ...]\en	remove jobs from a queue
^Fperson command [printers]\en	perform lpc control function
.TE
.R
.ce 1
Table 2.1 LPD Request Message Format
.KE
.PP
After reading the request,
the server process reads the printer permissions file to
determine if the originating host
has permissions to access the specified printer.
Next,
the
.I printcap
data base is read to
determine the set of options and restrictions that apply to the
spool queue or printer.
Finally,
the server uses this information to perform the requested action.
.PP


In response to a ``start server'' message,
the server process checks to see if a server is present,
and if not,
starts unspooling activities itself.
.PP

The two forms of status requests cause the server to check the
spool queue and report on the current activities.
.PP

The file transfer request causes the server and client process to start
transferring control and data files that make up a print job.
This activity is described in detail in Section 5.
.PP

The remove job request causes the server to check that the user has
suitable permissions for the particular queue,
and will then remove the specified jobs.
.PP

The control request will cause the server to perform control functions.
This function allows control over spooling operations to be done using the
.I lpc
program on a remote host.
.PP

.NH 3
Security Issues In a Networked Environment
.PP
The permissions and restriction checks
performed by
.I lpd
are based on the assumption that the client host machine is
well known by the network-layer software,
and that the process originating a request authenticates
the user requesting the service.
The port from which the client request originates
is restricted to a range which is reserved for users with root
permissions (in a UNIX environment, at least).
.PP

In an environment where users can implement their own support for
TCP/IP facilities,
these security checks may not be sufficient.
In fact,
given access to the network communications hardware,
it is possible to forge messages that appear to be originating
from any valid site. The problem of authentication of
requests is currently open.
.NH 3
Spool Queue Access and Permissions
.PP
As discussed in the previous section,
there are problems in controlling access to PLP by
clients on remote hosts.
As a preliminary step towards a more general authentication
procedure,
PLP uses a
.I printer_perms
or printer permissions file containing a list of machines,
users,
spool queues and associated privileges.
Authentication of remote hosts is based on the network connection information
provided by the
.IR getpeername \|(3N)
networking function.
.KF
.L
.SM
.TS
tab(:) center box;
l s s s s s s s s
l l l l l l l l l.
# -- Line printer permissions
# host:name:group:queue:Ops:Pr:Max:Done:#Comment
~*.umn.edu:*:*:*:C:A:0:0:# no non-local sites
central.*.umn.edu:root:*:*:C:A:0:0:# root@central can do anything
*.umn.edu:root:*:lp:C:A:0:100:# root@* can access lp, priority A
server.adm.umn.edu:admin:*:lp:R:C:1000:200:# admin@server, lp priority C
!*:CS*:*:laser*:R:Z:*:*:# CS accounts, no laserprinters
!*:*:firstyr:laser*:R:Z:*:*:# firstyr group, no laserprinters
*.umn.edu:*:*:lp:R:Z:*:*:# default is priority Z
.TE
.LG
.R
.ce
Table 2.2 Example Printer Permissions File
.KE
.PP
Each entry in the printer permissions file specifies a host machine,
a username, a group name,
a printer or spool queue name,
a set of operations (R, M or C),
a maximum priority (A-Z),
and a maximum and current page counts associated with use of a spool queue.
Blank lines and lines that start with
.L #
(comment) are ignored.
Fields are separated with one or more spaces or tabs.
There is a simple wildcard match facility similar to the UNIX
shell metacharacter match.
The
.L *
character will match 0 or more characters in the string,
and the
.L ?
will match exactly one character.
Lines that start with a ! indicate that permissions are
denied for queries that would otherwise match.
.PP
Given a host,
user,
and spool queue,
the printer permissions file is searched for a matching entry in
first line to last line,
left to right order.
The host,
user, group,
and spool queue fields are checked for a match;
the first line found which matches these will terminate the search.
The group field is matched based upon the login group. If the user
is listed in the
.L groups \|(5)
entry for the named group, it is also a match.
If an tilde
.B (~)
is first character on the line,
the fields are checked for a match.
If the match fails,
then permissions are refused.
If the match succeeds,
then further searching will be done.
This facility allows only sites with suitable path names,
etc.,
to have access to a spool queue.
If an exclamation mark
.B (!)
is first character on the line,
all permissions are refused; this allows filtering
out requests that are to be rejected in a simple manner.
If this facility is used,
entries should be ordered so that refusals
(starting with !) precede any matching entries.
.PP


For example,
the printer permissions file in Table 2.1 allows
.L root
on host
.L central
(i.e.-
.L root@central )
to access all queues,
.L root
on any machine to access the lp queue,
and
.L admin
on 
.L server
to access the lp queue.
Userids starting with CS are denied permission to use
spool queues whose names start with laser.
Note that the host name used for checking is the full name returned by the
.I gethostbyname (3N)
function.
.PP
Spool queue operations,
spooling priorities,
and other information are set by the matching line.
The 
.I Ops
field controls the allowed operations;
a
.L C
value stands for Control,
and means that the user has permissions to use the LPC and LPRM
programs to manage a queue as well as spool jobs to the queue.
An
.L M
value stands for Move,
and means that the user has permissions to use the LPC 
.I move
command to move one of his/her own jobs to this queue, as well
as spool jobs to it.
An
.L R
value stands for LPR,
and means that the user can only spool to the queue and remove his own jobs.
Control functions can be exercised from remote hosts
using the
.I remote
command of the
.I lpc
program.
.PP
The Priority field determines the maximum priority available to a user.
Users can prioritize jobs, where
.B A
is highest priority and
.B Z
is the lowest. The default priority is
.B X .
.PP

The maximum and current page count fields are used for accounting
and other purposes.
They are checked when a job is queued by
.I lpr
and when the job is unqueued for printing.
If the current maximum page count is exceeded by the user,
the job will be refused.
.PP

The
server process checks the printer permissions file to determine if a
requesting host is allowed access to a particular queue;
if so,
it will perform the requested actions as detailed in the following sections.
.NH 3
Unspooler Processes, or Queue Servers
.PP
During initialization and in response to
.I "start printer"
requests,
.I lpd
forks an
unspooler or server process that processes jobs in the spool queue.
Jobs are placed in the spool queue by
.I lpr
or are transferred from a remote site and removed by the server process.
Each spool queue has a
.I lock
file which is used to control spooling and unspooling activities.
The lock file
.I owner ,
.I group
and
.I execute
permissions are used to control spooling and unspooling actions;
if the owner execute permission is set then unspooling is disabled
and if the group execute permission is set then spooling is disabled.
The
.I lpc
utility is designed as a front-end for manipulating these attributes.
If unspooling is enabled,
the server tries to lock the
.I lock
file;
if it cannot  be locked,
then another server is active and the process will exit.
.PP
Once the server has gained control of the queue,
it finds the entries in the queue,
sort them in order of priority and time,
and then unspools them according to specifications in the
.I printcap
file.
When a job unspooled,
the server will lock the job's control file
in order to prevent other processes from manipulating the job.
If it cannot lock the control file,
then the job is currently being manipulated by another PLP
program and the server will process another job in the queue.
.NH 3
Local Printer Queues
.PP
If the spool queue is for a local printer
then the server process will print the job
according to specifications in the
.I printcap
file.
The printcap file specify
the physcial printer device,
any characteristics of the connection between the lpd
and the printer device which need to be set (such as serial
line attributes),
and any
.I filter
programs  used to print the job.

.NH 3
Remote Printer Queues
.PP
If the spool queue is for a printer attached to another host,
the server attempts to connect to the remote host and transfer the
jobs in the spool queue to the remote host.
If the file system used to
store the job is flagged as being shared by the local host and the
remote host,
then it is not neccessary to transfer files
but only to inform the remote host that there are jobs in the spool queue.
.NH 3
Multiple Printers For a Spool Queue
.PP
If there are multiple unspooling devices or printers for a local queue,
the server process checks to see if unspooling is enabled,
and then forks individual unspooler processes for each printer.
The printer processes will read the printcap entry controlling
the individual actions of each printer,
and then check the status of a printer lock file which controls the
action of the printer.
Thus,
individual printers can be enabled or disabled
as well as the entire spool queue.
.NH 2
lpr \- Job Submission Program
.PP
The
.I lpr (1)
program is used to place a print job in a spool queue
and to then send a
.I "start printer"
message to the 
.I lpd
process.
The
.I lpd
process is then responsible for printing the job or forwarding it to
the correct destination.
.PP
The
.I lpr
program uses the
printcap database to determine the actions required for spooling a job.
Spooling is enabled by the state of the spool queue lock file
permissions;
if the owner permission is set,
then spooling is disabled.
.PP
Permission to use a spool queue is determined by using the
printer permissions file.
.I Lpr
determines the user name and searches the
printer permission file to see if the user
can submit jobs to the spool queue (has R or C privileges).
If the user can use the spool queue,
.I lpr
will then copy the users files to the spool queue.
.I lpr
can also make symbolic links to the original files
rather than copying them.
After copying a file,
.I lpr
can be requested to remove the file.
.PP
Before a job is placed in the spool queue,
it may be desirable to do some local processing or
.I prefiltering
of the files.  For example,
running a formatter such as
.IR pr ,
translating a typesetter format file into a different form,
etc, can be done by lpr.
These actions are controlled by prefilter
information specified in the printcap entry for the spool queue.
.PP
Associated with each job is a format
that specifies how the job is to be processed.
For example,
the
.B f
format is the default format,
and is used when files contain printable information.
Each format can have a
prefilter that is to be applied to the job before it is placed in the
spool queue.
The prefilter facility is 
usually used when files must have some further form of processing carried out,
but the remote site where they are to be printed cannot perform
the processing.
.PP
Once the job has been placed in a queue,
lpr will request the lpd daemon to start a spool queue server.
.NH 2
lpq \- Spool Queue Status Display
.PP
The
.IR lpq \|(1)
program displays the status and contents of selected spool queues.
.I Lpq
has two forms of output:
the (default) long format which displays a complete summary of
the current spool queue activities,
and a short format which simply lists the jobs that are outstanding,
The output format of
.I lpq
is extraordinarily verbose,
and attempts to give a full picture of the total state of the line printer
and its associated queues,
servers,
and other information.
The following is an example of the output produced by
.I lpq
when displaying the status of a remote spool queue.
.DS
.L
.SM
.nf
Printer 'diablo' (julius.cs.umn.edu):
  processing, active job started Wed May 11 15:20:54 1988, attempt 1
  Rank Owner       Pr Job Host        Files                Size
active root        A  15  julius      /tmp/test5           132
   2nd root        X  14  julius      /tmp/test2           15
Remote printer 'lp2' (umn-cs.cs.umn.edu):
Warning: no server present
  work done at Wed May 11 15:16:43 1988
  Rank Owner       Pr Job Host        Files                Size
   1st root        X  13  julius      /tmp/test3           30
   2nd root        X  14  julius      /tmp/test4           9
.LG
.DE
.PP
The first line identifies the name of the local printer,
and the host.
It is followed by an informative message generated by the currently active
server process,
which is transferring a file to the remote site.
Next is a list of the files in the local queue,
ranked according to their processing order.
The next line identifies the remote printer and site.
The warning message indicates that no server process is present,
even though there are jobs in the spool queue.
This is a transitory condition,
because the server process will be started as soon as the file transfers
are completed.
.DS
.L
.SM
.nf
imagen_lind27: 0 jobs
imagen_ld27: 3 jobs
1 cfZ022julius: root
2 cfZ023julius: root
3 cfZ024julius: root
.LG
.DE
The short form of status display 
illustrated above merely gives a summary of the numbers of jobs
and their order in the queue.
.NH 2
lprm \- remove jobs from a queue
.PP
The
.IR lprm \|(1)
command deletes jobs from a spooling queue.
If necessary,
.I lprm
will kill(2) off a server process which is working on the job.
After removing any files,
it will then restart the queue by sending a request to the lpd daemon.
.I Lprm
will lock a job control file before removing the job,
preventing a server from trying to unspool the job while it is being removed.
.PP
If a user can submit jobs to a queue,
he can remove jobs that he has submitted.
The root, or superuser, for a host can remove any job submitted from
that particular host.
Finally,
the printer permission file will allow any user with control permissions for
a spool queue to remove any job from the spool queue.
.NH 2
lpc \- line printer control program
.PP
The
.IR lpc \|(1)
program is used to monitor and control the
operation of the Line Printer Software
by manipulating the status of  spool queue lock files,
and killing active servers.
It can send messages to PLP daemons requesting that
they carry out similar actions,
controlling both local and remote lpd daemons.
It is not necessary to log onto a remote machine to perform control
actions,
as long as the printer permissions file has the appropriate entries.
The commands accepted by the
.I lpc
program are detailed in section 9.2.
Unless specified as unpriviledged,
they can only be used by a user with control permissions for the specified
spool queue,
and on the current or local host machine.
.I All
or individual queues can be operated on.
