#ifndef __CHINESE_H
#define __CHINESE_H


#define MAX_FONT_NUMBER 15200
#define MAX_READ_BUFFER 128
#define HASH2_SIZE      20
#define MAX_FONTSIZE    48

#include <stdio.h>
typedef unsigned char CHAR;
typedef unsigned short int WORD;
typedef int (*INTFUNC)(const char *,char *,int);
extern FILE *chinese_debug;

void ch_restoretext();
void ch_inputmethod(int i);
void ch_write_to_screen(int);
void ch_graphicmode(int);
void ch_textmode(int);
void ch_redraw();
void ch_change_console(int);
void adm_init();
void adm_end();
void ch_tran_code(int,CHAR,CHAR);
void ch_clear();
void ch_clreol();
void ch_gotoxy(int,int);
void ch_goto_systemarea(int);
void ch_system_showstr(char *);
void ch_system_showch(char);
void ch_system_clreol();
void ch_restore_cursor();
void ch_showch(CHAR);
void ch_showstr(CHAR *);
void ch_showBIG5(WORD c);
int ch_wherex();
int ch_wherey();
void ch_setdim(int,int);
void ch_scroll(int,int,int);
void ch_rscroll(int,int,int);
void ch_setscroll(int,int);
int ch_DimX();
int ch_DimY();
void ch_end();
void ch_cursoron(),ch_cursoroff(),ch_cursor_blink(int);
void ch_clearblock(int,int,int,int);
void ch_deletechar();
void ch_insertchar();
void insertline();
void delay_open_console(int c);
void ch_refresh();
int ch_fontheight(),ch_fontwidth();
int ch_wordalign(int,int);
int ch_needadjust(int con);
void ch_have_cursor(int);
void ch_setwsize(int,int,int);
void ch_color(int fg,int bg);
void sys_error(char *,int,char *,...);
void sys_fatel(char *,...);
#define CODE_BIG5    0
#define CODE_GB      1 
#define CODE_TCA     2
#define CODE_ET      3

/* stdio ouput & input replacement function */
int chinese_printf(const char *,...);
int chinese_fprintf(FILE *,const char *,...);
int chinese_scanf(const char *,...);
int chinese_fscanf(FILE *,const char *,...);
int chinese_write(int,const char *,int);
int chinese_read(int,char *,int);
int chinese_fread(char *,int,int,FILE *);
int chinese_fwrite(const char *,int,int,FILE *);
int chinese_fputc(char,FILE *);
int chinese_fgetc(FILE *);
int chinese_putc(char,FILE *);
char *chinese_fgets(char *,int,FILE *);
void chinese_exit(int);
int _cwrite(int con,const char *,int);
int _cread(char *,int);
char *_cgets(char *,int);
void Read_Console_Config(void);
void Read_Input_Config(void);
void Read_Font_Config(void);
void Read_Config(void);
void ch_automargin(int status);
/* Multiple input method driver */
typedef struct 
{
  char mark[7];
  int bell:1;
  int full:1;
  CHAR keymap[256];
  CHAR mapkey[256];
  union {
    CHAR chkey[512];
    WORD CHKEY[256];
  } cmap;
} InputHead;

typedef struct 
{
  char seqs[5];
  int order;
  union {
    short big5;
    char code[2];
  } word;
} WordMap;

typedef struct 
{
  short num;
  short maxnum;
  WordMap *map;
} HITEMLIST;

typedef struct
{
  HITEMLIST item[HASH2_SIZE];
} HASH2;

typedef struct
{
  InputHead head;
  int num;
  WordMap *keymap;
} MultipleTable;


/* CHINESE COMMAND CODE */
#define CCMD_TEXT      1
#define CCMD_GRAPH     2
#define CCMD_INPUT     3
#define CCMD_PRINT     4
#define CCMD_ACK       5
#define CCMD_START     6
#define CCMD_END       7
#define CCMD_SWINSZ    8
#define CCMD_CHTTY     9

#define NORMAL 0
#define CHECK 1


extern int Chinese_server;
extern int Chinese_sharememid;
#define CONS_NUM 6
typedef struct {
  int curx,cury;
  int oldx,oldy;
  int dimx,dimy;
  CHAR *scrtext;
  unsigned int *scrattr;
  int cursor_x,cursor_y;
  int cursor_blinked,cursor_rate;
  char c_stack;
  unsigned int sys_attr;
  int pos;
  char inv,und;
  int cursor_on;
  int no_cursor;
  int codesys;
  char screenmode;
  char isscrolled;
  char *origin;
  int topline;
  int cur_mode;
  WORD top,bottom;
  WORD fontwidth,fontheight;	
  char automargin;
  char quick_scroll;
  int line_out;
  int fontlen;
  int wordalign:1;
  int doubledelete:1;
  int quote_char:1;
  int curbg,curfg;
} VSC;

typedef struct {
  int blank_time;             /* auto saver active time                */
  int VT;                     /* which virtual console can be used     */
  char *color;                /* a string to setup system color map    */
  int ttyfd;                  /* the main file id                      */
  char *gdriver;              /* graphic driver                        */
  int etmode;                 /* whether load etmode keyboard          */
  char *colordef;             /* color define                          */
  int forecolor;
  int backcolor;
  int systemcolor;
  int systemback;
  int escwait;                /* If you press ESC,CHDRV will wait escwwait */
                              /* microsecond before send it to user        */
  char *loginprogram;
  int enterchinese;
} SYSCFG;
extern SYSCFG sys_config;
#define MAX_VGA_LINES    960
#define MAX_DIMY 29
#define MAX_DIMX 80
#define MIN_DIMY 5
#define MIN_DIMX 20
/* chtran.c */
extern int logintty;

typedef struct {
  char *name;
  void (*init)();
} GDRIVER;

extern GDRIVER sys_graphics_driver[];

extern char *version;

#define START_SAVER 0
#define RUN_SAVER 1
#define END_SAVER 2
void ch_screen_saver(int);
extern FILE *stddebug;
#ifdef DEBUG
#define SYSERR(msg)      sys_error(__FILE__,__LINE__,msg)
#define SYSERR1(msg,a)   sys_error(__FILE__,__LINE__,msg,a)
#define SYSERR2(msg,a,b) sys_error(__FILE__,__LINE__,msg,a,b)
#define SYSERR3(msg,a,b,c) sys_error(__FILE__,__LINE__,msg,a,b,c)
#define DEBUGMSG(msg) sys_error(__FILE,__LINE__,msg)
#define ENTER SYSERR("Enter");
#define LEAVE SYSERR("Leave");
#else
#define SYSERR(msg)      
#define SYSERR1(msg,a)   
#define SYSERR2(msg,a,b) 
#define SYSERR3(msg,a,b,c) 
#define DEBUGMSG(msg) 
#define LEAVE 
#define ENTER
#endif

extern int ttyfd;
extern int chdrv_is_in_startup_stage;
#define MAX_SYSTEM_TABLE 10

#ifdef DEBUG
#define ASSERT(cond) if (cond) { SYSERR("assert fail");sigquit(0)}
#endif
extern unsigned char COLOR_DEFAULT_FG;
extern unsigned char COLOR_DEFAULT_BG;
extern unsigned char COLOR_SYSTEM_FG; /*15 is white*/
extern unsigned char COLOR_SYSTEM_BG; /* 17 is blue, 10 is hi-green, 34 is green */
/* the below is no effect now */
extern int CURSOR_SL;
extern int CURSOR_EL;
#define VSCR_fontlen nscr->fontlen
extern int write_to_screen;
extern VSC *nscr;

#endif /* __CHINESE_H */

