/* Copyrigh( c) 1993
   The below program is used to display chinese character in screen
   without X window in LINUX.The program is protected under GNU copyleft
   .The detailed is as GNU's COPYING which i include it in the package.
   You can distribute this program freely.But YOU MUST DISTRIBUTE THE
   COMPLETE CODE IN THE PACKAGE.If you have modified the package,you
   must note it in README file and told others how to get the origin 
   version.
*/

/*
   $Id: chinese.c,v 1.1 1994/05/08 02:43:36 root Exp root $
*/

/********************************************************************/
/*     main modual                                                  */ 
/*        Builded date : 1993/08/09                                 */
/*     Modified                                                     */
/*        1993/08/10                                                */
/*             (1) add function ch_cursoron,ch_cursoroff            */
/*             (2) add function ch_cursor_blink                     */        
/*        1993/08/14                                                */
/*	       (1) modified ch_cursoron and ch_cursoroff. Now they  */
/*                 are used to turn on/off cursor.                  */
/*        1993/08/28                                                */
/*             (1) Change to accomodate the application of daemon   */
/*        1993/09/03                                                */
/*             (1) support virtual console.This is version 0.2      */    
/********************************************************************/  
#include "portable.h"
#include "color.h"
#include "vga.h"
#include "chinese.h"
#include "chmsg.h"
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/msg.h>
#include <sys/time.h>
#include <linux/vt.h>
#include <linux/kd.h>
#include <asm/param.h>
static void newline();
static void advance();
void ch_goto_systemarea(int);
void ch_cursor();
static void showch_attr(char,int);
#define max(x,y) (((x)>(y))? x:y)
#define UNDERLINE 1
#define INVERT    2
#define COUPLE_LEFT    0x80
#define COUPLE_RIGHT   0x40
#define QUOTE_CHAR     0x20
/* default color scheme */
unsigned char COLOR_DEFAULT_FG = 7;
unsigned char COLOR_DEFAULT_BG = 0;
unsigned char COLOR_SYSTEM_FG = 7; /*15 is white*/
unsigned char COLOR_SYSTEM_BG = 1; /* 17 is blue, 10 is hi-green, 34 is green */
/* the below is no effect now */
int CURSOR_SL = 13;
int CURSOR_EL = 15;
static int low_color_table[8],hi_color_table[8];
static int *color_table;


static VSC vscreen[CONS_NUM];
VSC *nscr;
int write_to_screen = 1;
static int activeconsole;
static void ch_redraw_part(int st);
static void ch_attr(int);

#define curx           (nscr->curx)
#define cury           (nscr->cury)
#define oldx           (nscr->oldx)
#define oldy           (nscr->oldy)
#define dimx           (nscr->dimx)
#define dimy           (nscr->dimy)
#define cursor_x       (nscr->cursor_x)
#define cursor_y       (nscr->cursor_y)
#define cursor_blinked (nscr->cursor_blinked)
#define no_cursor       (nscr->no_cursor)
#define cursor_rate    (nscr->cursor_rate)
#define scr_text        (nscr->scrtext)
#define scr_attr        (nscr->scrattr)
#define cursor_on      (nscr->cursor_on)
#define c_stack        (nscr->c_stack)
#define codesys        (nscr->codesys)
#define und            (nscr->und)
#define inv            (nscr->inv)
#define pos            (nscr->pos)
#define sys_attr       (nscr->sys_attr)
#define mode           (nscr->screenmode)
#define autoscroll     (nscr->isscrolled)
#define topl           (nscr->top)
#define bottoml        (nscr->bottom)
#define fontwidth      (nscr->fontwidth)
#define fontheight     (nscr->fontheight)
#define automargin     (nscr->automargin)
#define quick_scroll   (nscr->quick_scroll)
#define line_out       (nscr->line_out)
#define wordalign      (nscr->wordalign)
#define curfg          (nscr->curfg)
#define curbg          (nscr->curbg)
#define quote_char     (nscr->quote_char)
static int chconsole;
static void showcc(CHAR);
void ch_drawctext(int,int,WORD);
void ch_drawtext(int,int,CHAR);

/* switch to other screen,but no redraw in this place */
void _ch_swap_console(int newconsole)
{
  int i,j;
  static void cursor();
  static VSC *swapscr = NULL;

  if (newconsole < 0 || newconsole >= CONS_NUM)
    return;
  nscr = &(vscreen[newconsole]);
  if (scr_text == NULL)
    {
      scr_text = (char *) malloc(dimx*dimy);
      scr_attr = (int *) malloc(sizeof(int)*dimx*dimy);
      if (scr_attr == NULL)
	SYSERR("out of memory");
      for(i=0;i<dimx*dimy;i++)
	{
	  scr_text[i] = ' ';
	  scr_attr[i] = sys_attr;
	}
    }
  if (swapscr == NULL)
    swapscr = nscr;
  else
     {
      nscr = swapscr;
      swapscr = NULL;
    }
}
int ch_codesystem()
{
  return codesys;
}
void ch_change_console(int newconsole)
{
  int i,j,lastmode;
  static void cursor();

  if (newconsole < 0 || newconsole >= CONS_NUM)
    return;

  con_change_console(newconsole);
  nscr = &(vscreen[newconsole]);
    
  if (scr_text == NULL)
    {
      scr_text = (char *) malloc(dimx*dimy);
      scr_attr = (int *) malloc(sizeof(int)*dimx*dimy);
      if (scr_attr == NULL)
	SYSERR("out of memory");
      for(i=0;i<dimx*dimy;i++)
	{
	  scr_text[i] = ' ';
	  scr_attr[i] = sys_attr;
	}
    }
  chconsole = newconsole;
  ch_change_input(newconsole);
  if (write_to_screen > 0)
    {
      ch_redraw();  
      ch_drawsystem();
    }
}

/*
   The function of 
        ch_cursor_blinked : control the cursor is blinked or not
	ch_have_cursor    : control the cursor should display in screen
	ch_cursor_rate    : control the blink rate of cursor
*/
static void cursor(int signo)
{ 
  if (!cursor_blinked )
    {
      return;
    }
  ch_cursor();
  signal(SIGALRM,( void (*)()) cursor);
  alarm(cursor_rate);
} 

void ch_reset_console(int c)
{
  VSC *nscr = vscreen+c;

  bottoml = dimy-1;
  topl = 0;
}

static void init_virtual_console()
{
  int i;
  ENTER;
  i = 0;

  low_color_table[0] = 0;  /* black */
  low_color_table[1] = 4;  /* red   */
  low_color_table[2] = 2;  /* green */
  low_color_table[3] = 6;  /* yellow*/
  low_color_table[4] = 1;  /* blue  */
  low_color_table[5] = 5;  /* purple*/
  low_color_table[6] = 3;  /* cyan  */
  low_color_table[7] = 7;  /* white */

  hi_color_table[0] = 0;  /* black */
  hi_color_table[1] = 12;  /* red   */
  hi_color_table[2] = 10;  /* green */
  hi_color_table[3] = 14;  /* yellow*/
  hi_color_table[4] = 9;   /* blue  */
  hi_color_table[5] = 13;  /* purple*/
  hi_color_table[6] = 11;  /* cyan  */
  hi_color_table[7] = 15;  /* white */
  color_table = low_color_table;
  COLOR_DEFAULT_FG = color_table[sys_config.forecolor];
  COLOR_DEFAULT_BG = color_table[sys_config.backcolor];
  COLOR_SYSTEM_FG = color_table[sys_config.systemcolor];
  COLOR_SYSTEM_BG = color_table[sys_config.systemback];
  mon_setcolor(COLOR_DEFAULT_FG+COLOR_DEFAULT_BG*256);

  for(nscr = &(vscreen[0]);i < CONS_NUM;i++,nscr = &(vscreen[i]))
    {
      curx = cury = 0;
      scr_text = NULL;
      scr_attr = NULL;
      dimx = 80;
      dimy = 29;
      cursor_x = cursor_y = 0;
      cursor_blinked = 1;
      no_cursor = 0;
      cursor_on = 0;
      cursor_rate = 1;
      codesys = CODE_BIG5;
      sys_attr = (COLOR_DEFAULT_BG<<24)|(COLOR_DEFAULT_FG<<16);
      mode = TEXT;
      autoscroll = 1;
      topl = 0;
      bottoml = dimy-1;
      oldx = -1;
      fontwidth = 8;
      fontheight = 16;
      automargin=0;
      quick_scroll = 0;
      line_out = 0;
      wordalign = 1;
      curfg = sys_config.forecolor;
      curbg = sys_config.backcolor;
      quote_char = 0;
    }
  ch_change_console(0);

  LEAVE;
}

void adm_init()
{
  init_virtual_console();
  load_sys_font_table();
  con_init();
  input_init();
  mon_setcolor(COLOR_DEFAULT_FG+(COLOR_DEFAULT_BG<<8));
  SYSERR2("COLOR %d %d",COLOR_DEFAULT_FG,COLOR_DEFAULT_BG);

}


demo_output()
{
  int i;

  ch_change_console(0);
  ch_graphicmode(0);
  ch_write_to_screen(1);
  for(i=0;i<10;i++)
    ch_showstr("TEST\n");
  ch_write_to_screen(0);
  sleep(10);
  ch_textmode(0);
}

	
ch_drawsystem()
{
  int ooldx = ch_wherex(),
      ooldy = ch_wherey();
  int i,oldw,color;
  int is_no_cursor;
  
  
  ENTER;
  is_no_cursor = no_cursor;
  i = 0;
  color = mon_curcolor();
  mon_setcolor(COLOR_SYSTEM_BG*256+COLOR_SYSTEM_FG);
  
  ch_goto_systemarea(0);
  for(i=0;i<dimx-1;i++)
    ch_showch(' ');
  ch_goto_systemarea(0);
  ch_showstr("[-");
  showcc('0'+chconsole);
  showcc(']');
  ch_goto_systemarea(65);
  ch_showstr("@:");
  ch_gotoxy(ooldx,ooldy);
  ch_input_redraw();
  SYSERR1("%d\n",dimy);
  if (dimy != MAX_DIMY)
    {
      ENTER;
      mon_setcolor(COLOR_SYSTEM_FG|(COLOR_SYSTEM_BG<<8));
      for(i=0;i<5;i++)
	mon_drawline(0,dimy*fontheight+i,dimx*8-1,dimy*fontheight+i);
    }
  mon_setcolor(color);
  LEAVE;
}

void ch_clear()
{
  int i,j;

  ch_cursor_blink(0);
  if (write_to_screen>0)
  	mon_clearblock(0,0,dimx-1,dimy*fontheight);
  ch_gotoxy(0,0);
  for(i=0;i<dimx;i++)
    for(j=0;j<dimy;j++)
      {
	scr_text[j*dimx+i] = ' ';
	scr_attr[j*dimx+i] = sys_attr;
      }
  ch_cursor_blink(1);
}

void ch_clear_console(int con)
{
  int i,j;
  VSC *nscr;

  if (con < 0 || con >= CONS_NUM)
    return;
  nscr = &vscreen[con];
  for(i=0;i<dimx;i++)
    for(j=0;j<dimy;j++)
      {
	scr_text[j*dimx+i] = ' ';
	scr_attr[j*dimx+i] = sys_attr;
      }
}

void ch_clreol()
{
  int i;

  if (write_to_screen>0)
    {
      ch_cursor_blink(0);
      mon_clearblock(curx,cury*fontheight,dimx-1,(cury+1)*fontheight);
      ch_cursor_blink(1);
    }
  for(i=curx;i<dimx-1;i++)
    {
      scr_text[cury*dimx+i] = ' ';
      scr_attr[cury*dimx+i] = sys_attr;
    }
}
void ch_system_clreol()
{
  int color,i;
  int oldw = autoscroll;
  if (write_to_screen>0)
    {
      autoscroll = 0;
      color = mon_curcolor();
      mon_setcolor(COLOR_SYSTEM_FG+COLOR_SYSTEM_BG*256);
      ch_cursor_blink(0);
      for(i=curx;i<dimx;i++)
	showcc(' ');
      autoscroll = oldw;  
      ch_cursor_blink(1);
      mon_setcolor(color);
    }
  for(i=curx;i<dimx-1;i++)
    {
      scr_text[cury*dimx+i] = ' ';
      scr_attr[cury*dimx+i] = sys_attr;
    }

}
  
void ch_cursor()
{
  if (cursor_on)
    {
      /* erase the last cursor if it be change place */
      if (curx != cursor_x || cury != cursor_y)
	{
	  if (write_to_screen>0)
	    mon_cursor(cursor_x,cursor_y*fontheight);
	  cursor_on = 0;
	  cursor_x = curx;
	  cursor_y = cury;
	}
    }
  else
    {
      cursor_x = curx;
      cursor_y = cury;
    }
  if (write_to_screen>0)
    mon_cursor(curx,cury*fontheight);
  cursor_on = 1 - cursor_on;
}

void ch_gotoxy(int x,int y)
{
  ch_cursor_blink(0);
  if (y > bottoml)
	y = bottoml;
  else if (y<topl)
	y = topl;
	
  if ((x >= 0) && (x < dimx) && (y >= 0) && (y < dimy))
    {
      if ((cury == MAX_DIMY) && (y != MAX_DIMY))
      {
	curx = x;
	cury = y;
      }
      else
      {
	curx = x;
	cury = y;
      }
      
      c_stack = 0;
      pos = cury*dimx+curx;
    }
  ch_cursor_blink(1);
}

static void showcc(CHAR c)
{
  int i;
  struct timeval timeout;

  ch_cursor_blink(0);  

  if (quote_char)
    {
      scr_text[pos] = c;
      scr_attr[pos] = sys_attr | QUOTE_CHAR;
      if ((write_to_screen>0)&&!quick_scroll)
	ch_drawtext(curx,cury,scr_text[pos]);
      advance();
      quote_char = 0;
      ch_cursor_blink(1);
      return;
    }

  switch(c)
    {
    case 7:
      {
	ioctl(ttyfd,KIOCSOUND,0x637);
	timeout.tv_usec = 100000;
	timeout.tv_sec = 0;
	select(255,NULL,NULL,NULL,&timeout);
	ioctl(ttyfd,KIOCSOUND,0);
      }
      break;
    case '\n':
      newline();
      break;
    case '\r':  
      ch_gotoxy(0,cury);
      pos = cury*dimx+curx;
      break;
    case '\b':
      ch_gotoxy(max(0,curx-1),cury);
      if (ch_needadjust(-1))
	input_insert_any(-1);
      break;
    case '\t':
      ch_gotoxy((curx / 8 +1)*8-1,cury);
      if (ch_needadjust(-1))
	input_insert_any(-1);
      pos = cury*dimx+curx;
      advance();
      break;
    default:
      scr_text[pos] = c;
      scr_attr[pos] = sys_attr&(~(COUPLE_LEFT|COUPLE_RIGHT));

      if ((write_to_screen>0)&&!quick_scroll)
	{
	  ch_attr(sys_attr);
	  ch_drawtext(curx,cury,scr_text[pos]);
	}
      advance();
    }
  ch_cursor_blink(1);
}
int _ch_redrawch(int x,int y)
{
  int pp;
  WORD code;
  int color,oldattr,ncolor;
  
  if (write_to_screen<=0)
      return;
  pp = y*dimx+x;
  
  oldattr = sys_attr;
  ch_attr(scr_attr[pp]);

  color = mon_curcolor();
  ncolor = scr_attr[pp]>>16;
  if (color != ncolor)
    mon_setcolor(ncolor);

  if ((!(scr_attr[pp]&QUOTE_CHAR)) &&(scr_attr[pp] & COUPLE_LEFT))
  {
    code = tran_code(codesys,scr_text[pp],scr_text[pp+1]);
    ch_drawctext(x,y,code);
    sys_attr = oldattr;
    return 1;
  }
  else
  {
    ch_drawtext(x,y,scr_text[pp]);
    sys_attr = oldattr;
    return 0;
  }
}

void ch_showch(CHAR c)
{
  WORD code,code1;


  if (quote_char)
    {
      showcc(c);
      return;
    }
  else if (c == 255)
    {
      quote_char = 1;
      return;
    }

/*  
  if (scr_attr[pos]&COUPLE_LEFT)
    scr_attr[pos+1] &= ~(COUPLE_RIGHT);
  else if (scr_attr[pos]&COUPLE_RIGHT)
    scr_attr[pos-1] &= ~(COUPLE_LEFT);
*/
  
  if ((curx != 0))
    if ((scr_attr[pos-1]&COUPLE_LEFT))
      {
	/* 
	   the left char is a left char,so we test if we can couple
	   with the left                 
	*/
	code = tran_code(codesys,scr_text[pos-1],c);
	if (code != 0xffff)
	  {
	    scr_text[pos] = c;
	    scr_attr[pos] = (sys_attr | COUPLE_RIGHT);
	    scr_attr[pos-1] |= COUPLE_LEFT;
	    if ((write_to_screen>0) && !quick_scroll)
	    {
	      ch_cursor_blink(0);
	      ch_drawctext(curx-1,cury,code);
	      ch_cursor_blink(1);
	    }
	    advance();
	    return;
	  }
      }

  /* the char can't couple with its left char */
  /* In this time test if can couple with the right */
  if (c < 127)
    {
      showcc(c);
    }
  else
    {
      scr_text[pos] = c;
      scr_attr[pos] = sys_attr|COUPLE_LEFT;
      advance();
    }
}
	  
void ch_showstr(CHAR *s)
{
  while(*s)
    {
      ch_showch(*s++);
    }
}
	  
int ch_wherex()
{
  return curx;
}
int ch_wherey()
{
  return cury;
}

void ch_setdim(int x,int y)
{
  dimx = x;
  dimy = y;
}
int ch_DimX()
{
  return dimx;
}
int ch_DimY()
{
  return dimy;
}

static void advance()
{
  ch_cursor_blink(0);
  curx++;pos++;
  if (curx >= dimx)
  {
    if (!automargin)
    {
      pos--;
      curx = dimx-1;
    }
    else
    {
      cury++;
      curx = 0;
      if (cury > bottoml)
      {
	if ( autoscroll)
	    ch_scroll(topl,bottoml,1);
	else
	    cury--;
	cury = bottoml;
	pos = cury*dimx+curx;
      }
    }
  }
  ch_cursor_blink(1);
}

static void newline()
{
  ch_cursor_blink(0);
  cury++;
  if (cury > bottoml)
    {
      if (autoscroll)
      {
	line_out++;
	quick_scroll++;
	ch_scroll(topl,bottoml,1);
	if( line_out >= (bottoml-topl) ) 
	{
	  ch_refresh();
	  SYSERR("REFRESH");
	}
      }
      cury = bottoml;
    }

  pos = cury*dimx+curx;
  ch_cursor_blink(1);
}

void ch_scroll(int ul,int dl,int l)
{
  int i,j;
  int attr;

  if (ul < 0 || dl >= dimy)
    return;

  if ((write_to_screen>0) && !line_out)
    {
      SYSERR("SCROLL");
      ch_cursor_blink(0);
      ch_cursor_blink(1);
      mon_scroll(ul*fontheight,(dl+1)*fontheight-1,l*fontheight);
    }
    

  for(j=ul;j<=dl-1;j++)
    {
      memcpy(scr_text+j*dimx,scr_text+(j+1)*dimx,dimx);
      memcpy(scr_attr+j*dimx,scr_attr+(j+1)*dimx,dimx*sizeof(int));
    }
  memset(scr_text+j*dimx,' ',dimx);
  attr = (low_color_table[sys_config.forecolor]+
         256*low_color_table[sys_config.backcolor])<<16;
  for(i=0;i<dimx;i++)
    scr_attr[j*dimx+i] = attr;

}

void ch_rscroll(int ul,int dl,int l)
{
  int i,j;
 
  ch_cursor_blink(0);
  if (write_to_screen>0)
    mon_rscroll(ul*fontheight,(dl+1)*fontheight-1,l*fontheight);
  ch_cursor_blink(1);
  for(j=dl-1;j>ul;j--)
    {
      memcpy(scr_text+j*dimx,scr_text+(j-1)*dimx,dimx);
      memcpy(scr_attr+j*dimx,scr_attr+(j-1)*dimx,dimx);
    }
  memset(scr_text+dl*dimx,' ',dimx);
  memset(scr_attr+dl*dimx,sys_attr,dimx);
}

/*
int ch_getch()
{
  return vga_getch();
}
*/
void adm_end()
{
  if (write_to_screen>0)
    mon_textmode(TEXT);
}
  
void ch_cursoron()
{
  if (!cursor_on)
    ch_cursor();
  ch_cursor_blink(1);
}

void ch_cursoroff()
{
  if (cursor_on)
    ch_cursor();
  ch_cursor_blink(0);
}

void ch_cursor_blink(int i)
{
  cursor_blinked += ((i == 0)? -1 : 1);
  if (no_cursor)
    {
      return;
    }
  
  if (cursor_blinked == 0 && (i == 0))
    {
      if (cursor_on)
	ch_cursor();
      signal(SIGALRM,SIG_IGN);
    }
  else if (cursor_blinked == 1 && (i == 1))
    {
      if (!cursor_on)
	ch_cursor();
      signal(SIGALRM,cursor);
      alarm(cursor_rate);
    }
}


void ch_cursor_rate(int rr)
{
  cursor_rate = rr;
  if (rr == 0)
    ch_cursor_blink(0);
      
}

void ch_underline(int i)
{

  if (i==1 && !und)
    {
      sys_attr |= UNDERLINE;
      und = 1;
      mon_underline(1);
    }
  else if ((i==0)&&und)
    {
      sys_attr &= ~UNDERLINE;
      und = 0;
      mon_underline(0);
    }

}
void ch_invert(int i)
{
  if (i==1)
    {
      sys_attr |= INVERT;
      inv = 1;
      mon_invert(1);
    }
  else 
    {
      sys_attr &= (0xffff0000|~INVERT);
      inv = 0;
      mon_invert(0);
    }
}

void ch_deletechar()
{
  int i;

  if (write_to_screen>0)
      mon_moveleft(curx,dimx-1,cury*fontheight,1);
  for(i=pos;i<pos+dimx-curx-1;i++)
    {
      scr_text[i] = scr_text[i+1];
      scr_attr[i] = scr_attr[i+1];
    }
  scr_text[i] = ' ';
  scr_attr[i] = sys_attr;
}

void ch_insertchar()
{
  int i;
  for(i=pos+dimx-curx-1;i>pos;i--)
    {
      scr_text[i] = scr_text[i-1];
      scr_attr[i] = scr_attr[i-1];
    }
  scr_text[pos] = ' ';
  scr_attr[pos] = sys_attr;
  if (write_to_screen>0)
    mon_moveright(curx,dimx-1,cury*fontheight,1);
  /*
  for(i=curx;i<dimx;i++)
    showch_attr(scr_text[pos+i-curx],scr_attr[pos+i-curx]);
    */
}

void ch_clearblock(int lx,int ty,int rx,int by)
{
  int i,j,pp;
  ch_cursor_blink(0);
  if( write_to_screen>0 )
    mon_clearblock(lx,ty*fontheight,rx,(by+1)*fontheight);
  ch_cursor_blink(1);
  for(j=ty;j<=by;j++)
    {
      pp = j*dimx+lx;
      for(i=lx;i<=rx;i++)
	{
	  scr_text[pp] = ' ';
	  scr_attr[pp++] = sys_attr;
	}
    }
}

void ch_insertline()
{
  ch_rscroll(cury,bottoml,1);
}

void ch_deleteline()
{
  SYSERR2("DELETELINE(%d,%d)\n",cury,bottoml-1);
  ch_scroll(cury,bottoml,1);
}

void ch_goto_systemarea(int loc)
{
  ch_have_cursor(0);
  if (oldx == -1)
    {
      oldx = curx;
      oldy = cury;
    }
  cury = MAX_DIMY;
  curx = loc;
  pos = cury*dimx+curx;
}

void ch_restore_cursor()
{
  if (oldx != -1)
    {
      curx = oldx;
      cury = oldy;
      oldx = -1;
    }
  ch_have_cursor(1);
}

void ch_showBIG5(WORD c)
{
  int color = mon_curcolor();
  if (write_to_screen>0)
      mon_setcolor(COLOR_SYSTEM_FG+COLOR_SYSTEM_BG*256);
  c = tran_code(CODE_BIG5,c/256,c%256);
  if (c != 0xffff)
    if (write_to_screen>0)
      {
	ch_cursor_blink(0);
	ch_drawctext(curx,cury,c);
	ch_cursor_blink(1);
      }
  if (write_to_screen>0)
      mon_setcolor(color);
}

static char *ttys = {"/dev/tty0"};

void ch_textmode(int con)
{
  int fd;
  if (con <0 || con >= CONS_NUM)
    return;
#if 0
  if (con == chconsole && (vscreen[con].screenmode != TEXT) )
#endif
    mon_textmode();
  vscreen[con].screenmode = TEXT;
}

void ch_graphicmode(int con)
{

  if ((con < 0) || (con >= CONS_NUM))
    return;
  ENTER;
  mon_grmode();
  vscreen[con].screenmode = G640x480x16;
  ch_drawsystem();
  ch_redraw();
  LEAVE;
}
static void ch_attr(int attr)
{
  if (attr&UNDERLINE)
    ch_underline(1);
  else
    ch_underline(0);
  if (attr&INVERT)
    ch_invert(1);
  else
    ch_invert(0);
}
static void showch_attr(char c,int attr)
{
  ch_attr(attr);  
  ch_showch(c);
}

void ch_redraw()
{
  if (write_to_screen)
    mon_clearblock(0,0,dimx-1,dimy*fontheight-1);
  ch_redraw_part(0);
}


static void ch_redraw_part(int st)
{
  int i,j,color;
  int ooldx = ch_wherex();
  int ooldy = ch_wherey();
  int scrollmode,curcorrate;
  int oldinv = inv;
  int oldund = und;
  
  ENTER;
  scrollmode = autoscroll;
  autoscroll = 0;
  quick_scroll = 0;
  ch_have_cursor(0);
  ch_gotoxy(0,0);
  c_stack = 0;
  color = mon_curcolor();
  for(j=st;j<dimy;j++)
  {
    ch_gotoxy(0,j);
    for(i=0;i<dimx;i++)
      {
	if (_ch_redrawch(i,j))
	    i++;
      }
  } 
  ch_invert(inv);
  ch_underline(und);
  
there:  
  mon_setcolor(color);
  ch_gotoxy(ooldx,ooldy);
  ch_have_cursor(1);
  cursor(SIGALRM);
  autoscroll = scrollmode;
  LEAVE;
}

void ch_write_to_screen(int m)
{
    
  write_to_screen += (m>0)? 1:-1;
}

void ch_restoretext()
{
  mon_textmode();
}

void ch_have_cursor(int st)
{
  if (st == 0)
    {
      no_cursor = 1;
      alarm(0);
      if (cursor_on)
	ch_cursor();
    }
  else
    {
      no_cursor = 0;
      ch_cursor();
    }
}

void ch_system_showstr(char *s)
{
  int color = mon_curcolor();
  int oldw = autoscroll;
  mon_setcolor(COLOR_SYSTEM_FG+COLOR_SYSTEM_BG*256);
  autoscroll = 0;
  ch_showstr(s);
  autoscroll = oldw;
  mon_setcolor(color);
}

void ch_system_showch(char c)
{
  int color = mon_curcolor();
  int oldw = autoscroll;
  mon_setcolor(COLOR_SYSTEM_FG+COLOR_SYSTEM_BG*256);
  autoscroll = 0;
  ch_showch(c);
  autoscroll = oldw;
  mon_setcolor(color);
}

void ch_setscroll(int t,int b)
{
  if (t < 0)
    t = 0;
  else if (t > dimy-3)
    t = dimy-3;
  if (b < 0)
    b = t + 2;
  if (b > dimy-2)
    b = dimy-1;
  bottoml = b;
  topl = t;
}

void ch_setwsize(int tty,int wx,int wy)
{
  VSC *nscr ;
  char *text;
  int  *attr;
  int olddimx,olddimy,i,j;
  if (tty > CONS_NUM)
    return;
  ENTER;
  nscr = &vscreen[tty];
  olddimx = dimx;
  olddimy = dimy;
  if (wx > MAX_DIMX)
    wx = MAX_DIMX;
  else if (wx < 0)
    wx = MIN_DIMX;

  if (wy > MAX_DIMY)
    wy = MAX_DIMY;
  else if (wy < 0)
    wy = 0;

  dimx = wx;
  bottoml = (dimy = wy)-1;
  if (scr_text==NULL)
    {
      LEAVE;
      return;
    }
  text = scr_text ;
  attr = scr_attr;
  scr_text = (CHAR *) malloc(dimx*dimy*sizeof(CHAR));
  scr_attr = (int *) malloc(dimx*dimy*sizeof(int));
  if (scr_attr == NULL)
    {
      SYSERR("Out of memory");
      if (scr_text)
	free(scr_text);
      scr_text = text;
      scr_attr = attr;
      LEAVE;
      return;
    }
  ENTER;
  for(i=0;i<dimx;i++) for(j=0;j<dimy;j++)
    {
      scr_text[j*dimx+i] = text[j*olddimx+i];
      scr_attr[j*dimx+i] = attr[j*olddimx+i];
    }
  free(text);
  free(attr);
  LEAVE;
}

void ch_drawstring(int xx,int yy,CHAR *stext)
{
  while(*stext)
    {
      ch_drawtext(xx,yy,*stext++);
      xx++;
      if (xx > dimx)
	{
	  yy++;
	  xx = 0;
	  if (yy > dimy)
	      yy = 0;
	}
    }
}

void ch_screen_saver(int stat)
{
  static int _posx,_posy;
  static char saver_string[] = " touch me! ";
    
  if (stat == START_SAVER)
    {
      ch_have_cursor(0);
      if (write_to_screen>0)
	  mon_clearblock(0,0,dimx-1,(dimy+1)*fontheight-1);
      _posx = _posy = 0;
      return;
    }
  else if (stat == RUN_SAVER)
    {
      _posx++;
      if (_posx > dimx-10)
	{
	  _posx = 0;
	  _posy++;
	  if (_posy > dimy)
	    {
	      _posy = 0;
	    }
	}
      ch_drawstring(_posx,_posy,saver_string);
    }
  else if (stat == END_SAVER)
    {
      ch_drawsystem();
      ch_redraw();
      ch_have_cursor(1);
    }
}

void Read_Console_Config()
{
  int i;
  char *tmp,*tok;

  if (tmp = getenv("CHDRV_COLOR_DEFINE"))
    sys_config.colordef = strdup(tmp);

  if (sys_config.colordef)
    {
      tok = strtok(sys_config.colordef," ");
      i = 0;
      while(tok&&(i<=7))
	{
	  low_color_table[i++] = atoi(tok);
	  tok = strtok(NULL," ");
	  printf("LOW COLOR %d is %d\n",i-1,low_color_table[i-1]);
	}
      i = 0;
      while(tok&&(i<=7))
	{
	  hi_color_table[i++] = atoi(tok);
	  tok = strtok(NULL," ");
	  printf("HIGH COLOR %d is %d\n",i-1,hi_color_table[i-1]);
	}
    }
}

void ch_automargin(int st)
{
    if (st == 0)
	automargin = 0;
    else
	automargin = 1;
}
void ch_quick_scroll(int st)
{
  quick_scroll = st;
}

int ch_is_quick_scroll()
{
  
  return quick_scroll;
}

void ch_refresh()
{
  int i;
  
  if (line_out == 0 && quick_scroll)
  {
    quick_scroll = 0;
    ch_cursor_blink(0);
    for(i=0;i<dimx;i++)
      if (_ch_redrawch(i,cury))
	i++;
    ch_cursor_blink(1);
  }
  else if (line_out)
  {
    ch_cursor_blink(0);
    if (write_to_screen>0)
	mon_scroll(topl*fontheight,(bottoml+1)*fontheight,line_out*fontheight);
    ch_redraw_part(bottoml-line_out+1);
    line_out = 0;
    ch_cursor_blink(1);
  }
}

int ch_fontheight()
{
  return fontheight;
}

int ch_fontwidth()
{
  return fontwidth;
}

void ch_makeup_attr()
{
    sys_attr &= 0x0000ffff;
    sys_attr |= (COLOR_DEFAULT_BG<<24)|(COLOR_DEFAULT_FG<<16);
    if (cursor_on)
      ch_cursor();
    mon_setcolor(COLOR_DEFAULT_FG+(COLOR_DEFAULT_BG<<8));
}
#if 0
void ch_parseconfig(char *str)
{
    char *ss;
    
    while(isspace(*str)) str++;
    ss = strchr(str,',');
    if (ss == NULL)
      return;
    *ss=0;
    COLOR_DEFAULT_FG = atoi(str);
    str = ss+1;
    
    while(isspace(*str)) str++;
    ss = strchr(str,',');
    if (ss == NULL)
      return;
    *ss=0;
    COLOR_DEFAULT_BG = atoi(str);
    str = ss+1;
    while(isspace(*str)) str++;
    ss = strchr(str,',');
    if (ss == NULL)
      return;
    *ss=0;
    COLOR_SYSTEM_FG = atoi(str);
    str = ss+1;
    while(isspace(*str)) str++;
    ss = strchr(str,',');
    if (ss == NULL)
      return;
    *ss=0;
    COLOR_SYSTEM_BG = atoi(str);
    ch_makeup_attr();
}
#endif
/*
   setup if we addjust the position of cursor to the begin of two-byte
   Chinese word.If con is -1 ,the default screen is used and if align
   is -1,the align mode does not changed.
*/
    
int ch_wordalign(int con,int align)
{
    int rtn = wordalign;
    VSC *ss;
    if (con == -1)
      ss = nscr;
    else
      ss = vscreen + con;
    if (align != -1)
      wordalign = align;
    return rtn;
}

/*
   Check if the current position need a position adjustment.If return value
   is 0,it stand for doesn't need a adjustment.Otherwise stand for need a
   adjustment.If con is -1,the default console is used.
 */  

int ch_needadjust(int con)
{
    VSC *ss;
    /* If  wordalign is disable,always return 0*/
    if (!wordalign) return 0;
    if (con == -1)
      ss = nscr;
    else
      ss = vscreen + con;

    if (ss->scrattr[pos]&COUPLE_RIGHT)
      return 1;
    else
      return 0;
}
	  
void ch_ansicolor(int fg,int bg)
{
  if (fg == -3)
    {
      color_table = low_color_table;
      COLOR_DEFAULT_FG = color_table[sys_config.forecolor];
      COLOR_DEFAULT_BG = color_table[sys_config.backcolor];
      ch_makeup_attr();
    }
  else if (fg == -2)
    {
      color_table = hi_color_table;
      COLOR_DEFAULT_FG = color_table[curfg];
      COLOR_DEFAULT_BG = color_table[curbg];
      ch_makeup_attr();
    }
  else
    {
      if ((fg >= 0)&&(fg <= 7))
	{
	  COLOR_DEFAULT_FG = color_table[fg];
	  curfg = fg;
	  ch_makeup_attr();
	}
      if ((bg >= 0)&&(bg <= 7))
	{
	  COLOR_DEFAULT_BG = color_table[bg];
	  curbg = bg;
	  ch_makeup_attr();
	}
    }
}
  


