#include "hd.h"
#include "classify.h"
#include "mydir.h"
#include "strings.h"

/* UNIMPLEMENTED */
/* Sun3 and Sun4s use a different a.out format, but the same magic
 *   numbers as the non-mips below -- the magic number is the fourth
 *   and fifth bytes instead of the first two.
 * NeXTs use a four byte magic number at the beginning of the file
 *   and it always has the value 0xfeedface.
 * Note that these machines also have reversed byte order */

#ifdef mips
#define	aout1		0x0160
#define	aout2		0x0162
#define	aout3		0x0180
#define	aout4		0x0182
#define	aout5		0x6001
#define	aout6		0x6201
#else
#define	aout1		0x0107
#define	aout2		0x0108
#define	aout3		0x010b
#define	aout4		0x0101
#define	aout5		0x0109
#define	aout6		0x0105
#endif

/* reverse byte order on Suns and NeXts */
/* not really sure if these are the best defines to use */

#if defined(mc6800) || defined(sparc) || defined(__NeXT__)
#define	cpio		0xc771
#define	ar		0x65ff
#define	packold		0x1f1f
#define	pack		0x1f1e
#define	compact		0xff1f
#define	compress	0x1f9d
#else
#define	cpio		0x71c7
#define	ar		0xff65
#define	packold		0x1f1f
#define	pack		0x1e1f
#define	compact		0x1fff
#define	compress	0x9d1f
#endif

/* Classify return the file type of parameter fname */

classify (fname) char * fname; 
{
    register unsigned mode;
    register int fdesc, rdlen;
    unsigned short word;
    int code;
    unsigned short wbuf[5];
    char *cp;
    char *lastfn(), *extension();

    if (stat (fname, &scr_stb)) return CL_NULL;

    mode = scr_stb.st_mode & S_IFMT;
    if (mode == S_IFDIR) return CL_DIR;
    if (mode != S_IFREG) return CL_SPCL;

    fdesc = open (fname, 0);
    if (fdesc < 0) return CL_PROTPLN;

    rdlen = read (fdesc, wbuf, sizeof wbuf);
    if (rdlen < sizeof word)
	code = CL_TEXT;
    else {
	word = wbuf[0];
	cp = (char *)wbuf;
	cp[8] = 0;
	/* Berkeley archive */
	if (rdlen >= 8 && !strcmp(cp, "!<arch>\n"))
		word = ar;
	/* System 5.0 archive (where will it end ?) */
	else {
		cp[4] = 0;
		if (rdlen >= 4 && !strcmp(cp, "<ar>"))
			word = ar;
	}
	switch (word) {
	case aout1:
	case aout2:
	case aout3:
	case aout4:
	case aout5:
	case aout6:
		code = CL_AOUT;
		break;
	case ar:
		code = CL_AR;
		break;
	case cpio:
		code = CL_CPIO;
		break;
	case pack:
	case packold:
		code = CL_PACK;
		break;
	case compact:
		code = CL_COMPACT;
		break;
	case compress:
		if (!strcmp(extension(fname), ".tar.Z"))
			code = CL_TARZ;
		else
			code = CL_COMPRESS;
		break;
	default:
		if (!strcmp(lastfn(fname), "core"))
			code = CL_CORE;
		else if (!strcmp(extension(fname), ".tar"))
			code = CL_TAR;
		/* Attempt to protect user from binary files */
		else if (istext(fdesc))
			code = CL_TEXT;
		else
			code = CL_UNKPLN;
	}
    }

    close (fdesc);
    return code;
}

/*
 * istext(fd) - test if file contents is text-like
 */
istext(fd)
int fd;
{
	register int i;
	register char *s;
	register int cc;
	char buf[500];

	i = read(fd, buf, 500);
	cc = 0;
	for (s = buf; i > 0; i--) {
		/* Test for NUL, parity bit, control codes */
		if (*s == 0 || (*s&0200) || (ascii[*s] == UD && *s != '\b'))
			cc++;
		s++;
		if (cc > 50)
			break;
	}
	return (i ? 0 : 1);
}

/* Lastfn returns a pointer to the last file name in path.  */

char *
    lastfn (path) register char *path; 
{
    register char *cp;

    for (cp=path; *cp++;);

    cp--;
    while (*--cp != '/' && cp >= path);

    return ++cp;
}

/* Extension returns a pointer to the extension of the last file name
 * in path. */

char *
    extension (path) register char *path; 
{
    register char *cp;

    for (cp=path; *cp++;);

    cp--;
    while (*--cp != '/' && cp >= path);

    for (++cp; *cp && *cp != '.'; ++cp);

    return cp;
}
