/* trim.c  ---  Truncate long strings to a given length
   
   Copyright (C) 1994  A.Matthias
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/* trim() truncates a pathname (oldstr) to "size" characters
   and returns it in newstr
*/

char* trim( char* oldstr, char* newstr, int size )
{
  char *ptr;
  
  if ( strlen( oldstr ) > (unsigned)size )
  {
    ptr = &oldstr[strlen( oldstr )-size+3];
    strcpy( &newstr[3], ptr );
    for ( ptr=newstr; ptr!=&newstr[3]; ptr++ )
      *ptr = '.';
  }
  else
  {
    strcpy( newstr, oldstr );
  }
  
  return newstr;
}

