/* softlabel.cc  ---  Writes the soft-label line (nc-style)  

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "softlabel.h"


Softlabel::Softlabel( char **newitems )
  {
    for ( int i=0; strcmp( newitems[i], "" )!=0; i++ )
      strcpy( items[i], newitems[i] );
    strcpy( items[i], "" );
    wptr = newwin( 1, SCR_X, SCR_Y-2, 0 );
  }


void Softlabel::change( char **newitems )
  {
    for ( int i=0; strcmp( newitems[i], "" )!=0; i++ )
      strcpy( items[i], newitems[i] ); 
    strcpy( items[i], "" );
    show();
  }
   

void Softlabel::show()
  {
    werase( wptr );
    wmove( wptr, SCR_Y-2, 0 );
    for( int i=0; strcmp( items[i], "" )!=0; i++ )
      {
	if ( strcmp( items[i], " " ) != 0 )
	  {
	  wstandout( wptr );
	  waddstr( wptr, items[i] );
	  wstandend( wptr );
	  waddstr( wptr, "  " );
	  }
      }
    wrefresh( wptr );
  }


void Softlabel::hide()
  {
  werase( wptr );
  wrefresh( wptr );
  }


Softlabel::~Softlabel()
  {
    delwin( wptr );
  }


