/* hexdump utility */

#include <stdio.h>
#include <ctype.h>

#define HD_VERSION "0.1 alpha"

FILE *fp;
int i, ch, chcnt=0, last16[16];
long chttl=0, startat=0;	

int main( int argc, char *argv[] )
  {
  if ( ( argc != 2 ) && ( argc != 3 ) )
    {
    fprintf( stderr, "usage: hd <filename> [<offset>]\n" );
    return( 1 );
    }
  if ( (fp=fopen( argv[1], "r" )) == NULL )
    {
    fprintf( stderr, "hd: file not found\n" );
    return( 1 );
    }

  if ( argc == 3 )
    {
    sscanf( argv[2], "%lx", &startat );
    startat -= startat%16;
    fseek( fp, startat, 0 );
    chttl = startat;
    }

  printf( "\nPortable hexdump utility %s (C) 1993 by A.Matthias\n\n", HD_VERSION );

  do
    {
    printf( "%6lx:\t", chttl );
    do
      {
      ch = fgetc( fp );
      if (ch!=EOF)
	{
	printf( "%02x ", (int)ch );
	last16[chcnt] = (int)ch;
	if (chcnt==7) printf( ". " );
	chcnt++;
	chttl++;
	}
      } while ( (ch!=EOF) && (chcnt<16) );
    printf( "   " );

    for ( i=chcnt; i<16; i++ )
      printf( "   " );
    if (chcnt<7) printf( "  " );

    for ( i=0; i<chcnt; i++ )
      {
      if ( isprint( last16[i] ) )
	printf( "%c", last16[i] );
      else
	printf( "." );
      if (i==7)
	printf( " " );
      }
    chcnt=0;
    printf( "\n" );
    } while ( ch!=EOF );

  fclose( fp );
  printf( "\n" );
  return( 0 );
  }
