/* del.cc  ---  "Deletes" files by moving them to another place

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <fstream.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <stdio.h>
#include "globals.h"
#include "config.h"

#define DEL_VERSION "0.3 alpha"

long getused( char *where );

char ddname[PATH_MAX];  // name of directory with deleted files
long newsize, ddsize;   // size of files to delete, size of already deleted
                        // files

// Returns the space used by "where" in Kbytes
long getused( char *where )
  {
  char tmp[PATH_MAX];
  long spaceused;
  sprintf( tmp, "du -k %s > %s%s", where, homedir, DUFILE );
  system( tmp );
  sprintf( tmp, "%s%s", homedir, DUFILE );
  ifstream f( tmp );
  f >> spaceused;
  f.close();
  sprintf( tmp, "rm %s%s", homedir, DUFILE );
  system( tmp );
  return( spaceused );
  }


int main( int argc, char *argv[] )
  {
  struct stat sbuf;
  int createit, rmit;
  char cmdline[PATH_MAX];
  char zipname[PATH_MAX];
  bool zipped;         // Was this file already compressed?

  if ( argc == 1 )     // Nothing to delete
    return 0;

  inithome();

  // Look for deleted files directory

  sprintf( ddname, DELDIR, DELBASEDIR, getuid() );
  if ( stat( ddname, &sbuf ) == -1 )
    {
    fprintf( stderr, "Directory %s does not exist. ", ddname );
    fprintf( stderr, "Create it? <y/N> " );
    createit = getchar();
    printf( "\n" );
    if ( ( (char)createit == 'Y' ) || ( (char)createit == 'y' ) )
      {
      sprintf( cmdline, "mkdir %s", ddname );
      system( cmdline );
      }
    else
      {
      fprintf( stderr, "Directory not created. Delete aborted\n" );
      return( 1 );
      }
    }
  
  for ( int i=1; i<argc; i++ )
    {
    if ( stat( argv[i], &sbuf ) == -1 )
      {
      printf( "Ignoring:\t%s\t(not found)\n", argv[i] );
      continue;
      }
    if ( ( (sbuf.st_mode&S_IFDIR) == S_IFDIR ) ||
	 ( (sbuf.st_mode&S_IFCHR) == S_IFCHR ) ||
	 ( (sbuf.st_mode&S_IFBLK) == S_IFBLK ) )
      {
      printf( "Ignoring:\t%s\t(not a regular file)\n", argv[i] );
      continue;
      }
    
    // Compress the file to be deleted
    // Here was a bug in 0.1: If the file is already compressed,
    // some compression programs will refuse to compress it again.
    // In this case, we must bypass the call to ZIPPER entirely.
    
    printf( "Processing:\t%s\n", argv[i] );

    // Test if extension of argv[i] is ZIPEXT
    if ( strcmp( &argv[i][strlen(argv[i])-strlen(ZIPEXT)], ZIPEXT ) != 0 ) 
      {
      sprintf( cmdline, "%s %s",  ZIPCMD, argv[i] );
      system( cmdline );
      sprintf( zipname, "%s%s", argv[i], ZIPEXT );
      zipped = FALSE;
      }
    else
      {
      strcpy( zipname, argv[i] );
      zipped = TRUE;
      }
    
  tryagain:
    // Now test how much free space we have in ddname
    ddsize = getused( ddname );
    newsize = getused( zipname );
    if ( newsize+ddsize < DELMAX )   // There is enough free space, proceed
      {
      if ( zipped == FALSE )
        sprintf( cmdline, "mv %s %s", zipname, ddname );
      else
        sprintf( cmdline, "mv %s %s/'&'%s", zipname, ddname, zipname );
      system( cmdline );
      sprintf( cmdline, "echo %s >> %s%s", argv[i], homedir, UNDELFILE );
      system( cmdline );
      }
    else                             // No more space, remove something
      {
      if ( newsize >= DELMAX )       // This file won't fit into ddname
        {
        fprintf( stderr, "File %s is bigger than undelete buffer. ", argv[i] );
        fprintf( stderr, "Remove it forever? <y/N> " );
        rmit = getchar();
        printf( "\n" );
        if ( ( (char)rmit == 'Y' ) || ( (char)rmit == 'y' ) )
          {
          sprintf( cmdline, "rm %s", zipname );
          system( cmdline );
          }
        else
          {
          printf( "File not removed. Restoring it.\n" );
          if ( zipped == FALSE )
            {
            sprintf( cmdline, "%s %s", UNZIPCMD, zipname );
            system( cmdline );
            }
          }
        }
      else                           // we must delete something older
        {
        // First get the name of the oldest entry
        char tmp[PATH_MAX], entry[PATH_MAX], zipentry[PATH_MAX];
        sprintf( tmp, "%s%s", homedir, UNDELFILE );
        ifstream f( tmp );
        f.getline( entry, PATH_MAX, '\n' );
        f.close();

        if ( entry[0]=='&' )
          zipped = TRUE;
        else
          zipped = FALSE;

        if ( zipped == FALSE )
          sprintf( zipentry, "%s%s", entry, ZIPEXT );
        else
          strcpy( zipentry, entry );

        // Now remove the file forever
        sprintf( cmdline, "rm %s%s", ddname, zipentry );
        system( cmdline );
        // And delete its entry from the list
        sprintf( cmdline, "more +2 %s%s > %s%s", 
                 homedir, UNDELFILE, homedir, TMPFILE );
        system( cmdline );
        sprintf( cmdline, "cp %s%s %s%s", 
                 homedir, TMPFILE, homedir, UNDELFILE );
        system( cmdline );
        sprintf( cmdline, "rm %s%s", homedir, TMPFILE );
        system( cmdline );
        goto tryagain;         // There is a goto in every good piece of code
                               // ;-)))
        }
      
      }
    
    }

  printf( "\n" );
  return( 0 );
  }



