/* config.h  ---  Global configuration options

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* In later releases much of this stuff should be set by autoconfiguration */
/* ! Edit this one to suit your needs ! */

// All files are created in $HOME, which must be defined at run-time
#define DIRFILE_L  ".nc.dir.L.tmp"
#define DIRFILE_R  ".nc.dir.R.tmp"
#define CWDFILE    ".nc.cwd.tmp"
#define PS1FILE    ".nc.ps1.tmp"
#define TREEFILE   ".nc.tree.tmp"
#define CMDFILE    ".nc.cmd.tmp"
#define KEYFILE    ".nc_keys"
#define PARAMFILE  ".nc.par.tmp"
#define DUFILE     ".nc.du.tmp"
#define UNDELFILE  ".nc.undel"
#define GETPS1     ".nc.getps1"
#define TMPFILE    ".nc.tmp"
#define SELFILE    ".nc.sel.tmp"
#define LOCALTMPDIR "/tmp/NCFTP.%d/" // %d stands for UID

// Undelete options
#define DELBASEDIR "/tmp/"    // Directory above undelete directories
#define DELDIR "%sncdel.%d/"  // Names of delete directories 
                              // %s stands for DELBASEDIR, %d is UID
#define DELMAX 500            // Max. size of undelete buffer (Kbytes)
#define ZIPCMD "gzip"         // Program used for compression (incl. options) 
#define UNZIPCMD "gunzip"     // Program used for decompression
#define ZIPEXT ".z"           // Extension added to zipped file by ZIPCMD
#define DELEXT ".d"           // Extension added to deleted files
#define DELZIPEXT ".D"        // Extension added to zipped deleted files

#define RCFILE    "~/.bashrc" // Shell initialization file

// These characters should be selected dynamically:
#define FRAME_CHAR_H ACS_HLINE
#define FRAME_CHAR_V ACS_VLINE
#define TAB_CHAR 0x09
#define ESCAPE_CHAR 27        // escape
#define META_CHAR 24          // ctrl-x
#define HIST_PREV 0x10        // ctrl-p
#define HIST_NEXT 0x0E        // ctrl-n
#define MARK_CHAR ' '         // space
#define SELECT_CHAR '+'       // normal or gray +
#define UNSELECT_CHAR '-'     // normal or gray -
#define NCD_CHAR 0x16         // ctrl-v
#define DELLN_CHAR 21         // ctrl-u
#define BS_CHAR KEY_BACKSPACE // ctrl-G on some systems

// Meta combination assignment
#define TREE_CHAR '0'
#define EXECONLY_CHAR '1'
#define READTREE_CHAR '2'
#define HEXVIEW_CHAR '3'

// The following are preceded by ESCAPE_CHAR
// #define CRSR_UP "[A"
// #define CRSR_DN "[B"
// #define CRSR_RT "[C"
// #define CRSR_LF "[D"

// Default screen resolution in characters (can be overridden by $LINES and $COLS)
// Normally you should not change this, use the environment variables instead.
// If you change these, you MUST also change DEF_FNAME_LEN
#define DEF_SCR_X 80
#define DEF_SCR_Y 25

// Length of *visible* filename (don't change it here, see inithome.cc)
#define DEF_FNAME_LEN 14
#define TRUNCATE_INDICATOR ">"

// Show file names in long line too (1/0) ? 
// Set this to 1 if your filesystem supports filenames longer
// than FNAME_LEN and you would like to see them untruncated in
// a separate line.
// 0 looks better and is slightly faster.
#define LONGNAMES 1

// Define this one, if you want to use the built-in prompt,
// undef it, if you want nc to evaluate the real $PS1. Evaluating
// the real $PS1 slows nc down and does not work as expected for
// some $PS1 configurations.
#define BUILTIN_PROMPT

// The string that separates the prompt string from the command line
// (leave this blank if your $PS1 already is separator-terminated)
#ifdef BUILTIN_PROMPT
  #define PS1_SEPARATOR "> "
#else
  #define PS1_SEPARATOR ""
#endif

// The string that separates the prompt string from the arg input line
#define ARG_SEPARATOR ": "

// Programs called via builtin keys
#define TREECMD "find / -type d -print"
#define HEXVIEW_CMD "$HOME/nc/hd"
#define PAGER  "less"
#define DEFAULT_EDITOR "emacs -nw"

// If you want a real time clock, set this to 1 else 0
#define RTC 1

// If you want the online time shown, set this to 1 else 0
// NOT SUPPORTED IN THIS VERSION
#define OTC 0

