/*
 * Configureable UNIX-specific stuff for GC v3.1
 */

#ifndef _UNIXCFG_H
#define _UNIXCFG_H

#define ININAME	".gc3ini"	/* Name of file in which path is saved	*/
#define INIANAME "/.gc3ini"	/* Absolute path of above 		*/
#define CODNAME	".gc3cod"	/* Name of compiled script file		*/
#define CODANAME "/.gc3cod"	/* Absolute path of above		*/

#define MAXPATHNAME	1024	/* Longest allowed path name length	*/
#define MAXFILENAME	256	/* Longest possible file name 		*/
#define MAXARGS		512	/* Maximum number of file per window	*/

#define HIST_LEN	20	/* Number of commands kept in history	*/
#define NUMMACROS	8	/* Number of keystroke macros		*/
#define MACROLEN	512	/* Maximum # of keystrokes/macro	*/

/*
 * Lots of curses key defs, for those whose curses doesn't define them.
 * You may want to modify the values if your curses is different; otherwise
 * you shouldn't need to change these.
 */

#ifndef KEY_DOWN
#define KEY_DOWN 0402	/* Sent by terminal left arrow key */
#endif

#ifndef KEY_UP
#define KEY_UP 0403	/* Sent by terminal left arrow key */
#endif

#ifndef KEY_LEFT
#define KEY_LEFT 0404	/* Sent by terminal left arrow key */
#endif

#ifndef KEY_RIGHT
#define KEY_RIGHT 0405	/* Sent by terminal right arrow key */
#endif

#ifndef KEY_PPAGE
#define KEY_PPAGE 0523	/* Previous page */
#endif

#ifndef KEY_NPAGE
#define KEY_NPAGE 0522	/* Next page */
#endif

#ifndef KEY_SF
#define KEY_SF 0520
#endif

#ifndef KEY_SR
#define KEY_SR 0521
#endif

#ifndef KEY_HOME
#define KEY_HOME 0406
#endif

#ifndef KEY_END
#define KEY_END	0550
#endif

#ifndef KEY_HELP
#define KEY_HELP 0553
#endif

#ifndef KEY_F0
#define KEY_F0 0410
#endif
#ifndef KEY_F1
#define KEY_F1 0411
#endif
#ifndef KEY_F2
#define KEY_F2 0412
#endif
#ifndef KEY_F3
#define KEY_F3 0413
#endif
#ifndef KEY_F4
#define KEY_F4 0414
#endif
#ifndef KEY_F5
#define KEY_F5 0415
#endif
#ifndef KEY_F6
#define KEY_F6 0416
#endif
#ifndef KEY_F7
#define KEY_F7 0417
#endif
#ifndef KEY_F8
#define KEY_F8 0420
#endif
#ifndef KEY_F9
#define KEY_F9 0421
#endif

#endif

