#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <stdio.h>
#ifdef NO_STRING_H
#include <strings.h> /* BSD systems use this as far as I know */
#else
#include <string.h>
#endif
#include <time.h>
#include <ctype.h>

#if __MSDOS__
#include <conio.h>
#include <io.h>
#include <dos.h>
#else
#include <errno.h>
#endif

#include "gc3.h"
#include "gcmem.h"
#include "gckey.h"
#include "gcops.h"

#if __STDC__

typedef void (*fptr)(void);

static short	lookupName(char *name);
static void	i_access(void);
static void	i_append(void);
static void	i_assign(void);
static void	i_beep(void);
static void	i_bind(void);
static void	i_call(void);
static void	i_cd(void);
static void	i_clear(void);
static void	i_colours(void);
static void	i_debug(void);
static void	i_down(void);
static void	i_echo(void);
static void	i_end(void);
static void	i_endloop(void);
static void	i_endrec(void);
static void	i_eval(void);
static void	i_exec(void);
static void	i_execcatch(void);
static void	i_expand(void);
static void	i_fcopy(void);
static void	i_filter(void);
static void	i_goto(void);
static void	i_head(void);
static void	i_help(void);
static void	i_helpall(void);
static void	i_helpkey(void);
static void	i_home(void);
static void	i_if(void);
static void	i_keycode();
static void	i_length(void);
static void	i_lookup(void);
static void	i_loopall(void);
static void	i_marked(void);
static void	i_markpat(void);
static void	i_markstr(void);
static void	i_matchespat(void);
static void	i_matchesstr(void);
static void	i_metakey();
static void	i_nextline(void);
static void	i_not(void);
static void	i_open(void);
static void	i_options(void);
static void	i_paint(void);
static void	i_pgdn(void);
static void	i_pgup(void);
static void	i_playmac(void);
static void	i_read(void);
static void	i_recmac(void);
static void	i_rescan(void);
static void	i_return(void);
static void	i_returnvar(void);
static void	i_search(void);
static void	i_searchpat(void);
static void	i_setexpr(void);
static void	i_setmatch(void);
static void	i_show(void);
static void	i_sleep(void);
static void	i_sort(void);
static void	i_split();
static void	i_swap(void);
static void	i_tail(void);
static void	i_test(void);
static void	i_typeof(void);
static void	i_unbind(void);
static void	i_unlink(void);
static void	i_unmarkpat(void);
static void	i_unmarkstr(void);
static void	i_up(void);

#else

typedef void (*fptr)();

static short	lookupName();

static void
	i_access(), i_append(), i_assign(),i_beep(),i_bind(),i_call(),
	i_cd(), i_clear(), i_colours(), i_debug(),
	i_down(),i_echo(),i_end(),i_endloop(), i_endrec(), i_eval(), 
	i_exec(),i_execcatch(),i_expand(), i_fcopy(),i_filter(),
	i_goto(),i_head(),i_help(), i_helpall(),i_helpkey(),
	i_home(),i_if(), i_keycode(), i_length(), i_lookup(),i_loopall(),
	i_marked(),i_markpat(),i_markstr(),
	i_matchespat(),i_matchesstr(),i_metakey(), i_nextline(),
	i_not(), i_open(), i_options(), i_paint(),i_pgdn(),
	i_pgup(), i_playmac(),
	i_read(),i_recmac(), i_rescan(),i_return(),i_returnvar(),
	i_search(), i_searchpat(), i_setexpr(), 
	i_setmatch(), i_show(),i_showcatch(),
	i_sleep(),i_sort(),i_split(),i_swap(),i_tail(),i_test(),
	i_typeof(),i_unbind(),i_unlink(),i_unmarkpat(),
	i_unmarkstr(),i_up();
#endif

static fptr execTbl[] = {
	i_access, i_append, i_assign, i_beep, i_bind,
	i_call, i_cd, i_clear, i_colours, i_debug,
	i_down, i_echo, i_end, i_endloop, i_endrec, i_eval, i_exec,
	i_execcatch, i_expand, i_fcopy, i_filter, i_goto, i_head, 
	i_help, i_helpall, i_helpkey, i_home, i_if, i_keycode,
	NULL, i_length, i_lookup, i_loopall, i_marked, i_markpat,
	i_markstr, i_matchespat, i_matchesstr, i_metakey,
	i_nextline, i_not, i_open,
	i_options, i_paint, i_pgdn, i_pgup, i_playmac, NULL,
	i_read, i_recmac, i_rescan, i_return, i_returnvar, i_search,
	i_searchpat, i_setexpr, i_setmatch, i_show, i_sleep, i_sort,
	i_split, i_swap, i_tail, i_test, i_typeof,
	i_unbind, i_unlink, i_unmarkpat, i_unmarkstr, i_up
};

#include "gcopcnt.c"

#define PARAM(n)	codespace[old_ip+n]

#ifndef min
#define min(a,b)	(((a)<(b))?(a):(b))
#endif

static int	loopP = 0;	/* Loop nest level	*/
static loopInfo loopStack[8];
static int	returnVal;	/* Last return value	*/
static short	ipStack[16]; /* Instruction pointer stack */
static short	ipStkLvl = 0,
		old_ip;
static char	*valspace[MAXVARS] = {NULL};
static FILE	*catchFP=NULL;
static short	ip = 0;

int		noDirSelect = 1;
int		fnameLen = 22;
int		dirsFirst = 1;
int		showHidden = 1;
int		followLinks = 1;
char		tempName[MAXPATHNAME];

#ifdef __MSDOS__
	char	filters[2][64] = { "*.*", "*.*" };
#else
	char	filters[2][64] = { ".", "." };
#endif

#ifdef SYS_V
#define randomize()	srand48((long)time(NULL))
#define random(n)	(lrand48() % (n))
#else
#define randomize()	srand((int)time(NULL))
#define random(n)	(rand() % (n))
#endif

#if __STDC__
static void promptForKey(void) {
#else
static void promptForKey() {
#endif
	fprintf(stderr,"\nPress a key...");
	fflush(stderr);
	(void)my_getch();
}

#if	__STDC__
static int prepareRE(char *re) {
#else
static int prepareRE(re)
	char *re;
{
#endif
	char *dbg;
	dbg = compileRE(re);
	if (dbg) {
		showMsg(dbg);
		return -1;
	} else return 0;
}

#if __STDC__
static char *randname(void) {
#else
static char *randname() {
#endif
	static char _randname[10];
	int i=0;
	(void)randomize();
	while (i<8) _randname[i++] = 'A' + (char)random(26);
	_randname[8] = '\0';
	return _randname;
}

/********************************************************
		FILE SELECTION
*********************************************************/

#if	__STDC__
static void pselect(fInfo_t *p, int v) {
#else
static void pselect(p, v)
	fInfo_t *p;
	int v;
{
#endif /* __STDC__ */
	if (v) {
		if (noDirSelect && S_ISDIR(p->mode)) return;
		if ((p->flag & F_SELECTED)==0) {
			p->flag |= F_SELECTED;
			selCnt[l]++;
			selSize[l]+=p->size;
		}
	} else {
		if (p->flag & F_SELECTED) {
			p->flag &= ~F_SELECTED;
			selCnt[l]--;
			selSize[l]-=p->size;
		}
	}
}

#if	__STDC__
static void nselect(int n, int v) {
#else
static void nselect(n, v)
	int n;
	int v;
{
#endif /* __STDC__ */
	pselect(&fInfo[l][n],v);
}

/***************************************************************/

#if __STDC__
static char *expand(char *str, int buf) {
#else
static char *expand(str, buf)
	char *str;
	int buf;
{
#endif
	int i, j, L;
	for (i=j=0, L = (int)strlen(str); i<L && j<BUFFER_SIZE;i++) {
		if (str[i]=='\\') {
			switch (str[++i]) {
			case 'n':
				BUF[buf][j++] = '\n';
				break;
			case 'r':
				BUF[buf][j++] = '\r';
				break;
			case 't':
				BUF[buf][j++] = '\t';
				break;
			case '\\':
				BUF[buf][j++] = '\\';
				break;
			default:
#ifdef __MSDOS__
				/* Under DOS we only treat \ as an
				   escape in these three cases - in
				   every other case we leave the \ in,
				   as it may be a path separator */
				if (str[i]!='$') BUF[buf][j++]='\\';
#endif
				BUF[buf][j++] = str[i];
			}
		} else if (str[i]=='$') {
			char varname[40]; int p=0; short idx;
			i++;
			while (isalnum((int)str[i]) || str[i]=='_') 
				varname[p++] = str[i++];
			varname[p] = '\0';
			i--;
			STRUPR(varname);
			if ((idx = lookupName(varname))>=0) {
				int buf2 = getBuffer(1);
				strcpy(BUF[buf]+j,lookupVar(idx,buf2));
				releaseBuffer(buf2,500);
			} else { /* No such variable */
				BUF[buf][j++] = '$';
				strcpy(BUF[buf]+j,varname);
			}
			j = (int)strlen(BUF[buf]);
		} else BUF[buf][j++] = str[i];
	}
	BUF[buf][min(j,(BUFFER_SIZE-1))]='\0';
	if (j>=BUFFER_SIZE) showMsg("Buffer overflow!");
	return BUF[buf];
}

#if	__STDC__
int findFile(int s, char *fname, int *idx) {
#else
int findFile(s, fname, idx)
	int s, *idx;
	char *fname;
{
#endif
	int i = s;
	do {
		if (strcmp(fInfo[l][fIndex[l][i]].name,fname)==0) {
			if (idx) *idx=fIndex[l][i];
			return i;
		}
		i = (i+1) % numfiles[l];
	} while (i!=s);
	return -1;
}

#if	__STDC__
static int findMatch(int s, char *re, int *idx) {
#else
static int findMatch(s, re, idx)
	int s, *idx;
	char *re;
{
#endif
	int i;
	returnVal=1;
	if (re==NULL || prepareRE(re)==0) {
		i = s;
		do {
			if (matchRE(fInfo[l][fIndex[l][i]].name)==1) {
				if (idx) *idx=fIndex[l][i];
				return i;
			}
			i = (i+1) % numfiles[l];
		} while (i!=s);
	}
	returnVal = 0;
	return -1;
}

#if	__STDC__
static short lookupName(char *name) {
#else
static short lookupName(name)
	char *name;
{
#endif
	int i;
	for (i=0;i<idents;i++)
		if ((objects[i].type & VAR_TYPE) &&
			strcmp(name,stringspace+namemap[i])==0)
				return objects[i].p;
	return -1;
}

#if __STDC__
static char *lookupString(short idx, int buf) {
#else
static char *lookupString(idx, buf)
	short idx;
{
#endif
	return expand(stringspace+idx, buf);
}

#if __STDC__
static void buildList(char *buf, int l, int doAll) {
#else
static void buildList(buf, l, doAll)
	char *buf;
	int l, doAll;
{
#endif
	int i, len = 1;
	for (i=0;i<numfiles[l];i++) {
		if (doAll || (fInfo[l][fIndex[l][i]].flag & F_SELECTED)) {
			char *name = fInfo[l][fIndex[l][i]].name;
			len += strlen(name)+1;
			if (len>=BUFFER_SIZE) {
				showMsg("Buffer overflow!");
				break;
			}
			if (buf[0]) strcat(buf," ");
			strcat(buf,name);
		}
	}
}

#if __STDC__
char *lookupVar(short idx, int buf) {
#else
char *lookupVar(idx, buf)
	short idx;
	int buf;
{
#endif
	struct tm *tp; time_t tv;
	char *cmd, *rtn = "";
	BUF[buf][0] = '\0';
	switch(idx) {
	case VAR_PFILE:
		rtn = fInfo[l][fIndex[l][highlight[l]]].name;
		break;
	case VAR_SFILE:
		rtn = fInfo[1-l][fIndex[1-l][highlight[1-l]]].name;
		break;
	case VAR_PFILES:
		buildList(rtn=BUF[buf],l,1);
		break;
	case VAR_PSEL:
		buildList(rtn=BUF[buf],l,0);
		break;
	case VAR_SFILES:
		buildList(rtn=BUF[buf],1-l,1);
		break;
	case VAR_SSEL:
		buildList(rtn=BUF[buf],1-l,0);
		break;
	case VAR_PPATH:
		rtn = paths[l];
		break;
	case VAR_SPATH:
		rtn = paths[1-l];
		break;
	case VAR_PSELSIZE:
		sprintf(rtn = BUF[buf],"%ld",selSize[l]);
		break;
	case VAR_SSELSIZE:
		sprintf(rtn = BUF[buf],"%ld",selSize[1-l]);
		break;
	case VAR_PSELCNT:
		sprintf(rtn = BUF[buf],"%d",selCnt[l]);
		break;
	case VAR_SSELCNT:
		sprintf(rtn = BUF[buf],"%d",selCnt[1-l]);
		break;
	case VAR_PSIZE:
		sprintf(rtn = BUF[buf],"%ld",fInfo[l][fIndex[l][highlight[l]]].size);
		break;
	case VAR_SSIZE:
		sprintf(rtn = BUF[buf],"%ld",fInfo[1-l][fIndex[1-l][highlight[l]]].size);
		break;
#ifndef __MSDOS__
	case VAR_NAME:
		rtn = (char *)getlogin();
		break;
#endif
	case VAR_TEMPNAME:
#ifdef __MSDOS__
		if ((rtn = getenv("TMP"))!=NULL) strcpy(BUF[buf],rtn);
		else strcpy(BUF[buf],"\\");
		if (BUF[buf][strlen(BUF[buf])-1] != '\\')
			strcat(BUF[buf],"\\");
		strcat(rtn = BUF[buf],tempName);
#else
		rtn = tempName;
#endif
		break;
	case VAR_DATE:
		tp = localtime((tv=time(NULL),&tv));
		sprintf(rtn = BUF[buf],"%2d/%02d/%02d",
			tp->tm_year,tp->tm_mon,tp->tm_mday);
		break;
	case VAR_TIME:
		tp = localtime((tv=time(NULL),&tv));
		sprintf(rtn = BUF[buf],"%2d:%02d:%02d",
			tp->tm_hour,tp->tm_min,tp->tm_sec);
		break;
	case VAR_RANDOM:
		rtn = randname();
		break;
	case VAR_PREVCMD:
		cmd = getPrevCmd();
		strncpy(rtn = BUF[buf],cmd?cmd:"",BUFFER_SIZE-1);
		break;
	case VAR_NEXTCMD:
		cmd = getNextCmd();
		strncpy(rtn = BUF[buf],cmd?cmd:"",BUFFER_SIZE-1);
		break;
	case VAR_DISKFREE: /* Disk space free */
		getDiskSpace(paths[l]);
		sprintf(rtn = BUF[buf],"%ld",freeSpace);
		break;
	case VAR_DISKUSED: /* Disk space used */
		getDiskSpace(paths[l]);
		sprintf(rtn = BUF[buf],"%ld",usedSpace);
		break;
	case VAR_SHELL:
#ifdef __MSDOS__
		cmd = getenv("COMSPEC");
#else
		cmd = getenv("SHELL");
#endif
		rtn = cmd?cmd:"";
		break;
	case VAR_LINEBUFF:
	case VAR_MESSAGE:
	case VAR_CH:
	default:
		rtn = valspace[idx] ? valspace[idx] : "<undef>";
		break;
	}
	if (rtn != BUF[buf]) strcpy(BUF[buf],rtn);
	return BUF[buf];
}

#if	__STDC__
void assign2var(short varnum, char *val) {
#else
void assign2var(varnum, val)
	short varnum;
	char *val;
{
#endif /* __STDC__ */
	unsigned nb = strlen(val)+1;
	if (valspace[varnum]) 
		valspace[varnum] = Mem_Realloc(valspace[varnum],nb,2);
	else valspace[varnum] = Mem_Calloc(nb,sizeof(char),3);
	if (valspace[varnum]) strcpy(valspace[varnum],val);
	else {
		int buf = getBuffer(2);
		sprintf(BUF[buf],"Failed to allocate space for $%s",
			stringspace+namemap[varnum]);
		showMsg(BUF[buf]);
		releaseBuffer(buf,501);
	}
}

#if	__STDC__
void freeVars(void) {
#else
void freeVars() {
#endif
	int i;
	for (i=0;i<MAXVARS;i++) {
		if (valspace[i]) {
			Mem_Free(valspace[i],13);
			valspace[i] = NULL;
		}
	}
}

#if __STDC__
static void runCommand(char *cmd, int catch) {
#else
static void runCommand(cmd, catch)
	char *cmd;
	int catch;
{
#endif
	int err, buf = getBuffer(16);
#ifdef __MSDOS__
	int len = (6*catch)+strlen(tempName)+1;
	if (catch) strcpy(BUF[buf],"rse ");
	else BUF[buf][0]='\0';
#else
	int len = (7*catch)+strlen(tempName)+1;
	BUF[buf][0]='\0';
#endif
	len += strlen(cmd);
	if (len>BUFFER_SIZE) {
		showMsg("Buffer overflow!");
		releaseBuffer(buf,617);
		returnVal = 0;
		return;
	}
	strcat(BUF[buf], cmd);
	if (catch) {
		strcat(BUF[buf]," >");
		strcat(BUF[buf],tempName);
#ifndef	__MSDOS__
	 	strcat(BUF[buf]," 2>&1");
#endif
		if (catchFP) {
			fclose(catchFP);
			unlink(tempName);
			catchFP = NULL;
		}
		showMsg(BUF[buf]);
	} else {
		int buf2 = getBuffer(83);
		exitCurses();
		strcpy(BUF[buf2],cmd);
		STRUPR(BUF[buf2]);
		if (strcmp(BUF[buf2],"$SHELL")==0)
			fprintf(stderr,"Type `exit' to return to GC\n");
		releaseBuffer(buf2,593);
		fprintf(stderr,"%s\n",BUF[buf]);
	}
	returnVal = (system(BUF[buf])==0);
	err = errno;
	releaseBuffer(buf,618);
	if (catch) {
		catchFP = fopen(tempName,"r");
		i_nextline();
	}
	getCWD(paths[l]);
	if (!catch) setupCurses(NULL);
	else {
		doCD(paths[l],fInfo[l][fIndex[l][highlight[l]]].name);
		readList(1-l,fInfo[1-l][fIndex[1-l][highlight[1-l]]].name,0);
	}
#ifndef NO_STRERROR
	if (returnVal==0) showMsg((char *)strerror(err));
#endif
}

#if	__STDC__
void doDefaultAction(int ch) {
#else
void doDefaultAction(ch)
	int ch;
{
#endif
	int buf = getBuffer(4);
	BUF[buf][0] = (char)ch;
	BUF[buf][1] = '\0';
	clearCmdWin();
	if (getInput(BUF[buf],-78,1)) {
		int buf2 = getBuffer(44);
		expand(BUF[buf],buf2);
		runCommand(BUF[buf2],0);
		releaseBuffer(buf,505);
	}
	releaseBuffer(buf,504);
}

/**********************************************************************/

#ifdef __STDC__
#define DF(n)	static void n(void)
#else
#define DF(n)	static void n()
#endif

DF(i_access) {
	int buf = getBuffer(90);
	returnVal = !access(lookupString(PARAM(1),buf), PARAM(2));
	releaseBuffer(buf,505);
}

DF(i_append) {
	int buf = getBuffer(6);
	char *fname = lookupString(PARAM(1),buf);
	FILE *fp = fopen(fname,"a");
	if (fp) {
		int buf2 = getBuffer(7);
		fputs(lookupString(PARAM(2),buf2),fp);
		releaseBuffer(buf2,506);
		fclose(fp);
		returnVal = 1;
	} else returnVal = 0;
	releaseBuffer(buf,507);
}

DF(i_assign) {
	int buf = getBuffer(8);
	assign2var(PARAM(1), lookupString(PARAM(2),buf));
	releaseBuffer(buf,508);
}

DF(i_beep)		{ BEEP; }

DF(i_bind) {
	short k = PARAM(1);
	KeyTbl[k].ip = PARAM(2);
	KeyTbl[k].hlp = stringspace + PARAM(3);
}

DF(i_call) {
	short p = PARAM(1);
	if (p<0) {
		/* run-time link */
		int i, buf = getBuffer(9);
		STRUPR(lookupString(-p,buf));
		for (i=0;i<idents;i++) {
			if (objects[i].type&FUNC_TYPE) {
				if (strcmp(BUF[buf],stringspace+namemap[i])==0) {
					p = objects[i].p;
					break;
				}
			}
		}
		if (p<0) {
			int buf2 = getBuffer(10);
			sprintf(BUF[buf2],"%s is undefined",lookupString(-p,buf));
			showMsg(BUF[buf2]);
			releaseBuffer(buf,509);
			releaseBuffer(buf2,510);
			returnVal = 0;
			return;
		}
		releaseBuffer(buf,511);
	}
	ipStack[ipStkLvl++] = ip;
	ip = p;
}

DF(i_cd) {
	int buf = getBuffer(11);
	doCD(lookupString(PARAM(1),buf),NULL);
	releaseBuffer(buf,512);
}

DF(i_clear)		{ clrscr(); }
DF(i_colours)	{ setColorAttr(PARAM(1),PARAM(2)); clrscr(); }

#if __STDC__
static void showVariables(void) {
#else
static void showVariables() {
#endif
	int i, r;
	clrscr();
	for (i=r=0;i<idents;i++) {
		if ((objects[i].type&FUNC_TYPE)==0) {
			int buf = getBuffer(12);
			(void)lookupVar((int)objects[i].p,buf);
			if ((int)strlen(BUF[buf])>60) strcpy(BUF[buf]+60,"...");
			fprintf(stderr,"%-12s %s\n\r",
				stringspace+namemap[i],BUF[buf]);
			releaseBuffer(buf,513);
			r++;
			if (r==20) {
				promptForKey();
				r = 0;
				clrscr();
			}
		}
	}
	promptForKey();
	clrscr();
}

DF(i_debug)	{ showVariables(); }
DF(i_down)	{ cursorDown();	}

DF(i_echo) {
	int buf = getBuffer(13);
	clearCmdWin();
	showMsg(lookupString(PARAM(1),buf));
	releaseBuffer(buf,514);
}

DF(i_end)	{ cursorEnd(); }

DF(i_endloop) {
	int p = loopP-1;
	if (loopP) {
		if (loopStack[p].pos < numfiles[l]) {
			assign2var(loopStack[p].v,
				fInfo[l][fIndex[l][loopStack[p].pos++]].name);
			ip = loopStack[p].s;
		} else loopP--;
	}
}

DF(i_endrec) { endRecord(); }

DF(i_eval) { /* evaluate expression in string */
	int rtn;
	int buf = getBuffer(14);
	char *msg = compute(lookupString(PARAM(1),buf),&rtn);
	releaseBuffer(buf,515);
	if (msg) showMsg(msg);
	else returnVal = rtn;
}

DF(i_exec) {
	int buf = getBuffer(16);
	runCommand(lookupString(PARAM(1),buf),0);
	releaseBuffer(buf,651);
}

DF(i_execcatch) {
	int buf = getBuffer(16);
	runCommand(lookupString(PARAM(1),buf),1);
	releaseBuffer(buf,651);
}

DF(i_expand) {
	int buf = getBuffer(18), buf2 = getBuffer(18);
	assign2var(PARAM(1), expand(lookupVar(PARAM(1),buf),buf2));
	releaseBuffer(buf,519);
	releaseBuffer(buf2,520);
}

DF(i_fcopy) {
	int buf = getBuffer(19), buf2 = getBuffer(20);
#ifdef __MSDOS__
	doFileCopy(lookupString(PARAM(1),buf),
		   lookupString(PARAM(2),buf2),
		   (int)PARAM(3));
#else
	char *f;
	strcpy(BUF[buf],PARAM(3)?"mv ":"cp ");
	f = lookupString(PARAM(1),buf2);
	if (((int)strlen(f)+10) < BUFFER_SIZE) {
		strcat(BUF[buf],f);
		strcat(BUF[buf]," ");
		f = lookupString(PARAM(2),buf2);
		if (((int)strlen(BUF[buf])+(int)strlen(f)+(int)strlen(tempName)+10) < BUFFER_SIZE) {
			strcat(BUF[buf],f);
			strcat(BUF[buf]," >");
			strcat(BUF[buf],tempName);
		 	strcat(BUF[buf]," 2>&1");
			if (catchFP) {
				fclose(catchFP);
				unlink(tempName);
				catchFP = NULL;
			}
			returnVal = !system(BUF[buf]);
			catchFP = fopen(tempName,"r");
			i_nextline();
			showMsg(lookupVar(16,buf));
		} else showMsg("Buffer overflow!");
	} else showMsg("Buffer overflow!");
#endif
	releaseBuffer(buf2,521);
	releaseBuffer(buf,522);
}

DF(i_filter) {
	int buf = getBuffer(21);
	strcpy(filters[l], lookupString(PARAM(1),buf));
	releaseBuffer(buf,523);
#ifdef __MSDOS__
	if (filters[l]=='\0') strcpy(filters[l],"*.*");
#else
	if (filters[l]=='\0') strcpy(filters[l],".");
#endif
	refilter(l, fInfo[l][fIndex[l][highlight[l]]].name);
}

DF(i_goto)	{ ip = PARAM(1); }

DF(i_head) {
	short len=PARAM(1);
	int buf = getBuffer(22);
	short L = (short)strlen(lookupVar(PARAM(2),buf));
	if (len>=0) BUF[buf][min(len,L)]='\0';
        else BUF[buf][L-min(-len,L)] = '\0';
	assign2var(PARAM(2),BUF[buf]);
	releaseBuffer(buf,524);
}

DF(i_help) {
	showMsg(KeyTbl[PARAM(1)].hlp);
}

DF(i_helpkey) {
	int i = getKeyBinding(my_getch(),0);
	clearCmdWin();
	if (i>=0 && KeyTbl[i].ip && KeyTbl[i].hlp) showMsg(KeyTbl[i].hlp);
	else showMsg("No help for this key");
}	

#if __STDC__
static void showHelp(char *fmt, int arg, int idx, int *row) {
#else
static void showHelp(fmt, arg, idx, row)
	char *fmt;
	int arg;
	int idx;
	int *row;
{
#endif
	char buf[20];
	if (*row==0) {
		fprintf(stderr,"\n\rKey\tAction\n\r===\t============================================================\n\r");
		*row = 1;
	}
	if (KeyTbl[idx].ip && KeyTbl[idx].hlp!=NULL) {
		(*row)++;
		sprintf(buf,fmt,arg);
		fprintf(stderr,"%s\t%s\n\r",buf,KeyTbl[idx].hlp);
	}
	if ((*row)>NUM_FILES) {
		*row = 0;
		promptForKey();
	    	clrscr();
	}
}

static char *(cursorKeyNames[]) = {
	"Up", "Down", "Left", "Right",
	"PgUp", "PgDn", "Home", "End",
	"CtlLeft", "CtlRight", "CtlUp", "CtlDown",
	"CtlPgUp", "CtlPgDn", "CtlHome", "CtlEnd",
	"Ins", "Del", "Bkspc"
};

#if __STDC__
static void showAllHelp(void) {
#else
static void showAllHelp() {
#endif
	int i=0, r=0;
	clrscr();
	while (i<19) { showHelp(cursorKeyNames[i],0,i,&r);	i++; }
	showHelp("#%d",i,i,&r); i++;
	while (i<30) { showHelp("F%d",i-19,i,&r);		i++; }
	while (i<56) { showHelp("Ctrl-%c",i+'A'-30,i,&r);	i++; }
	while (i<60) { showHelp("#%d",i,i,&r); 			i++; }
#if __MSDOS__
	while (i<70) { showHelp("Alt-%d",i-60,i,&r);		i++; }
	while (i<96) { showHelp("Alt-%c",i-70+'A',i,&r);	i++; }
#else
	while (i<70) { showHelp("Meta-%d",i-60,i,&r);		i++; }
	while (i<96) { showHelp("Meta-%c",i-70+'A',i,&r);	i++; }
#endif
	while (i<100) { showHelp("#%d",i,i,&r);			i++; }
	showHelp("Space",0,i,&r);i++;
	while (i<195) { showHelp("%c",i-100+' ',i,&r); 		i++; }
	while (i<(MAX_KEYS-NUM_CED_KEYS)) { showHelp("#%d",i,i,&r); i++; }
	if (r) promptForKey();
	clrscr();
}

DF(i_helpall)	{ showAllHelp(); }
DF(i_home)	{ cursorHome(); }
DF(i_if)	{ if (!returnVal) ip = PARAM(1); }
DF(i_keycode)	{ setKeycode(PARAM(1), (PARAM(2)<<16) + PARAM(3)); }

DF(i_length) {
	int buf = getBuffer(23);
	returnVal = (int)strlen(lookupString(PARAM(1),buf));
	releaseBuffer(buf,525);
}

DF(i_lookup) {
	int buf = getBuffer(24);
	char *v = getenv(lookupString(PARAM(2),buf));
	releaseBuffer(buf,526);
	assign2var(PARAM(1),v?v:"");
}

DF(i_loopall) {
	loopStack[loopP].v=PARAM(1);
	loopStack[loopP].s=PARAM(2);
	loopStack[loopP].e=PARAM(3);
	loopStack[loopP].idx=PARAM(4);
	assign2var(PARAM(1),fInfo[l][fIndex[l][0]].name);
	loopStack[loopP++].pos=1;
}

#if __STDC__
static void checkMark(char *fname) {
#else
static void checkMark(fname)
	char *fname;
{
#endif
	int i;
	if (findFile(0,fname,&i)>=0) 
		returnVal = (fInfo[l][i].flag & F_SELECTED);
	else returnVal = 0;
}

DF(i_marked) {
	int buf = getBuffer(25);
	checkMark(lookupString(PARAM(1),buf));
	releaseBuffer(buf,527);
}

#if __STDC__
static void setMark(int param, int is_pat, int v) {
#else
static void setMark(param, is_pat, v)
	int param, v, is_pat;
{
#endif
	int i=-1, ii, idx, buf = getBuffer(26);
	char *mask = lookupString(param,buf);
	returnVal = 0;
	if (is_pat) {
		while (ii=i, (i = findMatch(i+1,mask,&idx))>ii) {
			nselect(idx,v);
			returnVal = 1;
		}
	} else if (findFile(0,mask,&idx)>=0) {
		nselect(idx,v);
		returnVal = 1;
	}
	releaseBuffer(buf,528);
}

DF(i_markpat)	{ setMark(PARAM(1),1,1);	}
DF(i_markstr)	{ setMark(PARAM(1),0,1);	}
DF(i_unmarkpat)	{ setMark(PARAM(1),1,0);	}
DF(i_unmarkstr)	{ setMark(PARAM(1),0,0);	}

DF(i_matchespat) {
	int buf = getBuffer(27);
	returnVal=0;
	if (prepareRE(lookupString(PARAM(2),buf))==0) {
		int idx;
		if (matchRE(lookupString(PARAM(1),buf))==1)
			returnVal = 1;
	}
	releaseBuffer(buf,529);
}

DF(i_matchesstr) {
	int buf = getBuffer(28), buf2 = getBuffer(29);
	returnVal = !strcmp(lookupString(PARAM(1),buf), lookupString(PARAM(2),buf2));
	releaseBuffer(buf,530);
	releaseBuffer(buf2,531);
}

DF(i_metakey)	{ metaKey = (PARAM(1)<<16) + PARAM(2); }

DF(i_nextline) {
	returnVal = 0;
	assign2var(16,"");
	if (catchFP) {
		int buf = getBuffer(30);
		if (fgets(BUF[buf],80,catchFP)) {
			if (BUF[buf][strlen(BUF[buf])-1]!='\n') {
				while (!feof(catchFP)) {
					if (fgetc(catchFP)=='\n') break;
				}
			}
			assign2var(16, BUF[buf]);
			returnVal = 1;
		}
		releaseBuffer(buf,532);
	}
}

DF(i_not)	{ returnVal = !returnVal; }

DF(i_open) {
	int buf = getBuffer(31);
	if (catchFP) {
		fclose(catchFP);
		unlink(tempName);
		catchFP = NULL;
	}
	if ((catchFP = fopen(lookupString(PARAM(1),buf),"r"))!=NULL) {
		returnVal = 1;
		i_nextline();
	} else returnVal = 0;
	releaseBuffer(buf,533);
}

DF(i_options)	{
	short f = PARAM(1), s;
	if (f<0) { f = -f; s = 0; }
	else s=1;
	if (f==1) noDirSelect = !s;
	else if (f==2) dirsFirst = s;
	else if (f==3) showHidden = s;
	else if (f==4) followLinks = s;
}

DF(i_paint)	{ repaintScreen(); }
DF(i_pgdn)	{ cursorPgDn();	}
DF(i_pgup)	{ cursorPgUp(); }

DF(i_playmac) {
	int buf = getBuffer(32);
	short mac = (short)atoi(lookupString(PARAM(1),buf));
	releaseBuffer(buf,534);
	playMacro(mac);
}

DF(i_recmac) {
	int buf = getBuffer(33);
	short mac = (short)atoi(lookupString(PARAM(1),buf));
	releaseBuffer(buf,535);
	recordMacro(mac);
}

DF(i_return)	{ returnVal = PARAM(1); ip = ipStack[--ipStkLvl]; }

DF(i_returnvar) {
	int buf = getBuffer(34);
	returnVal = atoi(lookupVar(PARAM(1),buf));
	releaseBuffer(buf,536);
	ip = ipStack[--ipStkLvl];
}

DF(i_setexpr) {
	int buf = getBuffer(35);
	sprintf(BUF[buf],"%d",returnVal);
	assign2var(PARAM(1),BUF[buf]);
	releaseBuffer(buf,537);
}

DF(i_sleep)		{ sleep((unsigned)PARAM(1)); }

DF(i_sort) {
	resortList(l, (PARAM(1)<0),  PARAM(2));
	normalise(l);
}

DF(i_split) {
	short n = PARAM(1);
	int buf = getBuffer(36);
	char *t, c = (lookupString(PARAM(2),buf))[0];
	short v1 = PARAM(3), v2 = PARAM(4);
	(void)lookupVar(v1,buf);
	if (n>0) {
		t = BUF[buf]-1;
		while (n>0) {
			if ((t=strchr(t+1,c))==NULL) {
				returnVal = 0;
				return;
			} else n--;
		}
		*t = 0;
	} else {
		char *tp=NULL;
		n = -n;
		while (n>0) {
			if ((t=strrchr(BUF[buf],c))==NULL) {
				returnVal = 0;
				return;
			} else {
				if (tp) *tp = c;
				n--;
				*(tp = t--) = '\0';
			}
		}
		t++;
	}
	assign2var(v1,BUF[buf]);
	if (v2>=0) assign2var(v2,t+1);
	releaseBuffer(buf,538);
	returnVal = 1;
}

DF(i_swap) {
	short v = PARAM(1);
	if (v==1) l=0; /* left */
	else if (v==2) l=1; /* right */
	else l = 1-l; /* toggle */
	CHDIR(paths[l]);
}

DF(i_tail) {
	int buf = getBuffer(37), buf2 = getBuffer(38);
	int L = (int)strlen(lookupVar(PARAM(2),buf2));
	short l = PARAM(1);
	if (l<0) strcpy(BUF[buf],BUF[buf2]+min(-l,L)); /* All but first -l chars */
	else strcpy(BUF[buf],BUF[buf2]+L-min(l,L));
	assign2var(PARAM(2),BUF[buf]);
	releaseBuffer(buf,539);
	releaseBuffer(buf2,540);
}

DF(i_read) {
	int buf = getBuffer(39);
	returnVal = getInput(lookupVar(PARAM(1),buf),PARAM(2),1);
	assign2var(PARAM(1),BUF[buf]);
	releaseBuffer(buf,541);
	clearCmdWin();
}

DF(i_rescan) {
	if (PARAM(1)&1) {
		getCWD(paths[l]);
		doCD(paths[l],fInfo[l][fIndex[l][highlight[l]]].name);
	}
	if (PARAM(1)&2)
		readList(1-l,fInfo[1-l][fIndex[1-l][highlight[1-l]]].name,0);
}

#ifdef __STDC__
static void move2match(int i) {
#else
static void move2match(i)
	int i;
{
#endif
	if (i>=0) {
		highlight[l] = i;
		normalise(l);
		returnVal = 1;
	} else returnVal = 0;
}

DF(i_search) {
	if (PARAM(1)==-1) searching = 1; /* Enter incremental search mode */
	else {
		int buf = getBuffer(40);
		int i = findFile(0, lookupString(PARAM(1),buf),NULL);
		releaseBuffer(buf,542);
		move2match(i);
	}
}

DF(i_searchpat) {
	int buf = getBuffer(41);
	int i = findMatch(highlight[l],lookupString(PARAM(1),buf),NULL);
	releaseBuffer(buf,543);
	move2match(i);
}

DF(i_setmatch) {
	int s=0, i, buf = getBuffer(42), l = 1;
	BUF[buf][0] = '\0';
	if (prepareRE(stringspace+PARAM(2))==0) {
		for (;;) {
			i = findMatch(s,NULL,NULL);
			if (i>=s) {
				char *n = fInfo[l][fIndex[l][i]].name;
				s = i+1;
				l += strlen(n)+1;
				if (l>=BUFFER_SIZE) {
					showMsg("Buffer overflow!");
					break;
				}
				if (BUF[buf][0]) strcat(BUF[buf]," ");
				strcat(BUF[buf],n);
			} else break;
		}
	}
	assign2var(PARAM(1),BUF[buf]);
	returnVal = (int)BUF[buf][0];
	releaseBuffer(buf,544);
}

DF(i_show) {
	/* Specifies what must be displayed */
	switch (info2show = PARAM(1)) {
	case 0: /* None */
		fnameLen = 31; break;
	case 1: /* size */
	case 2: /* owner */
	case 3: /* group */
		fnameLen = 22; break; /* size/owner/group are 8 plus 1 space */
	case 4: /* perms */
#ifdef __MSDOS__
		fnameLen = 24; break;
#else
		fnameLen = 20; break;
#endif
	case 5: /* mtime */
	case 6: /* atime */
		fnameLen = 13; break;
	}
}

DF(i_test) {
	char *tmp, *t2;
	int buf = getBuffer(43), buf2 = getBuffer(44);
	tmp=(char *)strchr(t2=lookupString(PARAM(2),buf),lookupVar(PARAM(1),buf2)[0]);
	if (tmp) returnVal = (tmp-t2)+1;
	else returnVal = 0;
	releaseBuffer(buf,545);
	releaseBuffer(buf2,546);
}

DF(i_typeof) {
	int idx, buf = getBuffer(45);
	if (findFile(0, lookupVar(PARAM(1),buf),&idx)>=0) 
		returnVal = checkType(fInfo[l][idx].mode,PARAM(2));
	else returnVal = 0;
	releaseBuffer(buf,547);
}

DF(i_unbind) { KeyTbl[PARAM(1)].ip = 0; }

#if __STDC__
static void doUnlink(char *re) {
#else
static void doUnlink(re)
	char *re;
{
#endif
	int i=-1, ii;
	if (prepareRE(re)==0) {
		for (;;) {
			int idx;
			if (ii=i, (i = findMatch(i+1,NULL,&idx))>ii) {
				int rtn = unlink(fInfo[l][idx].name);
				if (rtn) {
					int buf = getBuffer(46);
#ifdef NO_STRERROR
					sprintf(BUF[buf],"Failed to unlink %.20s",
						fInfo[l][idx].name);
#else
					sprintf(BUF[buf],"Failed to unlink %.20s: %.30s",
						fInfo[l][idx].name,
						strerror(errno));
#endif
					showMsg(BUF[buf]);
					releaseBuffer(buf,548);
				}
			} else break;
		}
	} else returnVal = 0;
}

DF(i_unlink) {
	int buf = getBuffer(47);
	doUnlink(lookupString(PARAM(1),buf));
	releaseBuffer(buf,549);
}

DF(i_up) { 	cursorUp(); }

/********************************************************/

#if	__STDC__
int execute(short IP, int ch) {
#else
int execute(IP, ch)
	short IP;
	int ch;
{
#endif
	short op;
	if ((ip = IP) == defaultEntryPoint) {
		char buf[2];
		buf[0] = (char)ch;
		buf[1] = '\0';
		assign2var(26, buf);
	}
	for (;;) {
		op = codespace[ip];
		old_ip = ip;
		ip += opCnt[op];
		if (execTbl[op]) {
			if (op==(short)OP_RETURN || op==(short)OP_RETURNVAR) {
				if (ipStkLvl==0) return 0;
			}
			(*execTbl[op])();
		} else if (op==(short)OP_QUIT) {
			exitCurses();
			break;
		}
	}
	return 1;
}

