/********************************************************
		GC3 DIRECTORY SORTING

 (c) 1993 by Graham Wheeler
*********************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>
#include "gc3.h"

#ifdef __MSDOS__
#include <conio.h>
#include <stdio.h>
#include <dir.h>
#else
#endif

#if __STDC__
typedef int (*cmpFunc)(fInfo_t *, fInfo_t *);
#else
typedef int (*cmpFunc)();
#endif

static int
	sortStyle[2],
	secSortStyle[2],
	reverseSort[2],
	secReverseSort[2];

/**************************************************************
		DIRECTORY SORTING
***************************************************************/

/*
 * sortList - sort the fInfo entry indexes according to the
 *	sort keys sortStyle[l] and secSortStyle[l].
 */

static int sortingL, priStyle, secStyle, priRev, secRev;

#if	__STDC__
static int extCmp(fInfo_t *a, fInfo_t *b) {
#else
static int extCmp(a, b)
	fInfo_t *a, *b;
{
#endif /* __STDC__ */
	char *ap = (char *)strrchr(a->name,'.');
	char *bp = (char *)strrchr(b->name,'.');
	if (ap==NULL) ap=a->name;
	if (bp==NULL) bp=b->name;
	return strcmp(ap,bp);
}

#if	__STDC__
static int nameCmp(fInfo_t *a, fInfo_t *b) {
#else
static int nameCmp(a, b)
	fInfo_t *a, *b;
{
#endif /* __STDC__ */
	return strcmp(a->name, b->name);
}

#if	__STDC__
static int sizeCmp(fInfo_t *a, fInfo_t *b) {
#else
static int sizeCmp(a, b)
	fInfo_t *a, *b;
{
#endif /* __STDC__ */
	if (a->size == b->size) return 0;
	else return ((a->size - b->size) <0l) ? -1 : 1;
}

#if	__STDC__
static int mtimCmp(fInfo_t *a, fInfo_t *b) {
#else
static int mtimCmp(a, b)
	fInfo_t *a, *b;
{
#endif /* __STDC__ */
	if (a->modtime == b->modtime) return 0;
	else return ((a->modtime - b->modtime) <0l) ? -1 : 1;
}

#if	__STDC__
static int atimCmp(fInfo_t *a, fInfo_t *b) {
#else
static int atimCmp(a, b)
	fInfo_t *a, *b;
{
#endif /* __STDC__ */
	if (a->acctime == b->acctime) return 0;
	else return ((a->acctime - b->acctime) <0l) ? -1 : 1;
}

#if	__STDC__
static int ownCmp(fInfo_t *a, fInfo_t *b) {
#else
static int ownCmp(a, b)
	fInfo_t *a, *b;
{
#endif /* __STDC__ */
	return (int)(a->uid - b->uid);
}

#if	__STDC__
static int grpCmp(fInfo_t *a, fInfo_t *b) {
#else
static int grpCmp(a, b)
	fInfo_t *a, *b;
{
#endif /* __STDC__ */
	return (int)(a->gid - b->gid);}

static cmpFunc cmpTbl[] = {
	nameCmp, sizeCmp, mtimCmp, atimCmp, ownCmp, grpCmp, extCmp
};

#if	__STDC__
int fcmp(const void *a, const void *b) {
#else
int fcmp(a, b)
	char *a;
	char *b;
{
#endif /* __STDC__ */
	int v;
	if (dirsFirst) {
		if (S_ISDIR(fInfo[sortingL][*((int *)a)].mode)) {
			if (!S_ISDIR(fInfo[sortingL][*((int *)b)].mode))
				return -1;
		} else if (S_ISDIR(fInfo[sortingL][*((int *)b)].mode))
			return 1;
	}
	v = (*(cmpTbl[priStyle]))(&fInfo[sortingL][*((int *)a)],
				&fInfo[sortingL][*((int *)b)]);
	if (priRev) v = -v;
	if (v==0) {
		v = (*(cmpTbl[secStyle]))(&fInfo[sortingL][*((int *)a)],
				&fInfo[sortingL][*((int *)b)]);
		if (secRev) v = -v;
	}
	return v;
}

void
#if	__STDC__
sortList(int n,char *name) {
#else
sortList(n, name)
	int n;
	char *name;
{
#endif /* __STDC__ */
	int (*ftmp)() = fcmp; /* Attempt to fool SPARC compiler */
	sortingL = n;
	priStyle = sortStyle[n];	priRev = reverseSort[n];
	secStyle = secSortStyle[n];	secRev = secReverseSort[n];
	if (numfiles[n]>1)
#ifdef __STDC__
		qsort((void *)fIndex[n],(size_t)(numfiles[n]),
			sizeof(int), ftmp);
#else
		qsort((char *)fIndex[n],numfiles[n],sizeof(int),ftmp);
#endif
	if (name) {
		int i = findFile(0,name,NULL);
		if (i>=0) highlight[n] = i;
	} else startLn[l] = highlight[l]= 0;
}

#ifdef __STDC__
void resortList(int l, int isRev, short key) {
#else
void resortList(l, isRev, key)
	int l, isRev;
	short key;
{
#endif
	secReverseSort[l] = reverseSort[l];
	secSortStyle[l] = sortStyle[l];
	reverseSort[l] = isRev;
	sortStyle[l] = (int)key;
	sortList(l, NULL);
}
