/***********************************************************
		GC3 SCREEN HANDLING
************************************************************/

#include <sys/types.h>
/*#include <sys/stat.h>*/
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <stdlib.h>
#include "gc3.h"
#include "gcmem.h"

#ifdef DEBUG
extern FILE		*debug;
#endif

#ifdef __MSDOS__

#include <dos.h>
#include <conio.h>
#include <dir.h>

typedef unsigned char uchar;

typedef struct {
	char c, r, w, h, so;
} WINDOW;

#ifdef OPTIMIZE
static short scrImage[25][80];
#endif

/*
 * Dummy and simple curses function replacements
 */

#define doupdate()	
#define endwin()	
#define wnoutrefresh(w)
#define UPDATE(w)
#define REFRESH()
#define KEYENABLE(w)	
#define raw()
#define nonl()
#define WGETNSTR(w,r,c,b,l) my_wgetnstr(w,r,c,b,l)
#define LINES		25
#define COLS		80

#else

#include <grp.h>
#include <pwd.h>
#include <ncurses.h>

#define Box(w)		box(w,0,0)

#ifdef NO_KEYENABLE
#define KEYENABLE(w)	/* not supported */
#else
#define KEYENABLE(w)	keypad(w,1)
#endif

#ifdef NO_WGETNSTR
#define WGETNSTR(w,r,c,b,l) wgetstr(w,b) /* ignore r,c and l for now */
#else
#define WGETNSTR(w,r,c,b,l) wgetnstr(w,b,l) /* ignore r,c for now */
#endif

#ifdef SYS_V
#define UPDATE(w)	wnoutrefresh(w)
#define REFRESH		doupdate
#else
#define UPDATE(w)	wrefresh(w)
#define REFRESH		refresh
#endif

#endif

static WINDOW	*panels[2];
static WINDOW	*panelTop[2];
static WINDOW	*statusWin[2];
static WINDOW	*statusTop[2];
static WINDOW	*cmdWin;
static int	cmdWinCursorPos = 0;
static int	inCurses = 0;

int		Lines;

/*********************************************************************
	SPECIAL CURSES FUNCTION REPLACEMENTS FOR DOS...
**********************************************************************/

#ifdef __MSDOS__
/*
 * Terminal handling macros (for DOS only, to replace curses)
 *
 * NB - Turbo C's putch routine seem to be a bit buggy, so I haven't
 *	used its conio.h stuff other than clrscr()
 */

#define SCR_CHAR(c,a)		((a)*256+((unsigned)(c&0xFF)))
#define FAR_PTR(s,o)		(char far *)(( (unsigned long)(s) << 16) + o)
#define Scr_ColorAttr(fg,bg)	((uchar)((((uchar)bg)<<4) + (fg)))

/* Attribute Classes for mono */

#define NORML_ATTR	0x07  /* White on black (CGA); normal (mono) 	*/
#define INVRS_ATTR	0x70  /* Black on white (CGA); inverse (mono)	*/

static short
	default_attr = NORML_ATTR,
	alternate_attr = INVRS_ATTR,
	scr_segbase,
	row,
	col;

static void STANDOUT(WINDOW *w)	{ w->so = 1;	}
static void STANDEND(WINDOW *w)	{ w->so = 0;	}

static void clearBlock(short ulx, short uly,
		       short brx, short bry)
{
#ifdef OPTIMIZE
	int r, c;
	for (r=uly;r<=bry;r++)
		for (c=ulx;c<=brx;c++)
			scrImage[r][c] = SCR_CHAR(' ',default_attr);
#endif
	_CH = (uchar)uly;
	_CL = (uchar)ulx;
	_DH = (uchar)bry;
	_DL = (uchar)brx;
	_BH = (uchar)default_attr;
	_AX = (unsigned short)0x0600;
	geninterrupt(0x10);
}

void wclear(WINDOW *w) {
	clearBlock(w->c,w->r,w->c+w->w-1,w->r+w->h-1);
}

#define werase(w)	wclear(w)

void delwin(WINDOW *w) { wclear(w); Mem_Free((char *)w,1); }

static void wputstraxy(WINDOW *w, int x, int y, char *str, int a) {
	unsigned offset; int c;
	row = w->r+y;
	col = w->c+x;
	offset = (80*row+col)<<1;
	while ((c = *str++)!='\0') {
		if (c=='\t') c = ' '; /* hax */
#ifdef OPTIMIZE
		if (scrImage[row][col]!=SCR_CHAR(c,a)) {
			scrImage[row][col]=SCR_CHAR(c,a);
#endif
			*(unsigned short far *)FAR_PTR(scr_segbase,offset)
				= SCR_CHAR(c,a);
#ifdef OPTIMIZE
		}
#endif
		if (++col>=80) { row++; col = 0; }
		offset += 2;
	}
}

static void wputchaxy(WINDOW *w, int x, int y, int c, int a) {
	unsigned offset;
	row = w->r+y;
	col = w->c+x;
	offset = (80*row+col)<<1;
#ifdef OPTIMIZE
	if (scrImage[row][col]!=SCR_CHAR(c,a))
		scrImage[row][col]=SCR_CHAR(c,a);
	else return;
#endif
	*(unsigned short far *)FAR_PTR(scr_segbase,offset) = SCR_CHAR(c,a);
	if (++col>=80) { row++; col = 0; }
}

void wputchxy(WINDOW *w, int x, int y, int c) {
	wputchaxy(w, x, y, c, w->so?alternate_attr:default_attr);
}

void Box(WINDOW *w) {
	register int i;
	short attr = w->so ? alternate_attr : default_attr;
	wputchaxy(w,0,0,218,attr); /* top left */
	for (i=1; i< (w->w-1); ++i)
		wputchaxy(w,i,0,196,attr); /* top left */
	wputchaxy(w,w->w-1,0,191,attr); /* top left */
	for (i=1; i< (w->h-1); ++i) {
		wputchaxy(w,0,i,179,attr);
		wputchaxy(w,w->w-1,i,179,attr);
	}
	wputchaxy(w,0,w->h-1,192,attr);	/* bottom left */
	for (i=1; i< (w->w-1); ++i)
		wputchaxy(w,i,w->h-1,196,attr);	/* bottom */
	wputchaxy(w,w->w-1,w->h-1,217,attr);	/* bottom left */
}

WINDOW *newwin(int h, int w, int r, int c) {
	WINDOW *W = (WINDOW *)Mem_Calloc(1,sizeof(WINDOW),1);
	W->r = (char)r;
	W->c = (char)c;
	W->w = (char)w;
	W->h = (char)h;
	W->so = 0;
	return W;
}

WINDOW *subwin(WINDOW *pw, int h, int w, int r, int c) {
	return newwin(h,w,r,c);
}

void mvwprintw(WINDOW *w, int r, int c, char *b) {
	wputstraxy(w,c++,r,b, w->so ? alternate_attr : default_attr);
}

short wgetch(WINDOW *w) {
	unsigned short rtn;
	_AH=0;
	geninterrupt(0x16);
	rtn = _AX;
	if (rtn & 0x7F) { /* ASCII? */
		rtn &= 0x7F;
/*		if (_echo && rtn>=32) wputchaxy(w, col-w->c, row-w->r,*/
		if (rtn>=32) wputchaxy(w, col-w->c, row-w->r,
			(char)rtn, w->so ? alternate_attr : default_attr);
	}
	return (short)rtn;
}

void setColorAttr(short fg, short bg) {
	default_attr	= Scr_ColorAttr(fg,bg);
	alternate_attr	= Scr_ColorAttr(bg,fg);
}

#endif

/*********************************************************************
	...AND FOR UNIX...
**********************************************************************/

#ifndef __MSDOS__

static int fgCol=0, bgCol=0;

#define wputchxy(w,x,y,c) mvwaddch(w,y,x,c)

#if	__STDC__
void clrscr(void) {
#else
void clrscr() {
#endif
	wclear(stdscr);
	UPDATE(stdscr);
	REFRESH();
}

#ifdef __STDC__
static void STANDOUT(WINDOW *w) {
#else
static void STANDOUT(w)
	WINDOW *w;
{
#endif
#if !defined(NO_COLOR) && !defined(NO_COLOUR)
	if (allowColor) wattrset(w,COLOR_PAIR(2));
	else
#endif
		wstandout(w);
}

#ifdef __STDC__
static void STANDEND(WINDOW *w) {
#else
static void STANDEND(w)
	WINDOW *w;
{
#endif
#if !defined(NO_COLOR) && !defined(NO_COLOUR)
	if (allowColor) wattrset(w,COLOR_PAIR(1));
	else
#endif
		wstandend(w);
}

#ifdef __STDC__
void setColorAttr(short fg, short bg) {
#else
void setColorAttr(fg, bg)
	short fg, bg;
{
#endif
	int i;
	fgCol = fg;
	bgCol = bg;
#if !defined(NO_COLOR) && !defined(NO_COLOUR)
	if (allowColor) {
		init_pair(1,fgCol,bgCol);
		init_pair(2,bgCol,fgCol);
		for (i=0;i<2;i++) {
			STANDEND(panelTop[i]);
			STANDEND(panels[i]);
			STANDEND(statusTop[i]);
			STANDEND(statusWin[i]);
		}
		STANDEND(cmdWin);
	}
#endif
}

#endif

/*********************************************************************
	O/S INDEPENDENT STUFF
**********************************************************************/

#if	__STDC__
void showCursor(int n, int sel) {
#else
void showCursor(n, sel)
	int n;
	int sel;
{
#endif /* __STDC__ */
	mvwprintw(panels[n],highlight[n]-startLn[n],1,sel?"=>":"->");
	UPDATE(panels[n]);
}

#if	__STDC__
void hideCursor(int n) {
#else
void hideCursor(n)
	int n;
{
#endif /* __STDC__ */
	mvwprintw(panels[n],highlight[n]-startLn[n],1,"  ");
	UPDATE(panels[n]);
}

#if	__STDC__
void showMsg(char *msg) {
#else
void showMsg(msg)
	char *msg;
{
#endif /* __STDC__ */
	int l = (int)strlen(msg);
	if (l) {
		/* Strip trailing control characters */
		while (msg[--l]<32 && l>=0) msg[l] = '\0';
	}
	if (inCurses) {
		cmdWinCursorPos = (int)strlen(msg);
		mvwprintw(cmdWin,0,0,msg);
		UPDATE(cmdWin);
		REFRESH();
	} else fprintf(stderr,"%s\n",msg);
}

#if	__STDC__
static void clearWin(WINDOW *w) {
#else
static void clearWin(w)
	WINDOW *w; {
#endif
	werase(w);
	UPDATE(w);
	REFRESH();
}

#if	__STDC__
void clearCmdWin(void) {
#else
void clearCmdWin() {
#endif
	clearWin(cmdWin);
	cmdWinCursorPos = 0;
	if (searching) {
		int buf = getBuffer(100);
		sprintf(BUF[buf],"/%s",srchTxt);
		showMsg(BUF[buf]);
		releaseBuffer(buf,300);
	}
}


#if __STDC__
static void myRead(WINDOW *w,int r,int c, char *buf,int len, int mode) {
#else
static void myRead(w, r, c, buf, len, mode)
	WINDOW *w;
	int r, c, len, mode;
	char *buf;
{
#endif
	static char editBuff[80];
	char *end, *now, *oldend;
	int ch;
	strcpy(end=editBuff,buf);
	while (*end) end++;
	oldend = now = end;
	if (len>80) len = 78;
	for (;;) {
		char tc;
		wputchxy(cmdWin,COLS-2,0,mode?'+':'-');
		if (end < oldend) {
			/* clear any chars at end, plus cursor */
			int l = oldend-end+1;
			while (l--) wputchxy(w,c+end-editBuff+l,r,' ');
		}
		oldend = end;
		/* Write everything up to the cursor */
		tc = *now; *now = '\0';
		mvwprintw(w,r,c,editBuff);
		*now = tc;
		/* Now do the cursor and the rest of the buffer */
		STANDOUT(w);
		if (tc) {
			wputchxy(w,c+now-editBuff,r,tc);
			STANDEND(w);
			mvwprintw(w,r,c+now-editBuff+1,now+1);
		} else {
			/* cursor is at end of buffer */
			wputchxy(w,c+now-editBuff,r,' ');
			STANDEND(w);
		}
		showList(l); showCursor(l,1);
		UPDATE(w); REFRESH();
		ch = my_getch();
		hideCursor(l);
		/* Restore the default attribute at the cursor position */
		wputchxy(w,c+now-editBuff,r,tc?tc:' ');
		if (ch=='\n' || ch=='\r') break;
		if (EditString(ch, editBuff, &end, &now, &mode, len))
			break;
	}
	strcpy(buf,editBuff);
}

#if	__STDC__
int getInput(char *buf, int len, int mode) {
#else
int getInput(buf, len, mode)
	char *buf;
	int len, mode;
{
#endif /* __STDC__ */
	int saveLine = 0;
	if (len<0) {
		saveLine = 1;
		len = -len;
	}
	myRead(cmdWin,0,cmdWinCursorPos,buf,len,mode);
	if (saveLine && buf[0]) saveHist(buf);
	return (int)strlen(buf);
}

#if	__STDC__
static void showTitle(char *version) {
#else
static void showTitle(version)
	char *version;
{
#endif /* __STDC__ */
	WINDOW *w = newwin(13,27,(LINES-14)/2,(COLS-24)/2);
	Box(w);
	mvwprintw(w,2,6,"Gram's Commander");
	mvwprintw(w,4,12,"by");
	mvwprintw(w,6,6,"Graham Wheeler");
	mvwprintw(w,8,3,"gram@aim1.aztec.co.za");
	mvwprintw(w,10,11,version);
	UPDATE(w); REFRESH();
	sleep(1);
	delwin(w); REFRESH();
}

#if	__STDC__
void showPath(int p) {
#else
void showPath(p)
	int p;
{
#endif /* __STDC__ */
	char buf[36];
	int L = (int)strlen(paths[p]);
	if (L>30) L-=30; else L=0;
	Box(panelTop[p]);
	if (p==l) STANDOUT(panelTop[p]);
	sprintf(buf,"<%s>",paths[p]+L);
	mvwprintw(panelTop[p],0,5,buf);
	STANDEND(panelTop[p]);
	UPDATE(panelTop[p]);
}

#if	__STDC__
static void showStatus(int n) {
#else
static void showStatus(n)
	int n;
{
#endif /* __STDC__ */
#ifndef __MSDOS__
	int F = fIndex[n][highlight[n]];
#endif
	int buf = getBuffer(101);
	Box(statusTop[n]);
	UPDATE(statusTop[n]);
	sprintf(BUF[buf],"%4d files selected (%-9ld bytes) ",
		selCnt[n],selSize[n]);
	mvwprintw(statusWin[n],0,0,BUF[buf]);
#ifdef __MSDOS__
	getDiskSpace(paths[n]);
	{ long ts = freeSpace + usedSpace;
	  sprintf(BUF[buf]," %7ldkb of %7ld kb free (%3d%%)  ",freeSpace/1024l,
		ts/1024l, (int)(freeSpace / (ts/100l)));
	}
	mvwprintw(statusWin[n],1,0,BUF[buf]);
#else
	sprintf(BUF[buf],"  %9s  %10s/%-10s ", getPerms(fInfo[n][F].mode),
		getpwuid(fInfo[n][F].uid)->pw_name,
		getgrgid(fInfo[n][F].gid)->gr_name);
	mvwprintw(statusWin[n],1,0,BUF[buf]);
	sprintf(BUF[buf],"  Modified %26s",
		asctime(localtime(&fInfo[n][F].modtime)));
	mvwprintw(statusWin[n],2,0,BUF[buf]);
	/* For some reason, if we have spaces at the end of BUF[buf] in the
		previous line, curses doesn't set the colour attributes
		of those characters, but if we write them explicitly as in
		next line, it does. Crazy but true. Consider this a forced
		hack. */
	mvwprintw(statusWin[n],2,36,"  ");
	sprintf(BUF[buf],"  Accessed %26s",
		asctime(localtime(&fInfo[n][F].acctime)));
	mvwprintw(statusWin[n],3,0,BUF[buf]);
	/* Yet another colour attribute hack; see above */
	mvwprintw(statusWin[n],3,36,"  ");
#endif
	releaseBuffer(buf,301);
	UPDATE(statusWin[n]);
}

/*
 * showInfo - display the i'th entry for the n panel on the
 *	r'th row of the panel window
 */

#if	__STDC__
static void showInfo(int n, int r, int i) {
#else
static void showInfo(n, r, i)
	int n;
	int r;
	int i;
{
#endif /* __STDC__ */
	extern short info2show;
	int buf;
	struct tm *tp;
	char buff[40]; int F = fIndex[n][i];
	mvwprintw(panels[n],r,0,"                                      ");
	if (i>=numfiles[n]) return;
	strncpy(buff,fInfo[n][F].name,(unsigned)fnameLen);
	buff[fnameLen]=0;
	buf = getBuffer(102);
	sprintf(BUF[buf],"    %c %s",fInfo[n][F].typID,buff);
	if (fInfo[n][F].flag&F_SELECTED) STANDOUT(panels[n]);
	mvwprintw(panels[n],r,0,BUF[buf]);
	STANDEND(panels[n]);
	switch (info2show) {
	case 1: /* size */
		sprintf(BUF[buf],"%8ld",fInfo[n][F].size);
		break;
#ifndef __MSDOS__
	case 2: /* owner */
		sprintf(BUF[buf],"%8s", getpwuid(fInfo[n][F].uid)->pw_name);
		break;
	case 3: /* group */
		sprintf(BUF[buf],"%8s", getgrgid(fInfo[n][F].gid)->gr_name);
		break;
#endif
	case 4: /* perms */
		strcpy(BUF[buf], getPerms(fInfo[n][F].mode));
		break;
	case 5: /* mtime */
		tp = localtime(&fInfo[n][F].modtime);
		sprintf(BUF[buf],"%2d:%02d:%02d %2d/%02d/%02d",
			tp->tm_hour,tp->tm_min,tp->tm_sec,
			tp->tm_mday, tp->tm_mon, tp->tm_year);
		break;
#ifndef __MSDOS__
	case 6: /* atime */
		tp = localtime(&fInfo[n][F].acctime);
		sprintf(BUF[buf],"%2d:%02d:%02d %2d/%02d/%02d",
			tp->tm_hour,tp->tm_min,tp->tm_sec,
			tp->tm_mday, tp->tm_mon, tp->tm_year);
		break;
#endif
	default:
		releaseBuffer(buf,302);
		return;
	}
	BUF[buf][30-fnameLen] = '\0';
	mvwprintw(panels[n],r,fnameLen+8,BUF[buf]);
	releaseBuffer(buf,303);
}

#if	__STDC__
void showList(int n) {
#else
void showList(n)
	int n;
{
#endif /* __STDC__ */
	int i;
	for (i=0;i<NUM_FILES;i++) showInfo(n,i,startLn[n]+i);
	UPDATE(panels[n]);
}

/*
 * normalise() is called after the cursor is moved, to ensure
 * the cursor is still displayed in the window.
 */

#if	__STDC__
void normalise(int n) {
#else
void normalise(n)
	int n;
{
#endif /* __STDC__ */
	if ((highlight[n]-startLn[n])>=NUM_FILES) {
		startLn[n] = highlight[n]-NUM_FILES+1;
	} else if (highlight[n]<startLn[n]) startLn[n] = highlight[n];
	if (startLn[n]>=numfiles[n]) startLn[n] = numfiles[n]-1;
	if (highlight[n]>=numfiles[n]) highlight[n] = numfiles[n]-1;
}

#if	__STDC__
void refreshScreen(void) {
#else
void refreshScreen() {
#endif
	REFRESH();
}

#if	__STDC__
void repaintScreen(void) {
#else
void repaintScreen() {
#endif
	int i;
	for (i=0;i<2;i++) {
		normalise(i);
		showPath(i);
		showStatus(i);
		showList(i);
	}
	REFRESH();
}

#if	__STDC__
static void winFail(void) {
#else
static void winFail() {
#endif
	clrscr();
	endwin();
	fprintf(stderr,"Failed to make a window - aborting\n");
	exit(-1);
}

#if	__STDC__
static void enableCursor(void) {
#else
static void enableCursor() {
#endif /* __STDC__ */
#ifdef __MSDOS__
	_setcursortype(_NORMALCURSOR);
#else
#  ifndef NO_CURS_SET
	curs_set(1);
#  endif
#endif
}

#if	__STDC__
static void disableCursor(void) {
#else
static void disableCursor() {
#endif /* __STDC__ */
#ifdef __MSDOS__
	_setcursortype(_NOCURSOR);
#else
#  ifndef NO_CURS_SET
	curs_set(0);
#  endif
#endif
}

#if	__STDC__
void setupCurses(char *version) {
#else
void setupCurses(version)
	char *version;
{
#endif /* __STDC__ */
	static int first = 1;
#ifdef __MSDOS__
	union REGS rgs;
	(void)int86(0x11,&rgs,&rgs); /* BIOS equipment flag service */
	if ((rgs.x.ax & 0x0030) != 0x0030) { /* CGA? */
		scr_segbase=0xB800;
	} else scr_segbase=0xB000;
#else
	initscr(); nonl(); raw(); noecho();
#if !defined(NO_COLOR) && !defined(NO_COLOUR)
	if (allowColor && start_color()==ERR)
#endif
		allowColor = 0;
#endif
	Lines = LINES;
	if (first) { clrscr(); showTitle(version); first = 0; }
	if ((panelTop[0] = newwin(NUM_FILES+2,COLS/2,0,0))==NULL)
		winFail();
	if ((panels[0] = subwin(panelTop[0],NUM_FILES,COLS/2-2,1,1))==NULL)
		winFail();
	if ((panelTop[1] = newwin(NUM_FILES+2,COLS/2,0,COLS/2))==NULL)
		winFail();
	if ((panels[1] = subwin(panelTop[1],NUM_FILES,COLS/2-2,1,COLS/2+1))==NULL)
		winFail();
	if ((statusTop[0] = newwin(NUM_INFO_LNS+2,COLS/2,LINES-NUM_INFO_LNS-3,0))==NULL)
		winFail();
	if ((statusWin[0] = subwin(statusTop[0],NUM_INFO_LNS,COLS/2-2,LINES-NUM_INFO_LNS-2,1))==NULL)
		winFail();
	if ((statusTop[1] = newwin(NUM_INFO_LNS+2,COLS/2,LINES-NUM_INFO_LNS-3,COLS/2))==NULL)
		winFail();
	if ((statusWin[1] = subwin(statusTop[1],NUM_INFO_LNS,COLS/2-2,LINES-NUM_INFO_LNS-2,COLS/2+1))==NULL)
		winFail();
	if ((cmdWin = newwin(1,COLS,LINES-1,0))==NULL)
		winFail();
	KEYENABLE(panels[0]);
	KEYENABLE(panels[1]);
	KEYENABLE(cmdWin);
	disableCursor();
#ifndef __MSDOS__
	/* Restore last colour setting */
	if (!first && (fgCol+bgCol)!=0) setColorAttr(fgCol,bgCol);
#endif
	inCurses = 1;
}

#if	__STDC__
void exitCurses(void) {
#else
void exitCurses() {
#endif
#ifdef __MSDOS__
	int i;
	for (i=0;i<2;i++) {
		delwin(panelTop[i]);
		delwin(panels[i]);
		delwin(statusTop[i]);
		delwin(statusWin[i]);
	}
	delwin(cmdWin);
#else
	int i;
#if !defined(NO_COLOR) && !defined(NO_COLOUR)
	for (i=0;i<2;i++) {
		wattroff(panelTop[i],COLOR_PAIR(1));
		wattroff(panels[i],COLOR_PAIR(1));
		wattroff(statusTop[i],COLOR_PAIR(1));
		wattroff(statusWin[i],COLOR_PAIR(1));
	}
	wattroff(cmdWin,COLOR_PAIR(1));
#endif
	repaintScreen();
#endif
	clrscr();
	endwin();
	enableCursor();
	inCurses = 0;
}

#if	__STDC__
void cursorUp(void) {
#else
void cursorUp() {
#endif
	if (highlight[l]>0) {
		highlight[l]--;
		normalise(l);
	}
}

#if	__STDC__
void cursorDown(void) {
#else
void cursorDown() {
#endif
	if (highlight[l]<(numfiles[l]-1)) {
		highlight[l]++;
		normalise(l);
	}
}

#if	__STDC__
void cursorPgUp(void) {
#else
void cursorPgUp() {
#endif
	if (highlight[l]!=startLn[l]) highlight[l] = startLn[l];
	else {
		int n = NUM_FILES;
		if (n>highlight[l]) n = highlight[l];
		startLn[l] = (highlight[l] -= n);
	}
	normalise(l);
}

#if	__STDC__
void cursorPgDn(void) {
#else
void cursorPgDn() {
#endif
	if (highlight[l]!=(startLn[l]+NUM_FILES-1))
		highlight[l] = startLn[l]+NUM_FILES-1;
	else 	{
		if ((numfiles[l]-startLn[l])>=NUM_FILES) {
			startLn[l] += NUM_FILES;
			highlight[l] = startLn[l]+NUM_FILES-1;
		}
	}
	normalise(l);
}

#if	__STDC__
void cursorHome(void) {
#else
void cursorHome() {
#endif
	highlight[l] = 0;
	normalise(l);
}

#if	__STDC__
void cursorEnd(void) {
#else
void cursorEnd() {
#endif
	highlight[l] = numfiles[l] - 1;
	normalise(l);
}

#if	__STDC__
int readKey(void) {
#else
int readKey() {
#endif
	int rtn = wgetch(cmdWin);
#ifdef DEBUG
	fprintf(debug,"Got key press 0x%X\n",rtn);
#endif
	return rtn;
}
