/****************************************************

	GC3 REGULAR EXPRESSION MATCHING

 Supports both BSD and System V regular expressions,
 as well as DOS file patterns. The latter are explicitly
 coded here; the others rely on library routines.

 Entry points to the code in this file are:

	char *compileRE(char *RE)
	int  matchRE(char *string)

 The former is used to prepare the regular expression
 while the latter returns a non-zero value if the
 given string matches the last regular expression set
 up with compileRE.

 (c) 1993 by Graham Wheeler

*****************************************************/

#include <sys/types.h>
#include <stdio.h>	/* for NULL	*/
#include <string.h>	/* for NULL	*/

#if __STDC__ || __MSDOS__
extern void STRUPR(char *s);
#else
extern void STRUPR();
#endif

/*****************************************************
	SYSTEM V SPECIFIC REGEXPS
******************************************************/

#ifdef USE_SYSV_REGEXP
static char REbuf[1024];

static char *REmsg, *REsrc;

#define INIT		register char *sp=REsrc;
#define GETC()		(*sp++)
#define UNGETC(c)	(sp--)
#define RETURN(c)	return c;
#define ERROR		REerr
#define PEEKC()		(*sp)

#if __STDC__
static void REerr(int c) {
#else
static void REerr(c) {
#endif
	switch(c) {
	case 11: REmsg = "range endpoint too large"; break;
	case 16: REmsg = "bad number"; break;
	case 25: REmsg = "\\ digit out of range"; break;
	case 36: REmsg = "illegal or missing delimeter"; break;
	case 41: REmsg = "no remembered search string"; break;
	case 42: REmsg = "\\( \\) imbalance"; break;
	case 43: REmsg = "too many \\('s"; break;
	case 44: REmsg = "more than two numbers in \\{ \\}"; break;
	case 45: REmsg = "} expected after \\"; break;
	case 46: REmsg = "first number exceeds second in \\{ \\}"; break;
	case 49: REmsg = "[ ] imbalance"; break;
	case 50: REmsg = "regular expression overflow"; break;
	default: REmsg = "unknown error"; break;
	}
}

#include <regexp.h>

#ifdef __STDC__
char *compileRE(char *RE) {
#else
char *compileRE(RE)
	char *RE;
{
#endif
	REmsg = NULL;
	REsrc = RE;
	(void)compile((char *)NULL,REbuf,REbuf+1024,'\0');
	return REmsg;
}

#ifdef __STDC__
int  matchRE(char *string) {
#else
int matchRE(string)
	char *string;
{
#endif
	return (step(string,REbuf));
}
#endif

/*****************************************************
	BSD SPECIFIC REGEXPS
******************************************************/

#ifdef USE_BSD_REGEXP

#ifdef __STDC__
char *compileRE(char *RE) {
#else
char *compileRE(RE)
	char *RE;
{
#endif
	return (char *)re_comp(RE);
}

#ifdef __STDC__
int  matchRE(char *string) {
#else
int matchRE(string)
	char *string;
{
#endif
	return (re_exec(string)==1);
}

#endif

/*****************************************************
	DOS SPECIFIC STUFF
******************************************************/

#if __MSDOS__
#include <dir.h>
#include <string.h>

static char REbuf[1024];

static int matchPart(char *pat, char *str) {
	while (*str) {
		if (*pat == '*')
			break;
		else  if (*pat=='.')
			return 1;
		else if (*pat!='?' && *pat != *str)
			return 1;
		str++;
		pat++;
	}
	return 0;
}

char *compileRE(char *RE) {
	strcpy(REbuf,RE);
	STRUPR(REbuf);
	return NULL;
}

int  matchRE(char *string) {
	char *pre=string, *suf = strchr(string,'.'), *tmp, *t2=suf;
	if (suf) *suf++ = '\0';
	tmp = REbuf;
	if (matchPart(tmp,pre)) goto fail;
	tmp = strchr(REbuf,'.');
	if (tmp==NULL && (suf==NULL  || *suf=='\0')) goto succeed;
	else if (tmp) {
		tmp++;
		if (suf) {
			if (*tmp && matchPart(tmp,suf)==0)
				goto succeed;
		} else if (*tmp=='*') goto succeed;
	}
fail:
	if (t2) *t2 = '.';
	return 0;
succeed:
	if (t2) *t2 = '.';
	return 1;
}

#endif

/******************************************************/

