#include <stdio.h>
#include "gccc.h"

#define MAX_LOOPS	8

short labelcnt = 0, innerloop = 0;
short loopstack[MAX_LOOPS][2];

int EM=1;

#define _emit(v)		(codespace[codep++] = (v))
#define CHK(n)			if ((codep+n)>=CODESPACE) error(ERR_CODESPACE)
#define EMIT(v)			{ if (EM) { CHK(1); _emit(v); }}
#define EMIT2(v1,v2)		{ if (EM) { CHK(2); _emit(v1);_emit(v2);}}
#define EMIT3(v1,v2,v3)		{ if (EM) { CHK(3); _emit(v1);_emit(v2);_emit(v3);}}
#define EMIT4(v1,v2,v3,v4)	{ if (EM) { CHK(4); _emit(v1);_emit(v2);_emit(v3);_emit(v4);}}
#define EMIT5(v1,v2,v3,v4,v5)	{ if (EM) { CHK(5); _emit(v1);_emit(v2);_emit(v3);_emit(v4);_emit(v5);}}

#define newlabel()		(labelcnt++)

/*
 * Forward declarations
 */

#if __STDC__

static int function(void);
static void command_list(void);
static void command(void);
static short string(void);
static void call(void);
static void do_cmd(void);
static void stringcmd(enum codeops op);
static short regexp(void);
static void if_cmd(void);
static void loop_cmd(void);
static void search_expr(void);
static void expression(void);
static void show_cmd(void);
static void sort_cmd(void);
static void unlink_func(void);
static void while_cmd(void);
static void primary(void);
static short type_list(void);
static void read_cmd(void);

#else

static int function();
static void command_list();
static void command();
static void stringcmd();
static void unlink_func();
static void loop_cmd();
static void while_cmd();
static void do_cmd();
static void if_cmd();
static void search_expr();
static void call();
static void show_cmd();
static void sort_cmd();
static void expression();
static short string();
static short regexp();
static void primary();
static short type_list();
static void read_cmd();

#endif

/**********************************************************/

#if __STDC__
void config_file(void) {
#else
void config_file() {
#endif
	EMIT(OP_NOT) /* Dummy so we start at 1 */
	for (;;) if (function()) break;
}

#if __STDC__
static int function(void) {
#else
static int function() {
#endif
	if (symbol==SYM_EOF) return 1;
	else if (symbol == SYM_GCDEFAULT) {
		defaultEntryPoint = codep;
		nextsymbol();
	} else if (symbol == SYM_GCSTART) {
		initialEntryPoint = codep;
		nextsymbol();
	} else if (objects[symvalue].p<0) {
		objects[symvalue].p = codep;
		if (objects[symvalue].type != FUNC_TYPE)
			error(ERR_FUNCEXP);
		expect(SYM_IDENTIFIER);
	} else error(ERR_REDEFINE); /* ID redefined */
	expect(SYM_LEFTBRACE);
	command_list();
	EMIT2(OP_RETURN, 0)
	expect(SYM_RIGHTBRACE);
	/* Default prologue */
	return 0;
}
		
#if __STDC__
static void command_list(void) {
#else
static void command_list() {
#endif
	while (symbol!=SYM_RIGHTBRACE) {
		command();
		if (symbol==SYM_SEMICOLON) nextsymbol();
	}
}

#if __STDC__
static void command(void) {
#else
static void command() {
#endif
	short t1, t2, t3;
	switch(symbol) {
	case SYM_APPEND:
		nextsymbol();
		t1 = string();
		EMIT3(OP_APPEND,t1,string())
		break;
	case SYM_BEEP: 
		nextsymbol();
		EMIT(OP_BEEP)
		break;
	case SYM_BIND:
		nextsymbol();
		t1 = (short)symvalue;
		if (t1<0 || t1>=240) error(ERR_BIND);
		expect(SYM_KEYSPEC);
		expect(SYM_TO);
		if (symbol==SYM_LEFTBRACE) {
			EMIT2(OP_GOTO,t3=newlabel())
			EMIT2(OP_LABEL,t2=newlabel())
			nextsymbol();
			command_list();
			expect(SYM_RIGHTBRACE);
			EMIT2(OP_RETURN, 0)
			EMIT2(OP_LABEL,t3)
			t1 = -t1;
		} else {
			if (newID) error(ERR_UNDEFINED);
			if (objects[t2 = (short)symvalue].type != FUNC_TYPE)
				error(ERR_FUNCEXP);
			nextsymbol();
		}
		EMIT4(OP_BIND,t1,t2,string())
		break;
	case SYM_BREAK:
		nextsymbol();
		if (innerloop) 
			EMIT2(OP_GOTO,loopstack[innerloop-1][1])
		else error(ERR_NOLOOP);
		break;
	case SYM_CALL:
		call();
		break;
	case SYM_CD:
		nextsymbol();
		EMIT2(OP_CD,string())
		break;
	case SYM_CLEAR:
		nextsymbol();
		EMIT(OP_CLEAR)
		break;
	case SYM_COLORS:
	case SYM_COLOURS:
		nextsymbol();
		if ((t1 = symbol)>7) error(ERR_COLEXP);
		nextsymbol();
		expect(SYM_ON);
		if (symbol>7) error(ERR_COLEXP);
		else EMIT3(OP_COLOURS,t1,symbol)
		nextsymbol();
		break;
	case SYM_COPY:
		nextsymbol();
		t1 = string();
		EMIT4(OP_FCOPY,t1,string(),0)
		break;
	case SYM_LEFTBRACE:
		nextsymbol();
		command_list();
		expect(SYM_RIGHTBRACE);
		break;
	case SYM_CONTINUE:
		nextsymbol();
		if (innerloop)
			EMIT2(OP_GOTO,loopstack[innerloop-1][0])
		else error(ERR_NOLOOP);
		break;
	case SYM_DEBUG:
		nextsymbol();
		EMIT(OP_DEBUG)
		break;
	case SYM_DO:
		do_cmd();
		break;
	case SYM_DOWN:
		nextsymbol();
		EMIT(OP_DOWN)
		break;
	case SYM_ECHO:
		nextsymbol();
		EMIT2(OP_ECHO,string())
		break;
	case SYM_END:
		nextsymbol();
		EMIT(OP_END)
		break;
	case SYM_ENDREC:
		nextsymbol();
		EMIT(OP_ENDREC)
		break;
	case SYM_EXEC:
		nextsymbol();
		EMIT2(OP_EXEC,string())
		break;
	case SYM_EXECCATCH:
		nextsymbol();
		EMIT2(OP_EXECCATCH,string())
		break;
	case SYM_EXPAND:
		nextsymbol();
		if (symbol!=SYM_IDENTIFIER ||
			objects[symvalue].type != VAR_TYPE)
				error(ERR_VAREXP);
		EMIT2(OP_EXPAND,(short)symvalue)
		nextsymbol();
		break;
	case SYM_FILTER:
		nextsymbol();
		EMIT2(OP_FILTER,regexp())
		break;
	case SYM_HEAD:
		stringcmd(OP_HEAD);
		break;
	case SYM_HELP:
		nextsymbol();
		if (symbol==SYM_ALL) {
			EMIT(OP_HELPALL)
			nextsymbol();
		} else if (symbol==SYM_KEYSPEC) {
			EMIT2(OP_HELP,(short)symvalue)
			nextsymbol();
		} else EMIT(OP_HELPKEY)
		break;
	case SYM_HOME:
		nextsymbol();
		EMIT(OP_HOME)
		break;
	case SYM_IF:
		if_cmd();
		break;
	case SYM_KEYCODE:
		nextsymbol();
		t1 = (short)symvalue;
		expect(SYM_KEYSPEC);
		expect(SYM_ASSIGN);
		EMIT4(OP_KEYCODE,t1,symvalue>>16, symvalue&0xFFFF)
		expect(SYM_INTEGER);
		break;
	case SYM_LOOKUP:
		nextsymbol();
		if (symbol!=SYM_IDENTIFIER ||
			objects[t1=(short)symvalue].type != VAR_TYPE)
				error(ERR_VAREXP);
		nextsymbol();
		EMIT3(OP_LOOKUP, t1, string())
		break;
	case SYM_LOOP:
		loop_cmd();
		break;
	case SYM_MARK:
		nextsymbol();
		if (symbol==SYM_REGEXP) EMIT2(OP_MARKPAT,regexp())
		else EMIT2(OP_MARKSTR,string())
		break;
	case SYM_METAKEY:
		nextsymbol();
		EMIT3(OP_METAKEY,symvalue>>16, symvalue&0xFFFF)
		expect(SYM_INTEGER);
		break;
	case SYM_MOVE:
		nextsymbol();
		t1 = string();
		EMIT4(OP_FCOPY,t1,string(),1)
		break;
	case SYM_NEXTLINE:
		nextsymbol();
		EMIT(OP_NEXTLINE)
		break;
	case SYM_OPEN:
		nextsymbol();
		EMIT2(OP_OPEN,string())
		break;
	case SYM_OPTIONS:
		t1 = 0;
		nextsymbol();
		if (symbol==SYM_DIRSELECT) t1 = 1;
		else if (symbol==SYM_DIRSORT) t1 = 2;
		else if (symbol==SYM_SHOWHIDDEN) t1 = 3;
		else if (symbol==SYM_FOLLOW) t1 = 4;
		else error(ERR_EXPOPT);
		nextsymbol();
		if (symbol==SYM_ON) EMIT2(OP_OPTIONS,t1)
		else if (symbol==SYM_OFF) EMIT2(OP_OPTIONS,-t1)
		else error(ERR_EXPONOFF);
		nextsymbol();
		break;
	case SYM_PAINT:
		nextsymbol();
		EMIT(OP_PAINT)
		break;
	case SYM_PGDN:
		nextsymbol();
		EMIT(OP_PGDN)
		break;
	case SYM_PGUP:
		nextsymbol();
		EMIT(OP_PGUP)
		break;
	case SYM_PLAYMAC:
		nextsymbol();
		EMIT2(OP_PLAYMAC,string())
		break;
	case SYM_QUIT:
		nextsymbol();
		EMIT(OP_QUIT)
		break;
	case SYM_READ:
		read_cmd();
		break;
	case SYM_RECMAC:
		nextsymbol();
		EMIT2(OP_RECMAC,string())
		break;
	case SYM_RESCAN:
		nextsymbol();
		EMIT2(OP_RESCAN,(short)symvalue)
		expect(SYM_INTEGER);
		break;
	case SYM_RETURN:
		nextsymbol();
		if (symbol==SYM_INTEGER)
			EMIT2(OP_RETURN,(short)symvalue)
		else if (symbol==SYM_IDENTIFIER) {
			if (objects[symvalue].type != VAR_TYPE)
				error(ERR_VAREXP);
			EMIT2(OP_RETURNVAR,(short)symvalue)
		} else error(ERR_BADRETURN);
		nextsymbol();
		break;
	case SYM_SEARCH:
		search_expr();
		break;
	case SYM_IDENTIFIER:
		if (objects[t1=(short)symvalue].type != VAR_TYPE) error(ERR_VAREXP);
		nextsymbol();
		expect(SYM_ASSIGN);
		if (symbol==SYM_REGEXP) EMIT3(OP_SETMATCH,t1,regexp())
		else if (symbol==SYM_STRING) EMIT3(OP_ASSIGN, t1, string())
		else {
			expression();
			EMIT2(OP_SETEXPR,t1)
		}
		break;
	case SYM_SHOW:
		show_cmd();
		break;
	case SYM_SLEEP:
		nextsymbol();
		EMIT2(OP_SLEEP, (short)symvalue)
		expect(SYM_INTEGER);
		break;
	case SYM_SORTBY:
		sort_cmd();
		break;
	case SYM_SPLIT:
		nextsymbol();
		t1 = (short)symvalue;
		expect(SYM_INTEGER);
		t2 = string();
		if (symbol!=SYM_IDENTIFIER ||
			objects[t3=(short)symvalue].type != VAR_TYPE)
				error(ERR_VAREXP);
		nextsymbol();
		if (objects[symvalue].type == VAR_TYPE) {
			EMIT5(OP_SPLIT,t1,t2,t3,(short)symvalue)
			expect(SYM_IDENTIFIER);
		} else EMIT5(OP_SPLIT,t1,t2,t3,-1)
		break;
	case SYM_SWAP: 
		nextsymbol();
		if (symbol==SYM_LEFT) {
			nextsymbol();
			EMIT2(OP_SWAP,1)
		} else if (symbol==SYM_RIGHT) {
			nextsymbol();
			EMIT2(OP_SWAP,2)
		} else EMIT2(OP_SWAP,0)
		break;
	case SYM_TAIL:
		stringcmd(OP_TAIL);
		break;
	case SYM_UNBIND:
		nextsymbol();
		if (t1<0 || t1>=240) error(ERR_BIND);
		EMIT2(OP_UNBIND,(short)symvalue)
		expect(SYM_KEYSPEC);
		break;
	case SYM_UNLINK:
		unlink_func();
		break;
	case SYM_UNMARK:
		nextsymbol();
		if (symbol==SYM_REGEXP) EMIT2(OP_UNMARKPAT,regexp())
		else EMIT2(OP_UNMARKSTR,string())
		break;
	case SYM_UP:
		nextsymbol();
		EMIT(OP_UP)
		break;
	case SYM_WHILE:
		while_cmd();
		break;
	default:
		error( ERR_BADCMD);
	}
}

#if __STDC__
static void call(void) {
#else
static void call() {
#endif
	nextsymbol();
	if (symbol==SYM_STRING) {
		EMIT2(OP_CALL,-string())
	} else {
		if (symbol!=SYM_IDENTIFIER || objects[symvalue].type != FUNC_TYPE)
			error(ERR_FUNCEXP);
		EMIT2(OP_CALL,(short)symvalue)
		nextsymbol();
	}
}

#if __STDC__
static void read_cmd(void) {
#else
static void read_cmd() {
#endif
	short t;
	nextsymbol();
	if (symbol!=SYM_IDENTIFIER ||
		objects[t=(short)symvalue].type != VAR_TYPE)
			error(ERR_VAREXP);
	nextsymbol();
	EMIT3(OP_READ,t,(short)symvalue)
	expect(SYM_INTEGER);
}

#if __STDC__
static void search_expr(void) {
#else
static void search_expr() {
#endif
	nextsymbol();
	if (symbol==SYM_STRING) EMIT2(OP_SEARCH,string())
	else if (symbol==SYM_REGEXP) EMIT2(OP_SEARCHPAT,regexp())
	else EMIT2(OP_SEARCH,-1)
}

#if __STDC__
static void stringcmd(enum codeops op) {
#else
static void stringcmd(op)
	enum codeops op;
{
#endif
	short t;
	nextsymbol();
	t = (short)symvalue;
	expect(SYM_INTEGER);
	EMIT3(op,t,(short)symvalue)
	if (symbol!=SYM_IDENTIFIER ||
		objects[symvalue].type != VAR_TYPE)
			error(ERR_VAREXP);
	nextsymbol();
}

#if __STDC__
static void unlink_func(void) {
#else
static void unlink_func() {
#endif
	nextsymbol();
     	EMIT2(OP_UNLINK,string())
}

#if __STDC__
static void loop_cmd(void) {
#else
static void loop_cmd() {
#endif
	short s=newlabel(), e = newlabel(), v;
	expect(SYM_LOOP);
	expect(SYM_LEFTPARENTHESIS);
	if (symbol!=SYM_IDENTIFIER ||
		objects[v=(short)symvalue].type != VAR_TYPE)
			error(ERR_VAREXP);
	nextsymbol();
	EMIT4(OP_LOOPALL,v,s,e)
	expect(SYM_RIGHTPARENTHESIS);
	loopstack[innerloop][0] = s;
	loopstack[innerloop][1] = e;
	innerloop++;
	EMIT2(OP_LABEL,s)
	command();
	EMIT(OP_ENDLOOP)
	EMIT2(OP_LABEL,e)
	innerloop--;
}

#if __STDC__
static void while_cmd(void) {
#else
static void while_cmd() {
#endif
	short s=newlabel(), e = newlabel();
	loopstack[innerloop][0] = s;
	loopstack[innerloop][1] = e;
	innerloop++;
	EMIT2(OP_LABEL,s)
	expect(SYM_WHILE);
	expect(SYM_LEFTPARENTHESIS);
	expression();
	EMIT2(OP_IF,e)
	expect(SYM_RIGHTPARENTHESIS);
	command();
	EMIT2(OP_GOTO,s)
	EMIT2(OP_LABEL,e)
	innerloop--;
}

#if __STDC__
static void do_cmd(void) {
#else
static void do_cmd() {
#endif
	short s=newlabel(), e = newlabel();
	loopstack[innerloop][0] = s;
	loopstack[innerloop][1] = e;
	innerloop++;
	EMIT2(OP_LABEL,s)
	expect(SYM_DO);
	command();
	expect(SYM_WHILE);
	expect(SYM_LEFTPARENTHESIS);
	expression();
	EMIT2(OP_IF,e)
	expect(SYM_RIGHTPARENTHESIS);
	EMIT2(OP_GOTO,s)
	EMIT2(OP_LABEL,e)
	innerloop--;
}

#if __STDC__
static void if_cmd(void) {
#else
static void if_cmd() {
#endif
	short e1 = newlabel(), e2 = newlabel();
	expect(SYM_IF);
	expect(SYM_LEFTPARENTHESIS);
	expression();
	EMIT2(OP_IF,e1)
	expect(SYM_RIGHTPARENTHESIS);
	command();
	EMIT2(OP_GOTO,e2)
	EMIT2(OP_LABEL,e1)
	if (symbol==SYM_ELSE) {
		nextsymbol();
		command();
	}
	EMIT2(OP_LABEL,e2)
}

#if __STDC__
static void show_cmd(void) {
#else
static void show_cmd() {
#endif
	short t;
	expect(SYM_SHOW);
	switch (symbol) {
	case SYM_NONE:	t=0;	break;
	case SYM_SIZE:	t=1;	break;
	case SYM_OWNER: t=2;	break;
	case SYM_GROUP: t=3;	break;
	case SYM_PERMS: t=4;	break;
	case SYM_MTIME: t=5;	break;
	case SYM_ATIME: t=6;	break;
	default: error(ERR_SHOWWHAT);
	}
	EMIT2(OP_SHOW,t)
	nextsymbol();
}

#if __STDC__
static void sort_cmd(void) {
#else
static void sort_cmd() {
#endif
	int dir=1, key;
	expect(SYM_SORTBY);
	if (symbol==SYM_ASCENDING) nextsymbol();
	else if (symbol==SYM_DESCENDING) {
		nextsymbol();
		dir = -1;
	}
	switch (symbol) {
	case SYM_NAME: key = S_NAME; break;
	case SYM_SIZE: key = S_SIZE; break;
	case SYM_GROUP: key = S_GROUP; break;
	case SYM_OWNER: key = S_OWNER; break;
	case SYM_MTIME: key = S_MTIME; break;
	case SYM_ATIME: key = S_ATIME; break;
	case SYM_EXTENS: key = S_EXTENS; break;
	default: error(ERR_NOKEY);
	}
	EMIT3(OP_SORT,dir,key)
	nextsymbol();
}

#if __STDC__
static void expression(void) {
#else
static void expression() {
#endif
	short n = 0;
	if (symbol==SYM_NOT) {
		nextsymbol();
		n = 1;
	}
	primary();
	if (n) EMIT(OP_NOT)
}

#if __STDC__
static void primary(void) {
#else
static void primary() {
#endif
	short t, v;
	switch(symbol) {
	case SYM_ACCESS:
		nextsymbol();
		v = string();
		EMIT3(OP_ACCESS,v,(short)symvalue)
		expect(SYM_INTEGER);
		break;
	case SYM_EVAL:
		nextsymbol();
		EMIT2(OP_EVAL,string())
		break;
	case SYM_LENGTH:
		nextsymbol();
		EMIT2(OP_LENGTH,string())
		break;
	case SYM_MARKED:
		nextsymbol();
		EMIT2(OP_MARKED,string())
		break;
	case SYM_MATCHES:
		nextsymbol();
		t = string();
		if (symbol==SYM_STRING) EMIT3(OP_MATCHESSTR,t,string())
		else EMIT3(OP_MATCHESPAT,t,regexp())
		break;
	case SYM_IDENTIFIER:
		if (objects[v=(short)symvalue].type != VAR_TYPE) error(ERR_VAREXP);
		nextsymbol();
		expect(SYM_IN);
		EMIT3(OP_TEST,v,string())
		break;
	case SYM_TYPEOF:
		nextsymbol();
		if (symbol!=SYM_IDENTIFIER ||
			objects[v=(short)symvalue].type != VAR_TYPE)
				error(ERR_VAREXP);
		nextsymbol();
		expect(SYM_IN);
		EMIT3(OP_TYPEOF,v,type_list())
		break;
	default:
		command();
	}
}

#if __STDC__
static short type_list(void) {
#else
static short type_list() {
#endif
	short f = 0;
	for (;;) {
		switch(symbol) {
		case SYM_DIR:
			f |= 1; break;
		case SYM_PIPE:
			f |= 2; break;
		case SYM_CDEV:
			f |= 4; break;
		case SYM_BDEV:
			f |= 8; break;
		case SYM_REG:
			f |= 16; break;
		case SYM_EXEC:
			f |= 32; break;
		case SYM_LINK:
			f |= 64; break;
		default: return f;
		}
		nextsymbol();
	}
}

#if __STDC__
static short string(void) {
#else
static short string() {
#endif
	short rtn = savestring(symtext);
	expect(SYM_STRING);
	return rtn;
}

#if __STDC__
static short regexp(void) {
#else
static short regexp() {
#endif
	short rtn = savestring(symtext);
	if (symtext[0]=='@') rtn = -rtn; /* Variable type /@id/ */
	expect(SYM_REGEXP);
	return rtn;
}

