#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#ifdef __MSDOS__
#ifndef __STDC__
#define __STDC__ 1
#endif
#endif

#include "gcboth.h"

FILE	*outfp = stdout;

#include "gcopcnt.c"

char *opName[] = {
	"Access", "Append", "Assign", "Beep", "Bind",
	"Call", "Cd", "Clear", "Colours", "Debug",
	"Down",	"Echo", "End", "Endloop", "EndRec", "Eval", "Exec",
	"ExecCatch", "Expand", "Fcopy", "Filter",	"Goto", "Head",
	"Help", "HelpAll", "HelpKey", "Home", "If", "KeyCode",
	"Label", "Length", "Lookup", "LoopAll", "Marked", "MarkPat",
	"MarkStr", "Matchespat", "MatchesStr", "MetaKey",
	"NextLine", "Not", "Open",
	"Options", "Paint", "Pgdn", "Pgup", "PlayMac", "Quit", "Read",
	"RecMac",
	"Rescan", "Return", "Returnvar", "Search", "Searchpat",
	"SetExpr", "SetMatch", "Show", "Sleep", "Sort", "Split", "Swap",
	"Tail", "Test", "Typeof", "Unbind", "Unlink",
	"UnmarkPat", "UnmarkStr", "Up",
};

#if __STDC__
void dumpstrings(void) {
#else
void dumpstrings() {
#endif
	int i = 0;
	fprintf(outfp,"\n\nSTRING SPACE\n====== =====\n\n");
	while (i<stringp) {
		fprintf(outfp,"%5d: %s\n",i,stringspace+i);
		i += strlen(stringspace+i)+1;
	}
	fprintf(outfp,"\n\n");
}

#if __STDC__
void dumpsyms(void) {
#else
void dumpsyms() {
#endif
	int i;
	fprintf(outfp,"\n\nSYMBOL SPACE\n====== =====\n\n");
	for (i=0;i<idents;i++) {
		fprintf(outfp,"%3d %15s %10s %d\n",
			i,stringspace+namemap[i],
			(objects[i].type&FUNC_TYPE)?"function":"variable",
			(int)objects[i].p);
	}
}

#if __STDC__
void dumpcode(void) {
#else
void dumpcode() {
#endif
	short i = 0, a, o;
	fprintf(outfp,"\n\nCODE SPACE\n====== =====\n\n");
	while (i<codep) {
		fprintf(outfp,"%-4d %-15s ",i,opName[o = codespace[i]]);
		i++;
		a = opCnt[o]-1;
		while (a--) {
			fprintf(outfp,"%5d", codespace[i++]);
			if (a) fprintf(outfp,", ");
		}
		fprintf(outfp,"\n");
	}
	fprintf(outfp,"\nInitial entry point: %d\n",initialEntryPoint);
	fprintf(outfp,"\nDefault entry point: %d\n",defaultEntryPoint);
	fprintf(outfp,"\nCode size: %d\n",codep);
	fprintf(outfp,"\nString size: %d\n",stringp);
	fprintf(outfp,"\nSymbols: %d\n",idents);
}

#if __STDC__
void main(void) {
#else
void main() {
#endif
	lineno = -1;
	if (readFile(CODNAME,CODANAME,readcode)==0) {
		dumpstrings();
		dumpsyms();
		dumpcode();
#ifdef NO_STRERROR
	} else fprintf(stderr,"Cannot open code file\n");
#else
	} else fprintf(stderr,"Cannot open code file: %s\n", strerror(errno));
#endif
}



