/***********************************************************
*  getdiskblocks.c -- read disk blocks and write to file   *
*----------------------------------------------------------*
*  1995 Artsoft Development                               *
*        Holger Schemel                                    *
*        33659 Bielefeld-Senne                             *
*        Telefon: (0521) 493245                            *
*        eMail: aeglos@valinor.owl.de                      *
*               aeglos@uni-paderborn.de                    *
*               q99492@pbhrzx.uni-paderborn.de             *
***********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

#include "global.h"

unsigned char blocks1[BLOCKCOUNT1*BLOCKSIZE];
unsigned char blocks2[BLOCKCOUNT2*BLOCKSIZE];

void GetDiskBlocks(char *, char *, unsigned char *, int, int);

int main(int argc, char **argv)
{
  char progname[1024];

  strcpy(progname,GetFilename(argv[0]));

  if (argc!=2)
  {
    fprintf(stderr,"Usage: %s <disk device>\n",progname);
    exit(-1);
  }

  GetDiskBlocks(argv[1],FILE1,blocks1,BLOCKOFFSET1,BLOCKCOUNT1);
  GetDiskBlocks(argv[1],FILE2,blocks2,BLOCKOFFSET2,BLOCKCOUNT2);

  exit(0);
}

void GetDiskBlocks(char *device, char *file,
	      unsigned char *blocks, int offset, int count)
{
  int fd_device, fd_file;

  if ((fd_device=open(device,O_RDONLY))<0)
  {
    perror(device);
    exit(-1);
  }
  lseek(fd_device, offset*BLOCKSIZE, SEEK_SET);
  if (read(fd_device, blocks, count*BLOCKSIZE)!=count*BLOCKSIZE)
  {
    perror(device);
    exit(-1);
  }
  close(fd_device);

  if ((fd_file=open(file,O_CREAT | O_WRONLY,0666))<0)
  {
    perror(file);
    exit(-1);
  }
  if (write(fd_file, blocks, count*BLOCKSIZE)!=count*BLOCKSIZE)
  {
    perror(file);
    exit(-1);
  }
  close(fd_file);
}
