.TH TextConfig 5 "June 1995" "Version 0.9"
.SH NAME
TextConfig \- Configuration file for SVGATextMode
.de Ss
.sp
.ft CW
.nf
..
.de Se
.fi
.ft P
.sp
..
.SH DESCRIPTION
SVGATextMode uses a configuration file normally called TextConfig for its
initial setup. The default place for it is
.PP
.B /etc/TextConfig
.PP
It has a similar syntax as the configuration file for the XFree86 X-Windows
server. It adheres more or less to version 2 of the XFree86 config file (called
.B Xconfig
), but the new Xfree86 syntax, adopted since version 3 (and now called
.B XF86Config
) is quite similar, just a lot more structured.
.PP
Basically, the TextConfig file is scanned on a line-per-line basis, with no
specific ordering forced upon the user. In the entire configuration file,
character casing is not important (i.e.
.B ChipSet
and
.B chipset
, and any other upper/lowercase combination are considered the same label) 
.PP
Empty lines are allowed.
Any text following a
.B #
(hash) character is comment, and will be ignored.
.PP
You may (or may not) enclose certain strings in double quotes (") if you
like, but they are NOT used in any way. They are only of "cosmetic
importance".
.PP
.B Configuration lines
(except mode description lines) start with a
.B keyword
, which tells SVGATextMode what this line is about.
.PP
.B Mode description lines
start with a mode label, (any text enclosed in quotes, but quotes are not
compulsory), and followed by at least 9 numbers describing the mode
timings. A description of the meaning of these mode timings should be in the
.b MODE TIMINGS
section. Note that the mode label is just what the name says: a label.
Because the label says "100x37" does NOT mean this will actually produce a
100x37 text mode. The mode timings determine that.
.PP
Lines not complying with any of the above restrictions, or lines that use an
undefined keyword are simply ignored. This is quite dirty programming, but
easy, and very flexible from the user's point of view. It has the single
disadvantage that mis-typed labels are considered "not there" instead of
plain wrong.
.PP
Also consider reading the comments in the distribution TextConfig file as
well. They explain some modes and options as they come along.
.PP
When trying to create a new mode of your own, consider "testing" it first
non-destuctively: use
.Ss
SVGATextMode -n <MyNewMode>
.Se
(note the '-n' option) before doing the real thing (=without '-n'). This way
the program will show you what the new mode will look like, WITHOUT really
changing anything. This allows you to check if the H and V sync values will
work with your monitor. And it avoids a blank screen because some number was
wrong, and the mode line got screwed up.
.SH KEYWORDS
Several keywords are used by SVGATextMode to define what the line will
describe. This section only describes the syntax of the keywords, and some
general explanation. The complete syntax, with all possible entries for each
label is described in separate chapters below.
.SS ChipSet <some_chip>
This keyword tells SVGATextMode which SVGA chipset needs to be programmed.
The syntax is straighforward:
.Ss
\ \ Chipset "S3"
.Se
will make SVGATextMode treat your card as an S3 card. This can be any of the
many types of S3 cards around.
.PP
S3, as well as many other chipsets, have a range of different subtypes
around, but they basically are the same, and SVGATextMode only needs a tiny
bit of its full array of features (imagine what amount of the chip's full
potential you were using in text mode _before_ SVGATextMode was around, if
it's still only a tiny part of it _with_ STM ;-)
.PP
Roughly speaking, the pixel clock programming is all that is VGA chip
dependent form SVGATextMode's perspective.
.PP
Some chipsets are subdivided into different chipset ID's. This probably
means the subtypes _are_ different, and so they must be differentiated in
the config file.
.PP
See the
.B CHIPSET
section for a detailed listing of supported chipsets.
.SS ClockChip <some_clockchip>
Mostly for S3 chipsets, and optionally for Cirrus and some ET4000's, this
tells SVGATextMode that the pixel clock for this chipset does not come from
the "default" clock chip with (e.g.) 16 discrete clocks, but from a
programmable clock chip. All the clock chip drivers from the
.B XFree86
version 3.1.1 server are available, plus the ICS5341 GenDAC for ET4000W32p.
.PP
Example:
.Ss
\ \ ClockChip "ICD2061a"
.Se
.B Note for XFREE 3.1.X (or newer) users:
You WILL get into trouble with the newer XFREE servers that have some clock
chips built-in. When using one of the XFREE clock chips, X cannot restore
the textmode clock correctly any more (since they provided no means to tell
it which clock that was, as you COULD do with a ClockProg). If this is your
problem, sticking with the "old" ClockProg for XFREE might be the only
(temporary) solution, until the XFREE team cures the problem.
.SS ClockProg <path/to/ClockProg> [textclock]
This tells SVGATextMode that the clock is to be programmed using an external
clock setting program, not the default or ClockChip method.
.PP
This is especially useful for unsupported cards, or supported cards with
unsupported clock chips, because the clock porgramming is about the only
thing that needs to know what chip we're talking about.
.PP
It's also a useful stub for plugging in replacements for buggy or wrong
SVGATextMode clock code.
.PP
The syntax is rougly the same as the syntax for the XFree clock program, and
indeed any clock program written for XFree 3 should plug in without a
glitch. In theory.
.PP
Example (note the second argument is not necessary, and is ignored by
SVGATextMode):
.Ss
\ \ ClockProg "/usr/sbin/pixclock_prg" 2
.Se
The Following paragraph, from the XFree docs, shows how this program must be
used:
.PP
"This  optional entry runs the specified command to set the clock on the
graphics board instead of using the internal code. The command string must
consist of the full pathname (and no flags). When using this option, a
.B Clocks
entry is required to specify which clock values are to be made available to
the server (up to 128 clocks may be specified). The optional textclock value
is used to tell the server that command must be run to restore the textmode
clock at server exit (or when VT switching). textclock must match one of the
values in the Clocks entry. This parameter is required when the clock used
for text mode is a programmable clock."
.PP
.B Note for SVGATextMode:
the [textclock] argument is not used in SVGATextMode, since we're already
talking about text mode. Let's hope the XFREE server WILL use this, so the
SVGATextMode mode will be restored properly.
.PP
.B Note for XFREE users:
You MUST define the textclock in your XF86Config file when you are using a
clock program, because some clock chips don't allow reading back what was
programmed in them, so the X-server is unable to read, and then restore the
textmode clock when switching back to text mode, UNLESS you tell it what
clock was used!
.PP
When the ClockProg is run by SVGATextMode, two arguments are passed to the
command. The first is the clock frequency in MHz as a floating point number
and the second is the index of the clock in the Clocks entry:
.Ss
<path/to/clockprog> <frequency in Mhz> <clock index>
.Se
The command should return an exit status of 0 when successful, and something
in the range 1-254 otherwise.
.PP
.B NOTE:
as mentionned in the text above, you need to specify a clocks line, although
the clock chip can (in most cases) make any clock within a certain range,
and not just the ones in the clocks line. This requirement is necessary for
external clock programs that program an "old-style" clock chip with just a
fixed set of (mostly 16) clocks, like most "cheaper" VGA cards use. In that
case, the program will probably ignore the frequency parameter passed to it,
but will use the index number to select the appropriate clock. In the other
case, the index will be ignored, and the specified frequency will be
programmed.
.PP
The clock program path must be a
.B fully specified path
to a clock setting program that is SETUID ROOT! If it is not correctly
SETUID ROOT, you will get an error:
.Ss
 ./SVGATextMode: ERROR: 'system' returned error code 35584
.Se
No environment variables will be used. If your clock selection program uses
another interface, use a script that calls that one.
.SS Option <option_string>
Special options can be entered with this keyword. Some options are general,
and apply to any VGA card type. Other options are specific to one or a few
VGA cards. Any option enabled in the config file that is NOT allowed for the
VGA card in the
.B ChipSet
line, will cause an error message.
.PP
Example:
.Ss
\ \ Option "ClockDiv2"
.Se
See the separate
.B OPTIONS
section for a full list of all options and their meaning.
.SS Clocks <clock0> <clock1> [ <clock2> ... ]
The most important section in the
.B TextConfig
file (at least for some cards) is (are) the
.B Clocks
line(s). This entry in the config file tells SVGATextMode which clocks your
card has, and what their ordering is.
.PP
Some VGA cards do NOT need a clocks line, since they can create ANY possible
clock - within certain limts, and not just one from a fixed, given list.
These are:
.PP
- CLGD542x-based cards ("Cirrus Logic").
.PP
- All S3 cards for which a
.B ClockChip
must be defined.
.PP
When using a
.B ClockProg
(an externally called program to select the correct pixel clock, see the
appropriate section in this manual page), the clocks line MUST be specified,
even if the clock program is programming a fully programmable chip. By
requiring a clocks line, the ClockProg option can support both programmable
clocks, as fixed clock from a list (i.e. the Clocks line). See the Clockprog
section for a full explanation of the use of the "ClockProg" keyword.
.PP
All cases not mentionned above will need a "Clocks" line, or a set of clocks
lines. Any line in the TextConfig file that starts with "Clocks" will be
used, and all clock values will be appended into one big list of available
clocks.
.PP
The order of the clocks in the one or more clocks line(s) will also
determine their order: most VGA clocks generators are connected to the VGA
chips with a series of wires, constituting a bus. For 16 clocks, there are 4
wires, which are driven from 4 pins on the VGA chip, which are then driven
by a register in the VGA chip. If your clocks line would suggest the 4th
clock is a 45 Mhz clock, SVGATextMode will then put a "4" on that 4-bit bus
in order to select that clock. If you lied (=the actual 45 MHz is the 5th
clock, selected by putting a "5" on that bus), then you will not be getting
the expected clocks. Bad luck.
.PP
Example Clocks line:
.Ss
\ \ Clocks\ \ \ 25.3\ \ 28.175\ \ 36\ \ 40\ \ 0\ \ 45\ \ 50
.Se
Note that a 0 MHz clock MUST be entered in the Clock line! This just means
that there is no clock with that number (index). It must be there in order
to get the correct indexes for the ones following them (a "placeholder"). A
0 MHz clock will never be used by SVGATextMode.
.PP
Determining the values in the clocks line is a problem. There is no "simple"
tool around that can tell you the pixel clocks available on your card. The
easiest solution that is available on most systems is the XFree86 X-Windows
server. Typing
.B X -probeonly
should give you (amongst others) a list of clocks on your card. See the
XFREE manuals for more information
.B (XF86Config(5), XF86_SVGA(1), XF86_Accel(1)).
.PP
Just to be on the sure side, another warning: SVGATextMode assumes the clock
VALUES are correct. All timing parameters that you are given at the end of
the program are based on those numbers! Saying that clock number 3 is 40
MHz will make SVGATextMode behave as if that is the absulute truth. It will
use that clock as if it were 40 MHz. 
.SS Terminals <term_dev0> [ <term_dev1> ... ]
The 'Terminals' line tells SVGATextMode which terminal devices will be
affected by a possible screen resize, and need to be resized. It will resize
all mentionned terminals after switching to another mode.
.PP
Linux kernels versions 1.3.3 and up do this automatically, so this line is
not needed in that case, and will be ignored.
.PP
When this line is NOT defined, SVGATextMode will try to resize all ACTIVE
VT's (virtual terminals) automatically. The only limitation is that it can
only detect the first 16. If you have more than 16 VT's (64 possible!), or
if the automatic resizing does not satisfy you, define a 'terminals' line.
Only the terminal devices defined in it will be resized. The rest will be
left "untouched".
.PP
Enter the terminal devices without the leading "/dev/":
.Ss
\ \ Terminals tty6 tty5 tty4 tty3 tty2 tty1
.Se
This is equivalent to typing
.B stty rows <y> cols <x>
at every of those terminals. With the added advantage that any applications
running in those terminals will be sent an
.B SIGWINCH
signal by the kernel. Many full-screen terminal applications will redraw
their screen into the new sizes upon receipt of that signal.
.PP
But some programs will NOT know about the new screen size, and will not work
correctly anymore after a screen resize. They need a more drastic approach: the
.B ResetProg.
.SS ResetProg </path/to/ResetProg>
The "reset program" is called when SVGATextMode has finished its job
succesfully, but only when a ResetProg is defined.
.P
The path must be a fully specified path, like in
.Ss
\ \ ResetProg "/etc/resize_gpm"
.Se
The reset program could be used to "reset" any application that is affected
when the screen size changes due to using SVGATextMode. It could for example
be a script that kills selection and restarts it, or sends some other
application an appropriate signal to let it know the screen has changed.
.PP
The reset program will be called with TWO arguments: the H and V size of the
new text mode.
.PP
Example:
.Ss
\ \ SVGATextMode 100x37
.Se
will first switch to a 100x37 mode (if the
config line with that label actually described such a size), and then call:
.Ss
\ \ /some_path/some_script 100 37
.Se
.SS FontProg </path/to/Font_Loader>
.SS FontPath </path/to/textmode/fonts>
.SS FontSelect <size_X>x<size_Y> [ ... ] "<FontFileName>"
These keywords define the font loading program, the path where all the
textmode fonts are stored, and the font selection table.
.PP
SVGATextMode can be told to automatically load a new font when the text mode
has changed, by putting the option line
.Ss
\ \ Option LoadFont
.Se
in the TextConfig file.
.PP
In order to load a new font, SVGATextMode needs to know a few things. 
.PP
First of all: the font loading program. This is an external program, that
will be called with the specified font as an argument. It can for example
specified as:
.Ss
\ \ FontProg "/usr/bin/setfont"
.Se
Where "/usr/bin/setfont" is of course the full pathname of the font program.
If this line is NOT present, but you enabled font loading with the
"LoadFont" option, SVGATextMode will use the default path
"/usr/bin/setfont".
.PP
Secondly, you can also tell the font program where the fonts are
located:
.Ss
\ \ FontPath "/usr/lib/kbd/consolefonts"
.Se
If not specified, the font path defaults to "/usr/lib/kbd/consolefonts". 
.PP
Last but not least: you must let SVGATextMode know which font you want used
for which character cell size. This is accomplished by entering a font
table, as shown in the example below:
.Ss
\ \ FontSelect 8x8 9x8  "Cyr_a8x8"
\ \ FontSelect 8x12 8x13  "8x12alt.psf"
\ \ ...
\ \ FontSelect 8x16 9x16  "Cyr_a8x16"
.Se
For each possible character cell size you intend to use, a font file must be
specified. You do not have to add a font file for ALL possible combinations
of fonts from 1 to 32 pixels high and 8 to 9 pixels wide. But if you select
a text mode with a font size that has no entry in the font table, and font
loading is enabled, SVGATextMode WILL put you in the new text mode, but
won't change the font (since it doesn't know what font to load). It will
issue a warning that font loading was enabled, but no font specified.
.PP
When all things are configured as above, and you resize the screen to a
100x37, which uses a 9x16 font cell size (this information is in the mode
config line for the 100x37 mode), then SVGATextMode will issue the following
command after resizing the screen:
.Ss
\ \ /usr/bin/setfont /usr/lib/kbd/consolefonts/Cyr_a8x16
.Se
One final note on font sizes. VGA fonts are ALWAYS 8 pixels wide. But those
that are designed to work within an 8-pixel wide character cell, will most
probably not use the rightmost pixel column. Or in other words: they will
only use 7 (or even 6) of the available pixels, since they are put
back-to-back on the display in an 8-pixel wide font mode. The extra space
must be left open so the characters don't stick together, making them a bit
fuzzy to read.
.PP
For 9-pixel wide character cells, the VGA font, still only 8 pixels wide,
can now use all 8 pixels of its width to define the font. The VGA card will,
when displaying it, add one extra (blank) pixel to get to the 9-pixel width.
.PP
All this means that some VGA fonts are designed to be used in an 8-pixel
wide cell, and others are designed for 9-pixel wide cells. BOTH however
DEFINE only 8 pixels.
.PP
To make some special characters connect (like IBM box characters) without
gaps, the VGA card can be made to copy the 8th bit into the 9th.
.SS Cursor <start>-<end>
Depending on personal preference, and on the type of screen you work on, the
standard undercore cursor might be unsatisfactory. This type of cursor for
example is too small to be useful on laptop screens.
.PP
This keyword allows a fully programmable cursor size. To avoid needing a
cursor definition on each and every text mode definition line, there is just
ONE cursor definition in the TextConfig file, which is then used for ALL
text modes. Defining the cursor style for _every_ text mode line would cause
unnecessary clutter in those configuration lines.
.PP       
The parameters define the starting and ending line of the cursor, but this
is not a 1:1 mapping! The size of the cursor depends on the size of the
selected font. If you selected a 16-line high font, and then defining the
cursor to show from line 7 to line 8, will put it smack in the middle of the
line. defining the same numbers for an 8-line font would put the cursor on
the bottom of the text line (= and underscore cursor).
.PP
That's why the cursor definition as shown above will ALWAYS be relative to a
32-line font (the largest possible font size). If the REAL font size is
smaller, it will be scaled to fit that font size. So defining an underscore
cursor for 32-line fonts will also get you an underline cursor for any other
font size.
.PP
example:
.Ss
\ \ cursor 28-31
.Se
results in an underscore cursor for ALL text modes, while
.Ss
\ \ cursor 0-31
.Se
will get you a block cursor.
.PP
The first example, when used in a 16-line font, is scaled with a factor 16/32,
and thus will in reality be a cursor from line 14-15.
.PP
.B NOTE:
Disabling cursor blinking is only possible on SOME SVGA cards, or on all in
monochrome mode. This feature is not implemented in SVGAtextMode (yet?).
.SS HorizSync  <from>[-<to>] [, ...]
.SS VertRefresh  <from>[-<to>] [, ...]
The HorizSync and VertRefresh lines allow you to protect your monitor from
getting a mode from the VGA card it cannot handle. This is useful for both
avoiding the problem of accidently getting into a non-syncing mode, and also
avoids the (very small) possibility of monitor damage due to extremely
out-of-range sync inputs (a monitor that gets destroyed by out-of-spec input
frequencies is a poor design, but knowing that when it's broke doesn't help
a lot)
.PP
The <from> and <to> are
.B floating point
numbers in kHz (for HorizSync) or Hz (for VertRefresh). When a single number
(= only <from>) is defined, a margin of +/- 0.3 (kHz or Hz) will be allowed:
.Ss
\ \ HorizSync 56
.Se
will allow a horizontal sync range of 55.7 to 56.3 kHz. This is useful for
fixed-frequency monitors (mostly workstation displays), or some old standard
VGA screens.
.PP
A more complex line could look like this:
.Ss
\ \ HorizSync 30.5-32,48.2,56
.Se
allows horizontal frequencies from 30.5 to 32 kHz, 48.2 and 56 kHz. Some
dual- or triple-scan monitors can use this method.
.PP
A standard multisync screen could for example use the following line:
.Ss
\ \ HorizSync 30-64
.Se
Not defining the HorizSync/VertRefresh variables implies the default values:
.Ss
\ \ HorizSync 30-32          # 30 to 32 kHz
\ \ VertRefresh 50-80        # 50 to 80 Hz
.Se
Changing these values BEYOND what your monitor can handle, COULD result in
damage to the monitor! See your monitor's user's manual for details.
.SS DacSpeed <Frequency>
This line overrides the built-in maximum pixel clock speed for text mode for
the specified chipset. Since most VGA card manufacturers don't bother
mentionning this value in their data sheets, the defaults were "guessed"
from reports from users. The values are by no means "absolute", and they are
no guarantee that staying below them will NOT destroy the VGA card (although
it's pretty sure), and also they are no guarantee that anything ABOVE that
frequency will NOT work...
.PP
Depending on the quality of your card, and especially of the speed of the
RAM chips used on it, the built-in limit can be either too high or too low.
The built-in ones are mostly on the safe side.
.PP
The default
.B DacSpeed
values are:
.TP
.BI VGA,\ TVGA9000,\ VIDEO7\ and\ PAVGA1
45 MHz
.TP
.BI TVGA8900,\ WDC90C0X,\ WDC90C1X\ and\ WDC90C2X
50 MHz
.TP
.BI Cirrus,\ ATI\ and\ ATIMACH32
55 MHz
.TP
.BI S3
70 MHz
.TP
.BI WDC90C3X
90 MHz
.TP
.BI ET4000
95 MHz
.SS DefaultMode <Mode_label>
Using this optional keyword, one can define which mode should be used when
SVGAtextMode is started without any mode label on the command line.
.PP
The only argument is a mode label which should be defined in one of the mode
definition lines in the rest of the config file. In fact, SVGAtextMode will
act as if the label in the
.B DefaultMode
line was typed on the command line as the required mode.
.PP
This option could be especially useful when experimenting with SVGAtextMode,
and something goes wrong, causing the screen to become unreadable. To
restore a good mode, you'd then have to do some blind typing. The
DefaultMode would then allow you to restore a good text mode without having
to type too much.
.PP
Example: if the line
.Ss
  DefaultMode "80x25x9"
.Se
is in the TextConfig file somewhere, then just typing
.Ss
  SVGATextMode
.Se
at the shell prompt is exactly the same as typing
.Ss
  SVGATextMode 80x25x9
.Se
.SH Supported CHIPSETs
Until now, the following VGA chipsets are supported:
.TP
.BI VGA
Generic VGA chips. This can also be used for unsupported VGA chips, but with
very limited possibilities.
.TP
.BI ET4000
Probably any ET4000-based card: et4000, et4000ax, et4000w32, et4000w32i and
et4000w32p. Note that most ET4000 cards need the
.B Option "hibit_high"
or
.B Option "hibit_low".
.TP
.BI S3
any S3-based card, including those from Diamond, Number 9 and SPEA/Video7.
S3-801, 805, 864, 964, 928, 924, 921, 732 and 764 (S3-Trio)... _should_ all
work.
.TP
.BI CLGD542x
Cirrus Logic chipsets (clgd5420, clgd5422, clgd5424, clgd5426, clgd5428,
clgd5429, and possibly also clgd5430, clgd5434, clgd6205, clgd6215,
clgd6225, clgd6235)
.TP
.BI TVGA9000
Older Trident cards using the TVGA9000 chipset (those with max 512k RAM)
.TP
.BI TVGA8900
All other non-acelerated Trident cards (tvga8800cs, tvga8900b, tvga8900c,
tvga8900cl). Some Trident Accelerators (the tvga92xx and 94xx) don't work.
.TP
.BI PVGA1
Western Digital Paradise chips.
.TP
.BI WDC90C0X
Western digital. WDC 90C00.
.TP
.BI WDC90C1X
Western digital. WDC 90C10
.TP
.BI WDC90C2X
Western digital. WDC 90C20
.TP
.BI WDC90C3X
Western digital accelerated SVGA chip. Most common is the WDC 90C33, also
90C31.
.TP
.BI ATI
All ATI cards BEFORE the MACH32
.TP
.BI ATIMACH32
ATI MACH32 and MACH64
.TP
.BI VIDEO7
Headland Technologies based Video 7 boards only. Older V7 boards use C&T or
Cirrus chips. Newer V7/SPEA cards use S3.
.SH OPTIONS
This section contains a list of all allowed special option flags, as entered
on an
.Ss
\ \ Option "option_string"
.Se
line. They change the default behaviour for each card or function programmed
into SVGATextMode. Currently the following options are allowed (for the
specified chip sets):
.PP
If you are configuring SVGATextMode for the first time, it is best to leave
all special options at their default (i.e. no special "option" lines). If
something doesn't work OK, THEN is the time to start trying option flags.
.PP
If you know your card needs the same option in XWindows, you could insert it
from the first time on. Most options behave the same way as they do in the
XConfig (XF86Config) file.
.SS hibit_high, hibit_low\ \ (ET4000 only)
This flag inverts the meaning of the 4th clock selection bit of an ET4000
card. See the XFree86 documentation or the SVGATextMode distribution doc
directory for more information. It has the same meaning and function as the
flag with the same name in the XF86Config file for XFree86. A simple
guideline (which doesn't always apply) is that ET4000W32 cards _all_ need
the
.B hibit_high
flag.
.SS swap_hibit\ \ (WDC90C1X, WDC90C2X, WDC90C3X)
Some WDC cards need this flag. It inverts the meaning of the third clock
selection bit (bit #2). It has the same meaning as in the XFREE config file
(XF86Config). If your clock ordereing doesn't seem OK, try this option.
.SS ET4000_AltClockSel\ \ (ET4000)
This selects an alternative clock selection method for some very rare ET4000
based cards that don't work with the normal clock selection method. These
cards can only use their 8 lowest clocks under X-Windows (the X-server does
NOT support the alternate clock selection method used here). This option
should allow them to use all 16 clocks (i.e. those reported by the DOS
utility "dmode.exe" which is delivered with most ET4000 boards. NOTE that
XFree86 does NOT report the correct clocks!) Read the
README.ET4000.AltClockSel file in the SVGATextMode distribution directory
for an in-depth explanation of this problem.
.SS Legend\ \ (ET4000, S3)
ET4000 or S3-based Sigma Legend boards need this option for correct clock
selection.
.SS XFAST_DRAM, FAST_DRAM, MED_DRAM, SLOW_DRAM\ \ (CLGD542X)
Most Cirrus boards can take higher pixel clocks when you increase the
default DRAM speed. But some CIrrus cards crash your machine when DRAM speed
is too high. Use this option to tune the speed to your card. The higher you
can set the DRAM speed, the better. "XFAST_DRAM" is the fastest, and the
most dangerous. This particular option works on most CLGD-5428 cards, and it
causes a hang on most 5422 cards... Use caution. Faster pixel clocks usually
need faster DRAM speed grades.
.SS SPEA_Mercury\ \ (S3)
Only S3-based SPEA Mercury P64 cards need this. Not used yet anyway.
.SS Number_Nine\ \ (S3)
Not used (yet). Ti3025 RAMDAC based '#9GXE64 Pro' cards can get better
performance with this option (This sets the memory clock to 55 MHz).
.SS LoadFont\ \ (all cards)
When enabled, this will tell SVGATextMode to load a new font from the
specified FontPath (or the default one) using the specified font loader (or
the default one). See the font loading section.
.SS ClockDiv2\ \ (all cards, except those with programmable clockchip)
This option will enable a standard VGA feature that can divide the pixel
clock by 2. Almost all VGA cards support this (except Cirrus Logic, for
which it has been disabled).
.PP
It gives you access to a wider range of clocks, especially in the low
ranges, since now all given clocks are also available divided by 2. It also
gives you more clocks in the "mid-range".
.PP
Enable it ONLY when you are sure SVGATextMode works for your card. Since
some cards might not work with this option set, it is disabled by default in
the default TextConfig file! Some modes (like the 50x15 ones) will only be
allowed when this option is enabled, because most card's lowest clock is 25
MHz, and some of the 50x15 modes need a lower clock.
.PP
This is a useless option for cards with a clockchip (eg S3 cards with icd2061a,
..., and Cirrus cards), since they can generate ANY clock frequency you
want. No real use for another division by 2 then...
.SH CLOCKCHIPS
This is a list of all allowed clock chips. They are the same as in
Xfree86-3.1.1. In addition, the ICS5341 GenDAC used on some newer ET4000W32p
cards is also included. All clockchips are for S3 only, except otherwise
noted.
.PP
.B icd2061a
.PP
.B ics9161a
.PP
.B dcs2834
.PP
.B sc11412
.PP
.B s3gendac
.PP
.B s3_sdac
.PP
.B ti3025
(This one does not work yet!)
.PP
.B ics2595
.PP
.B ics5300
.PP
.B ics5342
.PP
.B ch8391
.PP
.B S3Trio
.PP
.B Cirrus
(For Cirrus Logic cards only. This is optional: this clockchip is always assumed
for these cards)
.PP
.B ics5341
(For ET4000 cards with GenDAC)
.SH MODE CONFIGURATION LINES
This section describes the guts of the TextConfig file: the mode description
lines. It's long, and probably not long enough...
.PP
First of all: if you are not familiar with configuring the X-server, you'd
better start off there, as it is MUCH more stable, MUCH less buggy, and MUCH
better documented. You will also learn how to use several tools (vgaset,
SuperProbe, ConfigXF86, ...) which can aid you to design your own custom
X-Windows mode. The same tools can then be used here.
.PP
For people less familiar with monitor timing stuff, and unwilling or unable
to consult the XFree86 documentation, read the 
.B monitor-timings.howto
in the doc directory of the SVGATextMode distribution. It's a small (and
incomplete) introduction on how monitors work, and what you need to send it
to get some sort of a picture on it.
.PP
You will probably need the X-server (e.g. to do 'X -probeonly') to determine
your available pixel clocks, and maybe even to determine what chipset you
have.
.B The clocks lines in the distribution TextConfig are just examples,
.B and only work for some cards. Don't use them unless you know they're OK.
The distribution contains a script that can help you determine the pixel
clocks in case there is no way to get by them.
.PP
The text mode lines are the real thing: they set up the video card for the
mode you request. A TextConfig file can contain LOTS of configuration lines.
It would be best that you leave the "default" config lines in the example
TextConfig file as they are.
.PP
Add your own configuration lines at the end. If you patch a line, first copy
it to the end of the file, and change it there. You don't have to rename it,
as SVGATextMode will take the LAST line with the same label it finds. So if
your custom line, with the same name as an "original" one is at the end, the
customized line will be used.
.PP
That way you will always have the original lines as a reference, in case you
screw your own line up. You can then always copy it again.
.PP
Now let's analyse a new text mode:
.PP
.Ss
"100x37"  50  800 872 976 1040  600 632 638 670  -Hsync +Vsync  font 8x16
.Se
(The entire mode line should be on a single line. Use SVGATextMode to get a
screen with at least a 100 chars on a line, and reformat the manual page.
This way it won't look like a folder!)
.PP
Below is a piece-by-piece examination of the different parts in the mode
line:
.SS 100x37
This is the identification string for this text mode. If you the type
.Ss
SVGATextMode "100x37"
.Se
the program will try to program the mode descibed on this line.
.SS 50.00
The pixel clock frequency. It determines the clock frequency (in MegaHertz)
at which the pixels will be pushed towards the monitor. It is entered as a
floating point number.
.PP
Unless you have a freely programmable clock chip (using the
.B ClockChip
line, or with a
.B Cirrus Logic
card) on your VGA card, SVGATextMode will try to find the closest available
pixel clock in the
.B Clocks
line, allowing a slight deviation of a few MegaHertz: asking for a clock of
50 MHz, and having only a 49 MHz clock will make SVGATextMode use the 49 MHz
clock. This shouldn't be a problem, because monitors always allow a fairly
large deviation of their input frequencies.
.SS 800 872 976 1040
Horizontal timing parameters: resp. active video size (number of active or
visible pixels per video line), start and stop position of the Horizontal
sync signal, and the full wisth of a video line, including active size and
blanked (unused) size.
.PP
See the XFree documentation for a thorough understanding of these, or try
the monitor timing tuturial in the distribution. See also below in the
section on 9-pixel fonts for some explanation on the effect of selecting an
9-pixel font on these timings!
.PP
Your textmode will have one eighth the number of characters per line as in
the active video size (the first number of the horizontal timing parameters)
REGARDLESS of the font size specified. So in this case :
.B 800/8 = 100
characters per line.
.PP
Calculating the horizontal frequency (which your monitor must be able to
cope with, if you want to use this particular mode) is easy: just divide
the pixel clock by the total amount of pixels on a single line:
.PP
   50000000 / 1040  =  48076 Hz, or 48 kHz
.PP
This calculation is ONLY true for 8-pixel wide modes! If this were to be a
9-pixel wide mode, and the clock remained at 50 MHz, then we'd get:
.PP
   50000000 / 1040 * (8/9) = 42734 Hz, or 42.7 kHz
.PP
If you want a general purpose formula: here's one:
.Ss
Hor_freq = pixel_clock / total_hor_pix * (8 / font_width)
.Se
.SS 600 632 638 670
Vertical Timings. Equivalent to the horizontal ones. The number of textlines
(rows) in your textmode will depend on the font size selected:
.Ss
number_of_textlines = number_of_active_lines / font_height
.Se
Here we have 600 active lines, and a font of 16 pixels high (see below), so
there will be 600/16 = 37 textlines.
.PP
Deriving the vertical refresh is even easier than horizontal: just do
.Ss
Vert_freq = Hor_freq / total_vert_lines
.Se
In this case, we'd get 48076 / 670 = 71.75 Hz.
.SS -Hsync +Vsync      
Hsync and Vsync polarity (positive (
.B +Hsync
) or negative (
.B -Hsync
)). Most modern monitors don't care about sync polarities, BUT most USE
them.
.PP      
Simple fixed-frequency or dual frequency monitors (so non-multisync, e.g.
only 32 and 48 kHz, instead of the entire range from 32 to 48), and some
non-digital-control ones use the polarities to change their vertical screen
size.
.PP   
Cheap monitors have the habit of not having a constant vertical image size,
independent of the vertical refresh frequency. So your monitor might use the
entire screen at a normal 60 Hz frequency, but the image is larger (higher)
at lower frequencies, and smaller (more flattened) at higher ones.
.PP
These VGA monitors use the sync polarities to distinguish between several
vertical refresh frequencies, and to adapt their vertical size. A MAG
PMV1448 for example is a fixed 32/48 kHz dual-scan monitor. At 800x600@70Hz,
the screen is either only half the vertical size, or the entire screen,
depending on sync polarity. So some experimenting with polarities might give
you a full screen, even with >70 Hz refresh rates. (The same applies to the
XF86Config as well!)
.PP      
More expensive monitors, mostly with "digital control", use the sync
polarities COMBINED with the incoming horizontal and vertical frequencies to
determine whether they will take their screen parameters (amongst which the
vertical screen size) from a database of standard resolutions, or from the
(scarce!) user-settable modes. If you succeed in using one of those default
modes, that saves you one more free user-settable mode. Taxan 875 monitors
for example have only 4 programmable modes, and when you've just tweaked
X-windows into some weird modes, you might run out of user-settable modes.
It might be a good idea to try to create standard SVGA timings for your
textmodes (including the correct sync polarities), so your monitor
recognises them, without needing an extra entry in its screen parameter
database.
.PP
The sync polarities are an
.B option.
They are not required: if none are given, SVGATextMode will assign sync
polarities according to the VGA standards, depending on the number of active
video lines:
.Ss
0..399 lines: +Hsync -Vsync
400..479 lines: -Hsync +Vsync
480..767 lines: -Hsync -Vsync
768 and up: +Hsync, +Vsync
.Se
.SS font 8x16
Font size: "font HxV" selects the horizontal size (character width = H) and
vertical size (character heigth = V) of the textmode font. The possible
ranges are:
.Ss
H = 8 or 9
V = 1 to 32
.Se
These are the hardware limits. Not all of them are as useful. Don't be
surprised if you cannot read text of only 1 pixel high!
.PP
The VGA chip must know these values in order to render the font correctly.
The font size together with the H- and V-timings from (2) and (3) determine
the number of characters per line, and the number of lines per screen.
.PP      
If the font size is not defined, 8x16 will be assumed.
.SH Using 9-pixel wide font sizes
The VGA hardware is a strange thing. And using 9-pixel fonts is amongst the
stranger ones.
.PP
The timing parameters are the same for both 8 and 9-pixel wide fonts, except
for the clock. Horizontal timings in VGA cards are _always_ specified in
8-bit wide CHARACTERS, not in PIXELS, although the TextConfig file format
uses pixels.
.PP
Hence the restriction that horizontal timings should be a multiple of 8 (if
they're not, they will be rounded down).
.PP
When setting the character width of an existing 8-pixel wide mode to 9,
horizontal timings are still in 8-bit characters. So both modes will result
in the SAME amount of characters per line, but the VGA chip will count 8
pixels per character in the first case, and 9 in the second case.
.PP
Take for example a standard 80x25 mode:
.Ss
"80x25x8" 25.175  640 680 776 800  400 412 414 449  font 8x16
.Se
and its 9-pixel wide derivative:
.Ss
"80x25x9" 28.3    640 680 776 800  400 412 414 449  font 9x16
.Se
Both modes produce the same screen size (80x25), using the same display
refresh frequencies (31.5 kHz, 70 Hz).
.PP
But in the first case, the total _actual_ pixel-count at the end of the
video-line is (800/8)*8, and (800/8)*9 in the second case !!! To achieve the
same horizontal frequency of 31.5 kHz, the second mode needs a higher clock:
.PP
   (9/8)*25.175 MHz = 28.3 MHz
.PP
and that happens to be the second standard VGA clock, which is available on
ALL VGA cards. Now you know why they added it in the first place ;-)
.PP
This example should warn you about changing modes from 8-wide to 9-wide or
vice-versa: if you don't change the clock with the same 8/9 ratio, the
display refresh rates will change, and they might fall outside the allowable
range for the monitor (i.e. it will not synchronize to the new frequency).
.SH BUGS
A configuration file has no bugs, of course. Any problems with it are either
your own, or SVGATextMode's fault.
.PP
There are a few limitations. One of them being the 16K (16384)
characters-per-screen limit. This is either a hardware limit, or a kernel
limit. You would need to define an awesome screen size before running into
that limit: 160x100 or 180x80 characters per screen is still possible...
.PP
Another limit is the maximum amount of clocks in all the clocks lines
together: 64.
.PP
Perhaps the most dangerous (?) limit is that any line or separate string in
a line may not contain over 1024 characters.
.SH FILES
.B /usr/sbin/SVGATextMode
\- The program which needs the TextConfig file
.PP
.B /etc/TextConfig
\- the configuration file described here
.SH AUTHOR
SVGATextMode was written by Koen Gadeyne <kmg@barco.be>, with help from a
lot of local and remote Linux fans. See the
.B CREDITS
file in the distribution for a full list of all helping hands.
.PP
The XFree86 configuration file (Xconfig, XF86Config) has been the main
guideline in creating the TextConfig format.
.SH SEE ALSO
SVGATextMode(1) \- Textmode manipulation/enhancement tool
.PP
grabmode(1) \- A XFree/SVGATextMode VGA mode grabber
.PP
XF86Config(5) \- Configuration file for XFree86
.PP
XF86_SVGA(1) \- Non-accelerated SVGA X Window System servers
for UNIX on x86 platforms
.PP
XF86_Accel(1) \- Accelerated X Window System servers for UNIX on x86
platforms with an S3, Mach8, Mach32, Mach64, P9000, AGX, ET4000/W32 or
8514/A accelerator board
.PP
The monitor timing tuturial in the SVGATextMode distribution could be a
handy reference for creating custom text modes.

