.TH SVGATextMode 8 "June 1995" "Version 0.9"
.SH NAME
SVGATextMode \- Textmode manipulation/enhancement tool
.SH SYNOPSIS
.B SVGATextMode
[ 
.B -n
] [
.B -d
] [
.B -h
] [
.B -r
] [
.B -f
] [
.B -c
] [
.B -v
] [
.B -s
] [
.B -a
] [
.B -m
] [
.B -t
ConfigFile ] TextmodeLabel
.SH DESCRIPTION
.BI SVGATextMode
provides a means to seriously enhance the looks of your Linux text consoles,
by re-programming the (S)VGA hardware. It uses a configuration file similar
to the one the Linux X-windows server uses (Xconfig or XF86Config) to set up
better looking textmodes. (=higher resolution, larger font size, higher
display refresh...).
.PP
It works independently of what text modes are allowed from the BIOS. In
theory, any text mode size is possible, as long as your VGA card is up to
the job. Whether it is or not, depends greatly on the chipset.
.PP
SVGATextMode can resize the console screen on the fly, without rebooting, to
any other size. The configuration file holds all the parameters needed for
the new mode.
.PP
It needs kernel version
.B 1.1.54
or newer if screen resizing is to be possible.
.PP
Until now, the following VGA chipsets are supported:
.TP
.BI VGA
Generic VGA chips. This can also be used for unsupported VGA chips, but with
very limited possibilities.
.TP
.BI ET4000
.TP
.BI S3
any S3-based card, including those from Diamond, Number 9 and SPEA/Video7.
.TP
.BI CLGD542x
Cirrus Logic chipsets. This COULD also work with the CL-GD543X chipsets ("Alpine" chips).
.TP
.BI TVGA8900
.TP
.BI TVGA9000
.TP
.BI PVGA1
.TP
.BI WDC90C0X
.TP
.BI WDC90C1X
.TP
.BI WDC90C2X
.TP
.BI WDC90C3X
.TP
.BI ATI
All ATI cards BEFORE the MACH32
.TP
.BI ATIMACH32
ATI MACH32 and MACH64
.TP
.BI VIDEO7
Headland Technologies based Video 7 boards only. Older V7 boards use C&T or
Cirrus chips. Newer V7/SPEA cards use S3.
.PP
SVGATextMode needs a configuration file with a similar syntax as
.B Xconfig
or
.B XF86Config
, the configuration file for XFREE, the X-Windows server. The default config
file is
.B /etc/TextConfig.
See the
.B TextConfig(5)
manual file for details on its syntax.
.PP
When running SVGATextMode with a new textmode, it will output a single line,
describing what the new mode is, and what are the screen refresh rates.
.PP
.I Example output:
Chipset = 'S3', Textmode clock = 75.00 MHz, 116x48 chars, CharCell = 9x16.
Refresh = 55.93kHz/69.9Hz.
.SH OPTIONS
The only required option is the
.B TextmodeLabel
, which tells SVGATextMode to which mode it must switch. A mode description
line with the same name must be present in the config file. The parameters
on that line will be used to program the new text mode.
.TP
.I -n
don't program the new mode. This option will scan the config file for the
requested mode, parse all parameters, and report what the new mode will look
like. But it doesn't actually change anything. This is useful for seeing if
a mode is correctly entered in the config file, and if your monitor will be
able to handle it.
.TP
.I -d
debugging mode. SVGATextMode will output lots of debugging information about
all the things it attempts to do. This is mostly for "internal purposes"
only, but it could help you discover why SVGATextMode doesn't react as you
expect it to. This could also be useful when reporting a problem.
.TP
.I -h
prints out a short help and the version number. 
.TP
.I -r
don't run the
.B ResetProg.
When the ResetProg is enabled from the config file, SVGATextMode will
attempt to run it whenever it has changed the screen size. The ResetProg is
normally used to signal or restart a program that depends on the current
screen size, and that doesn't react to the
.B SIGWINCH
signals SVGATextMode sends it upon a screen resize. This option is useful
when SVGATextMode is started from the system initialisation files
(/etc/rc.d/...), because many of the programs that need to be reset through the
.B ResetProg
have not yet been started, so trying to send them signals, or trying to kill
them, would fail.
.TP
.I -f
don't run the
.B FontProg.
When the font loader is enabled through the
.B LoadFont
option in the config file, SVGATextMode will not run it, even when the
screen is resized. When this option is not enabled and the font loader is
enabled, SVGATextMode will run an external program to load a suitable font.
.TP
.I -c
don't program the pixel clock. More of a debugging option. If you suspect
that SVGATextMode fails to program your VGA clock properly, then this option
programs everything else
.B except
the pixel clock, which is left at its old value. Some laptops don't react to
well when the pixel clock is reprogrammed, so this option can help there,
too.
.TP
.I -v
don't validate H/V frequencies. Normally SVGATextMode will check the
horizontal frequency and the vertical refresh of the new mode against the
ranges specified in the config file, and refuse to program a mode that
doesn't fall within those limits. This option turns off that checking, and
will program ANY mode, even if the config file says your monitor cannot
handle them.
.TP
.I -s
scan mode. SVGATextMode will scan the entire config file, and will dump a
listing of all valid modes for your configuration, taking the limitations
for vertical refresh and horizontal scan rate into account. When combined
with the
.B -v
option, it will dump all modes, whether they are allowed or not.
.TP
.I -m
allow trying to resize screen via a 1x1 screen. This option is only useful
when you get an
.B out of memory
error when resizing the screen. Normally SVGATextMode will just exit and
tell you there was not enough memory. The best thing to do then is to free
some memory. If that is impossible for some reason, this option will first
resize the screen to a 1x1 size to free the memory already taken up by all
the consoles, and then resize to the desired size.
.B WARNING:
see the
.B BUGS
section for more information on the potential dangers of this method. Do not
use this option unless it is absolutely necessary.
.TP
.B -a
always do a full resize. SVGATextMode will normally check with the old
screen size to see if the new mode actually resizes the screen (it could
just
.B enhance
the screen by moving to a larger font, but remain at the same width/height).
It does that via the tty settings (those you get when typing "stty -a"). If
it detects that the new mode is a different size than the old one, it will
run all sorts of extra code to make various system components know about the
resizing. But if it thinks no actual resizing has been done, it won't do
that. Under certain circumstances (see the
.B BUGS
section), it is desirable to resize the screen, even if the tty settings say
the screen already has that size. This option will force the resizing code
to "fake" a resize, and run all necessary code (set the tty settings again,
tell the kernel about the resizing, and run the optional
.B ResetProg
).
.TP
.B -t ConfigFile
This option tells SVGATextMode to use a different configuration file than
the default one (
.B /etc/TextConfig
).
.SH EXAMPLE
A small example of how SVGATextMode goes to work: suppose you started up in
80x25 text mode, and wanted to change to a more respectable 116x48 mode with
a fine 16-pixel high font (normal 132x43 modes from the BIOS are only 8 to
11 pixels high, and the difference is incredible), and extra-wide spacing
(using 9-pixel wide characters instead of 8).
.PP
Now suppose you have a mode description line in the config file that looks
like this:
.PP
"Super116x48"\ \ 75\ \ 928\ 968\ 1104\ 1192\ \ 768\ 775\ 776\ 800\ \ 
font\ 9x16
.PP
(the entire config line must be on a single line)
.PP
After correctly configuring the
.B /etc/TextConfig
file for your VGA card, typing
.B SVGATextMode Super116x48
will produce an output similar
to the following:
.PP
Chipset = 'S3', Textmode clock = 75.00 MHz, 116x48 chars, CharCell = 9x16. Refresh = 55.93kHz/69.9Hz.
.PP
Loading 8x16 font from file /usr/lib/kbd/consolefonts/Cyr_a8x16
.PP
Note the refresh timings at the end of the first output line: this mode
would require an SVGA monitor capable of 56 kHz at 70 Hz (the same
frequencies as a VESA 1024x768 @ 70 HZ mode).
.PP
The second output line actually comes from
.B setfont
, a program which SVGATextMode can be made to call automatically after
resizing the screen, so the font is adjusted to the available space in the
character cell.
.SH BUGS
Probaby zillions of them. And for a program that must be run as root, and
that changes hardware registers, this is not a good thing.
.PP
SVGATextMode does not even try to detect the VGA chipset you are using. This
means that if you configure it for an S3 chip, but there's a Cirrus Logic
under the bonnet, you'll get a similar effect as when you try to use diesel
fuel in a petrol engine...
.PP
You need at least kernel version
.B 1.1.54
to be able to resize the screen to some other X/Y dimension than is
currently being used. The program will refuse to resize the screen when it
detects an older kernel version.
.PP
When the system is under heavy load, screen resizing could bail out with an
.B out of memory
error. The reason for this is rather obscure, but it boils down to the fact
that you need to have
.B at least
a certain amount of free RAM if you want to avoid this. The amount depends
on the requested screen size. On most linux systems (which have a maximum
possible amount of virtual consoles of 64), this is:
.TP
.I X * Y * 2 * 64
.PP
bytes of memory, where X is the number of characters per line, and Y the
number of text lines on the screen.
.PP
The
.B -m
option is a way around this, but it has its own problems. When it
temporarily switches to a 1x1 screen in order to free some more memory, some
other process might snatch memory away from under it before SVGATextMode can
switch back to the new mode, causing the final resize to the new size to
fail. This is very unlikely to happen, but when it does, you are left with a
1x1 screen, which is rather small. When that happens, blindly stopping some
jobs, and blindly resizing to a 80x25 mode (either through
.B SVGATextMode
or
.B set80)
is the only solution.
.PP
There are some nasty interactions with other programs that do VGA
programming. Amongst them are: the
.B XFREE
XWindows server,
.B svgalib, dosemu
and probably others. The most common effect is a distorted screen when such
a program switches back to text mode. The real reason for this mostly lies
with that program, because it doesn't restore all VGA chip registers as they
were before that program started. They were all written a long time before
SVGATextMode saw the light of day, so how could they know?
.PP
SVGATextMode cannot really solve this problem, since it exits after setting
the new mode, and so it doesn't stay active to restore the mode whenever
another one screws it up.
.PP
Most problems with
.B XFREE
happen when you change the text mode
.B after
X has been started. The X-server remembers all VGA chip settings when it
first starts up, and never seems to check them again. So when you start X,
switch back to text mode while X is still running, then change the text mode
to something else, switch back to X, and then back to text mode, you're in
trouble. X has restored the VGA register contents of when
.B it
started, which are not the same that you programmed with SVGATextMode. But
the kernel still thinks you are in the
.B new
mode, since X didn't tell it about the restoration to the old values, and
thus the kernel draws its characters in the wrong place in the video memory.
.PP
Result: screen completely garbled. Solution: re-running SVGATextMode
whenever you switch back from X to text mode, or exit X, and restart it
.B after
re-programming the
.B new
text mode.
.PP
The former case will need the
.B -a
option to tell SVGATextMode to force a full resize. When X restores the VGA
register contents, it
.B doesn't
restore the tty settings, nor the kernel screen size parameters. Thus
SVGATextMode is made to believe that the screen is not resized, and thus
doesn't do all the resizing code, leaving the kernel parameters and tty
settings as they were: wrong.
.SH SECURITY
In order to be able to do anything, SVGATextMode must be run by the
superuser, or it must be setuid root.
.PP
Having SVGATextMode installed with the SETUID bits ON makes it run as root,
even when a non-root user runs it. This is a potential security problem,
since SVGATextMode can be made to execute external programs (font loader and
ResetProg).
.PP
The default distribution will NOT renounce superuser rights EVER, so it'll
run any external program as root also (if the setuid bits on SVGATextMode
are on, of course). If you are administering a critical system, don't set
the SETUID bits on SVGATextMode (which will have the side effect that
non-root users cannot use SVGATextMode), or if you do, make sure that all
externally called programs are secure.
.PP
If you want to have the SUID bits on, but don't trust the external program's
security, then recompiling SVGATextMode with the compile-time option
"RUN_SECURE" enabled will make SVGATextMode renounce superuser rights
immediately after requesting rights to write to the VGA registers. Any
program run thereafter will be run with the user ID of the one executing
SVGATextMode.
.PP
If the programs called by SVGATextMode are not setuid root, they might fail,
because they want to change things only root is allowed to tamper with.
.SH FILES
.B /etc/TextConfig
\- The configuration file for SVGATextMode
.PP
.B /usr/sbin/SVGATextMode
\- The main text mode manipulation program described here
.SH AUTHOR
SVGATextMode was written by Koen Gadeyne <kmg@barco.be>, with help from a
lot of local and remote Linux fans.
.PP
Much of the VGA code for SVGATextMode was borrowed (I will give it back :-)
from the XFree 3.1 server code. The S3 clock chip code and Cirrus Logic
clock code was copied verbatim from the original XFree 3.1.1 code.
.PP
See the
.B CREDITS
file in the distribution for a full list of all helping hands.
.SH SEE ALSO
TextConfig(5) \- Configuration file for SVGATextMode
.PP
grabmode(1) \- A XFree/SVGATextMode VGA mode grabber
.PP
The 'doc' directory in the SVGATextMode distribution contains a lot of
miscellaneous documentation on a range of topics related to configuring and
using SVGATextMode.
