/*
This is a program to display menus on a text tty, good for limited access
guest accounts, or just for user menus.
Copyright (C) 1995  Brian Cully

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program; see the file COPYING. If not write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

please send patches or advice to: `shmit@meathook.intac.com'
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

/* Include configuration data */
#include "config.h"

#include "parse.h"
#include "screen.h"

char progname[255];
char *menufile;

void setupfile(const char *);

int main(int argc, char *argv[]) {
   struct menu *guest_menu;
   
   strcpy(progname, argv[0]);

   if (argc > 2) {
      fprintf(stderr, "usage: %s [menu-file]\n", progname);
      exit(1);
   }

   if (argc < 2) {
#if defined (DEBUG)
      printf("%s\n", DEFAULT_MENU);
#endif
      setupfile(DEFAULT_MENU);
   } else
      /* Load file into buffer */
      setupfile(argv[1]);

   /* Parse File */
   if (parsefile(&guest_menu, menufile) == -1) {
      fprintf(stderr,"%s: error while parsing\n",progname);
      freemem(guest_menu, menufile);
      exit(1);
   }

   init_scr();
   display_list(guest_menu);
   close_scr();
   
   /* Free all allocated memory */
   freemem(guest_menu, menufile);

   /* we outtie */
   exit(0);
}

void setupfile(const char *filen) {
   int fd;
   struct stat statbuff;

  /* Load Files, get stats, and malloc() buffer, read file into buffer */

   if ((fd = open(filen, O_RDONLY)) == -1) {
      fprintf(stderr, "%s: Couldn't open file %s for reading\n", progname, filen);
      exit(1);
   }

   if (fstat(fd, &statbuff) == -1) {
      fprintf(stderr, "%s: Couldn't get statistics on file %s\n", progname, filen);
      exit(1);
   }

   if (statbuff.st_size == 0) {
      fprintf(stderr, "%s: %s is an empty file\n", progname, filen);
      exit(1);
   }

   if ((menufile = (char *)malloc(statbuff.st_size)) == NULL) {
      fprintf(stderr, "%s: Couldn't allocate %i bytes from heap\n", progname, (int)statbuff.st_size);
      exit(1);
   }

   if (read(fd, menufile, statbuff.st_size) == -1) {
      fprintf(stderr, "%s: Couldn't read file %s\n", progname, filen);
      exit(1);
   }

   close(fd);
}
