/* dsp.h
	Hans E. Kristiansen

*/

#ifndef DSP_H
#define DSP_H

#define DEFAULT_DSP_SPEED 	9600

#define MODE_MONO 0

#define AUDIO "/dev/dsp"

#include <sys/soundcard.h>
#include <sys/ioctl.h>

/* Assist in debug */
extern int verbose;

void sync_dsp(int audio);
void set_dsp_speed (int audio, int dsp_speed);
void set_dsp_samplesize(int audio, int sample_size);
void set_dsp_mode(int audio, int dsp_stereo);
void set_dsp_volume(int audio, int left, int right);
void write_dsp_byte(int audio, int sample);
void read_dsp_byte(int audio, long * sample);
void close_dsp(int audio);

#endif DSP_H

