/*
 *	Configuration options for diald.
 */

/* If you are running the latest beta PPP 2.2 you'll need to define this.
 * Sorry, I don't know how to make diald work with both the old and the
 * new at the same time. The kernel interface to the PPP layer has changed.
 */
/* #define PPP_VERSION_2_2_0 */

/* You're lock files are probably somewhere else unless you
 * happen to be running something based on the BOGUS release.
 * usually they are in /var/spool/uucp or /usr/spool/uucp.
 */
#define LOCK_PREFIX	"/var/lock/LCK.."

/*
 * If you're lock files should contain binary PID's then
 * comment the following line out. I think most linux
 * distributions want ASCII PID's in the lock files.
 */
#define PIDSTRING

/* Define where to put the diald.pid file. Under the FSSTD this 
 * should be in /var/run, but you're system might have them
 * elsewhere. Check and be sure.
 */

#define RUN_PREFIX	"/var/run"

/*
 * Diald needs to be able to find its default configuration files.
 * These paths should match the installation path in the Makefile!
 */
#define DIALD_CONFIG_FILE "/etc/diald.conf"
#define DIALD_DEFS_FILE "/etc/diald.defs"

/*
 * Diald needs to use the route and ifconfig binaries to set up
 * routing tables and to bring up the proxy device. Check where
 * these executables are on your system and set these paths to match.
 */
#define PATH_ROUTE	"/sbin/route"
#define PATH_IFCONFIG	"/sbin/ifconfig"

/*
 * Diald needs to know where to find the bootpc binary in order to
 * use the bootp protocol for dynamic slip address determination.
 */

#define PATH_BOOTPC	"/sbin/bootpc"

/*
 * I you're never going to use pppd don't worry if this is wrong.
 * Otherwise, find your pppd executable and set this path to match its
 * location.
 */
#define PATH_PPPD	"/usr/sbin/pppd"

/*
 * By default diald will route all outgoing packets to the proxy device
 * and forward them to the real device by itself. This has the advantage
 * that it gets around a bug in the current (pre 1.3) linux kernels
 * that causes TCP sessions to lock up if the route is changed while
 * a packet is being retransmitted. However, this introduces quite
 * a bit of overhead on outgoing packets (10-20%). (Note that incoming packets
 * don't go through this process!)
 * If you define UNSAFE_REROUTING diald will change the routes anyway.
 * If you are using diald on a machine were there is a single outgoing
 * link this is perfectly safe (I think!), but if diald is being used
 * in an environment where more than one ppp or slip link can be active
 * at a time, then there is a small chance that you can lock up TCP
 * sessions. In particular if the link is terminated (either by diald
 * or by the other end hanging up) when a TCP session is in the middle
 * of retransmitting a packet, then that TCP session can become locked
 * if when the link comes back up it is brought back up on a different
 * ppp or slip device.
 * [NOTE: As of linux 1.3.13, it appears the Linux kernel has been
 *  fixed to allow routing changes under an active TCP retransmit,
 *  so with 1.3.13 and later UNSAFE_ROUTING should be perfectly safe.]
 */

#define UNSAFE_ROUTING 1

/*
 * Originally diald just threw away any packets it received when
 * the link was down. This is OK because IP is an unreliable protocol,
 * so applications will resend packets when the link comes back up.
 * On the other hand the kernel doubles the timeout for TCP packets
 * every time a send fails. If you define BUFFER_PACKETS diald
 * will store packets that come along when the link is down and
 * send them as soon as the link comes up. This should speed up
 * the initial connections a bit.
 */

#define BUFFER_PACKETS		/* turn on packet buffering code. */
#define BUFFER_SIZE 65536	/* size of buffer to store packets */
#define BUFFER_FIFO_DISPOSE	/* dispose of old packets to make room
				 * for new packets if the buffer becomes
				 * full. Without this option new packets
				 * are discarded if there is no room.
				 */
#define BUFFER_TIMEOUT 600	/* Maximum number of seconds to keep a
				 * packet in the buffer. Don't make this
				 * too large or you will break IP.
				 * (Something on the order of 1 hour
				 * probably the maximum safe value.
				 * I expect that the 10 minutes defined
				 * by default should be plenty.
				 */
