/* Function for allostdscrg a printscreen from inside tn3270 */

/*
   A few defines, replace TMPDIR with your temp directory, and
   PRINTCMD with the command you want to use for printing.
*/
#ifdef PRINTSCREEN

#include <stdlib.h>
#include <stdio.h>
#include <curses.h>
#include <unistd.h> 

#include "../general/general.h"
#include "../config.h"

#include "hostctlr.h"
#include "oia.h"
#include "screen.h"
#include "../api/ebc_disp.h"

#include "../general/globals.h"
#include "externs.h"
#include "declare.h"

void
PrintScreen()
 {
	FILE *fp;
	reg char	*temp1;
	reg char	*end;
	register int	r,c;
	char 		fname[256];
	char		prtcmd[256];
	char		*printer,*tmpdir;

	umask(600);

	if ((printer = getenv("PRINT")) == NULL) printer = PRINTCMD;
	if ((tmpdir = getenv("TMPDIR")) == NULL) tmpdir = PRINTDIR;

	sprintf(fname,"%s/tn3270prt.%d",tmpdir,getpid());
	
	if((fp = fopen(fname,"w")) == NULL) {
		RingBell("Could not open print screen file");
		return;
	}

	for (r = 0; r < stdscr->_maxy; r++) {
		temp1 = &stdscr->_y[r][0];
		end = &stdscr->_y[r][stdscr->_maxx];
		while (temp1 <= end) {
			fprintf(fp,"%c",((*temp1) & 0x7f));
			*temp1++; 
		}
		fprintf(fp,"\n");
	} 

	fclose(fp);
	
	sprintf(prtcmd,"%s %s",printer,fname);	
	if ((system(prtcmd)) != 0) {
		RingBell("There was an error printing the screen");
	}
	unlink(fname);
 }

#else

void
PrintScreen()
 {
	RingBell("Print screen not supported");
 }

#endif
