/*                               -*- Mode: C -*- 
 * security.h -- 
 * Author          : Shaun Savage
 * Created On      : Fri Feb  3 10:00:46 1995
 * Last Modified By: Shaun Savage
 * Last Modified On: Thu Feb 23 15:56:49 1995
 * Update Count    : 62
 * Status          : Unknown, Use with caution!
 * PURPOSE
 * 	|>This is the prototypes for The OMEN project in the serucity<|
 * TABLE OF CONTENTS
 *
 * 
 */
#ifndef _SECURITY_H
#define _SECURITY_H

#ifndef NULL
#define NULL ((void *)0)
#endif

#define ARCH32 1;    /* most C compilers */

typedef unsigned char uchar;

struct _strstrct {
   uchar   *string;
   size_t len;
};
typedef struct _strstrct StrStruct;

typedef int Bool;
typedef short Int16;
typedef unsigned short UInt16;
#ifdef ARCH32
typedef long  Int32;
typedef unsigned long  UInt32;
#endif
#ifdef ARCH64
typedef long  Int32;
typedef unsigned long  UInt32;
#endif

struct _edicryptinfo {
   uchar  MsgDir;
   Int16  Oseq;
   Int16  Useq;
   uchar  Auth[16];
};
typedef struct _edicryptinfo EDICryptInfo; 


#define EDI_LEN 1024
#define URAND_LEN 16
#define UKEY_LEN  16
#define UAUTH_LEN 16
#define SYSRAND_LEN 16
#define SAUTH_LEN 16
#define SKEY_LEN 32
#define PASS_LEN 60

#define HASH_MD5 1
#define DES3PLAIN 1
#define DES3CRYPT 2

#define CRYPT_NO    0000
#define CRYPT_AUTH  0001
#define CRYPT_CRYPT 0002
#define CRYPT_DES   0000
#define CRYPT_RSA   0100

#ifdef NOTDEF
extern static uchar SysRand[16];    /* System Random Key / not changed */
extern static uchar SysCrypt[32];   /* System DES3 Crypto key */
extern static uchar SysAuth[16];    /* System Authentic key */
extern static Int32 SysSeq;         /* System sequence number */

extern static uchar UsrRand[16];    /* User Random key */
extern static uchar UsrAuth[16];    /* User Authentic key */
extern static Int32 UsrSeq;         /* User sequence number */
extern static uchar UsrRSA[128];    /* User RSA 1024 bit private key */ 
#endif

struct _NetPacket {
   char  np_name[20];     /* The Name of the user */
   char  np_home[80];     /* The Home site of the user */
   char  np_site[80];     /* The site of where the user is at physical */
   uchar np_ukey[16];     /* The user security key */
   Int16 np_useq;         /* the user sequence number */
   Int16 np_service;  /* The service ID */
   Int16 np_msgtype;  /* The Message type. (see edi.encap) */
   Int16 np_editype;  /* The EDI type. (see edi.encap) */
   Int16 np_edilen;   /* The length of data */
   uchar *np_edidata;  /* A pointer to the data */
};
typedef struct _NetPacket NetPacket;

struct _RawPacket {
   char  *rp_name;     /* The Name of the user */
   char  *rp_home;     /* The Home site of the user */
   char  *rp_site;     /* The site of where the user is at physical */
   uchar rp_ukey[16];     /* The user security key */
   Int16 rp_len;      /* The raw packet length */
   uchar *rp_raw;      /* The raw data pointer */	
};
typedef struct _RawPacket RawPacket;

struct _CryptInfo {
   uchar  ci_mode;
   uchar  ci_dir;
   Int16  ci_useq;
   Int16  ci_sseq;
   uchar  ci_key[16];
};
typedef struct _CryptInfo CryptInfo;


struct _FullPacket {
   int   fp_ver;
   char  fp_name[20];     /* The Name of the user */
   char  fp_home[80];     /* The Home site of the user */
   char  fp_site[80];     /* The site of where the user is at physical */
   char  fp_dname[20];
   char  fp_dhome[80];
   char  fp_dsite[80];
   CryptInfo fp_crypt;
   Int16 fp_service;  /* The service ID */
   Int16 fp_msgtype;  /* The Message type. (see edi.encap) */
   Int16 fp_editype;  /* The EDI type. (see edi.encap) */
   Int16 fp_edilen;   /* The length of data */
   uchar *fp_edidata;  /* A pointer to the data */
};
typedef struct _FullPacket FullPacket;

typedef int Enum;

#define GET16(ptr) (*(short*)(ptr))
#define PUT16(ptr,val) (*((short*)((ptr))) = (short)val)

extern Int16  TDes(uchar *key, StrStruct *text, Int16 count, Enum type);
extern uchar* Hash(uchar *rslt, StrStruct *text, Int16 count, Enum type);

/*** I M P O R T A N T ***/
/*** I M P O R T A N T ***/
/*** I M P O R T A N T ***/
/* The 'UsrKey' is a VERY critical security problem */
/* NEVER  save it as a global variable, use it within a function */
/* ALWAYS zero the 16 bytes of memory that it used */
/* Lock the memory during use, no swapping */
extern uchar* GetUKey(uchar *UKey,
		     uchar *URand, 
		     char *pass,
		     Int16 USeq);

extern uchar* AuthUsr(uchar *UAuth,
		     uchar *URand,
		     char *pass,
		     Int16 USeq);


extern Int16 CryptEDI(NetPacket *np, uchar *head, Int16 hlen,
		      StreamInfo *fp);
extern Int16 DeCryptEDI(NetPacket *np, RawPacket *rp);

extern Int16 SendEDI(NetPacket *np, StreamInfo *fp);
extern Int16 RecvEDI(RawPacket *rp, StreamInfo *fp);


extern Int16 UpdateUsr(const char *Name, const char *Address,
		       uchar *UsrKey,
		       Int16 UsrSeq);

extern Int16 UpdateSys(const uchar *UsrAuth, const uchar *URandomizer,
		       Int16 SysSeq);

#ifdef GCC
static __inline__ void ClrKey(uchar* key){int i; for ( i=0;i<16;i++) *(key)++ = 0;}
#else
static void ClrKey(uchar* key){int i; for ( i=0;i<16;i++) *(key)++ = 0;}
#endif

#endif /* _SECURITY_H */
