/*
 *	wanstatus.h
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

char*	WANTYPEName();
int	WANTYPEStatus();
void	InitializeWANStatus();
void	DestroyWANTYPE();
void	ClearWANStatus();
void	LoadWANStatus();
void	DestroyWANStatus();
void	ResizeWANStatus();
void	ExposeWANStatus();
void	InputWANStatus();
int	CompareWANObj();
void	RemoveWANStatusObject();
void	AddWANStatusObject();
void	UpdateWANStatusParent();
void	RemoveWANTYPEChild();
void	AddWANTYPEChild();
void	RemoveWANTYPE();
void	UpdateWANStatusObject();
void	RenderWANStatusSites();
void	ArrangeWANStatusNodes();
void	SetNodeRep();
void	NewEnvelope();
int	NodeInEnvelope();
int	ExplodeEnvelope();
int	NodesOverlap();
void	DrawWANStatusProcessor();
void	DrawWANStatusSubnet();
void	DrawWANStatusCloud();
void	RenderWANStatusSubnet();
void	RenderWANStatusSubnets();
void	FillIpaddrRep();
void	DrawWANStatus();
int	InsideWANStatus();
void	SelectWANStatusObject();
void	DrawWANStatusObject();
int	ParseLocation();
void	SetWANStatusRouteDest();
void	SetWANStatusRouteOnOff();
void	ConfigureWANStatus();
void	SaveWANStatus();
