/*
 *
 *	logtext.c
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include	<stdio.h>
#include	<string.h>
#include	<varargs.h>

#include	<X11/StringDefs.h>
#include	<X11/Intrinsic.h>
#include	<Xm/Xm.h>
#include	<Xm/Text.h>
#include	<Xm/Form.h>
#include	<Xm/ScrolledW.h>
#include	<Xm/Label.h>
#include	<Xm/PushB.h>

#include	"defines.h"
#include	"externs.h"
#include	"xsupport.h"

typedef		struct	logentry {
		Widget		txt;
		XmTextPosition	pos;
		FILE		*fp;
		} LOGENTRY;


static LOGENTRY	*message_log;


/*
 *	Clear a log window.
 */
void
ClearLog(widg, log, a)
Widget		widg;
LOGENTRY	*log;
caddr_t		a;
	{
	XmTextSetString(log->txt, "");
	log->pos = 0;
	}


/*
 *	Make a log panel.
 */
caddr_t
CreateLog(parent, labelstring)
Widget	parent;
char	*labelstring;
	{
	Widget		m, w, b, sw, l;
	register	i;
	XmString	xs;
	LOGENTRY	*log;
	char		buf[BUFSIZ];
	Arg		args[15];
	int		n=0;

	log = (LOGENTRY*)myalloc(NULL, 1, sizeof(LOGENTRY));
	l = XtVaCreateManagedWidget("label",
		xmLabelWidgetClass,
		parent,
		XmNlabelString, (xs=X_STR(labelstring)),
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);
	XmStringFree(xs);
	b = XtVaCreateManagedWidget("label",
		xmPushButtonWidgetClass,
		parent,
		XmNlabelPixmap, GetPixmap(CLEAR_PIXMAP),
		XmNlabelType, XmPIXMAP,
		XmNtopAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNhighlightThickness, 0,
		NULL);
	XmStringFree(xs);
	XtAddCallback(b, XmNactivateCallback, ClearLog, log);
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget, l); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNeditable, False); n++;
	XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNwordWrap, True); n++;
	XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
	XtSetArg(args[n], XmNrows, 4); n++;
	XtSetArg(args[n], XmNcolumns, 60); n++;
	XtSetArg(args[n], XmNscrollHorizontal, False); n++;
	XtSetArg(args[n], XmNblinkRate, 0); n++;
	log->txt = XmCreateScrolledText(parent, "log", args, n);
	XtManageChild(log->txt);
	XtVaSetValues(log->txt,
		XmNsensitive, False,
		NULL);
	strcpy(buf, "HNMS_");
	strcat(buf, labelstring);
	log->fp = fopen(buf, "a");
	if (!log->fp)
		printf("Unable to open log file %s.\n", buf);
	return((caddr_t)log);
	}


/*
 *	Write to message.
 */
char*
logbuf(va_alist)
va_dcl
	{
	va_list		vargs;
	char		*fmt;
	int		i;
	static char	msgbuf[BUFSIZ];

	strcpy(msgbuf, get_time(time(0)));
	strcat(msgbuf, "> ");
	i = strlen(msgbuf);
	va_start(vargs);
	fmt = va_arg(vargs, char*);
	vsprintf(&(msgbuf[i]), fmt, vargs);
	va_end(vargs);
	return(msgbuf);
	}


/*
 *	Print a message to a log window and file.
 */
void
PrintToLog(log, buf)
LOGENTRY	*log;
char		*buf;
	{
	int	l;
	XmTextPosition	top;

	if (!log) {
		printf("Log: %s", buf);
		return;
		}
	XmTextInsert(log->txt, log->pos, buf);
	l = strlen(buf);
	log->pos += l;
	/*
	XtVaGetValues(log->txt,
		XmNtopCharacter, &top,
		NULL);
	XtVaSetValues(log->txt,
		XmNtopCharacter, top+l,
		NULL);
	*/
	XmTextShowPosition(log->txt, log->pos);
	if (!log->fp) return;
	fprintf(log->fp, "%s", buf);
	}
