/*
 *
 *	help.c
 *
 *	Support code for help facility.
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include	<stdio.h>
#include	<string.h>

#include	<X11/StringDefs.h>
#include	<X11/Intrinsic.h>
#include	<Xm/Xm.h>
#include	<Xm/Label.h>
#include	<Xm/Separator.h>
#include	<Xm/Text.h>
#include	<Xm/Form.h>

#include	"defines.h"
#include	"externs.h"
#include	"xsupport.h"
#include	"viewpanel.h"
#include	"help.h"

static Widget		help_msg, help_label;
static VIEWPANEL	*helppanel;
static int		help_id=0;
static int		*hi;

static int	help[][15] =
	{
	/* mainpanel help */
	{ 1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,  0},
	/* edit defaults help */
	{15, 16, 17, 18, 19, 20, 21, 22,  0},
	/* new wanstatus view help */
	{23, 16, 24, 25, 26, 27, 28,  0},
	/* new customstatus view help */
	{29, 16, 24, 25, 27, 28,  0},
	/* new sitestatus view help */
	{30, 16, 24, 31, 25, 27, 28,  0},
	/* new objectdata view help */
	{32, 16, 24, 33, 34, 27, 28,  0},
	/* objectlist help */
	{35,  0},
	/* server help */
	{36, 37, 38, 39,  0},
	/* statuslog help */
	{40, 41,  0},
	/* statuslog edit help */
	{42,  0},
	/* wanstatus help */
	{43, 44, 45, 46, 47,  0},
	/* customstatus help */
	{48, 44, 45, 46, 47,  0},
	/* sitestatus help */
	{49, 44, 50,  0},
	/* objectdata help */
	{51, 44, 50,  0},
	/* objectdump help */
	{52, 53, 54, 55,  0},
	};

void	CreateHelpPanel();
void	GetHelp();
void	LoadHelpPanel();
void	OpenHelpPanel();


/*
 *	Create the help panel.
 */
void
CreateHelpPanel()
	{
	Widget		l, b;
	XmString	xs;
	Arg		args[24];
	int		n;

	helppanel = CreateViewPanel("HELP:", "help", 0, 0, "help", 0, 0, 0);
	XtUnmanageChild(helppanel->helpbutton);
	XtVaSetValues(helppanel->closebutton,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);
	XmTextSetString(helppanel->titletext, "");
	XtVaSetValues(helppanel->titletext,
		XmNsensitive, False,
		NULL);

	l = XtVaCreateManagedWidget("form",
		xmFormWidgetClass,
		helppanel->viewform,
		XmNtopAttachment, XmATTACH_NONE,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
	b = pbutton("pb", l, "Next");
	XtVaSetValues(b,
		XmNleftAttachment, XmATTACH_NONE,
		XmNrightAttachment, XmATTACH_FORM,
		XmNrightOffset, 5,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNbottomOffset, 5,
		XmNtopAttachment, XmATTACH_FORM,
		XmNtopOffset, 5,
		NULL);
	XtAddCallback(b, XmNactivateCallback, LoadHelpPanel, 1);
	l = XtVaCreateManagedWidget("sep",
		xmSeparatorWidgetClass,
		helppanel->viewform,
		XmNtopAttachment, XmATTACH_NONE,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, l,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNorientation, XmHORIZONTAL,
		NULL);
	help_label = XtVaCreateManagedWidget("label",
		xmLabelWidgetClass,
		helppanel->viewform,
		XmNtopAttachment, XmATTACH_FORM,
		XmNtopOffset, 5,
		XmNbottomAttachment, XmATTACH_NONE,
		XmNleftAttachment, XmATTACH_FORM,
		XmNleftOffset, 5,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNtopOffset, 40); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNbottomOffset, 5); n++;
	XtSetArg(args[n], XmNbottomWidget, l); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftOffset, 5); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightOffset, 5); n++;
	XtSetArg(args[n], XmNeditable, False); n++;
	XtSetArg(args[n], XmNscrollHorizontal, False); n++;
	XtSetArg(args[n], XmNresizeWidth, True); n++;
	XtSetArg(args[n], XmNresizeHeight, True); n++;
	XtSetArg(args[n], XmNresizable, True); n++;
	XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
	XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNcolumns, 60); n++;
	XtSetArg(args[n], XmNrows, 6); n++;
	help_msg = XmCreateScrolledText(helppanel->viewform, "text", args, n);
	XtManageChild(help_msg);
	}


/*
 *	Get a help pointer for a view.
 */
void
GetHelp(panel, helpnum, addcb)
VIEWPANEL	*panel;
int		helpnum, addcb;
	{
	panel->help = help[helpnum];
	if (!addcb) return;
	XtAddCallback(panel->helpbutton, XmNactivateCallback, OpenHelpPanel,
		panel);
	}


/*
 *	Load the help panel for the view.
 */
void
LoadHelpPanel(widg, i, cbs)
Widget	widg;
int	i;
caddr_t	cbs;
	{
	XmString	xs;

	if (i == 0)
		help_id = 0;
	else
		help_id ++;
	if (!hi[help_id]) help_id = 0;
	if (!hi[help_id]) return;
	if (help_text[hi[help_id]].pixmap)
		XtVaSetValues(help_label,
			XmNlabelType, XmPIXMAP,
			XmNlabelPixmap,GetPixmap(help_text[hi[help_id]].pixmap),
			NULL);
	else {
		XtVaSetValues(help_label,
			XmNlabelType, XmSTRING,
			XmNlabelString,(xs=X_STR(help_text[hi[help_id]].label)),
			XmNalignment, XmALIGNMENT_BEGINNING,
			NULL);
		XmStringFree(xs);
		}
	XmTextSetString(help_msg, help_text[hi[help_id]].text);
	}


/*
 *	Open the help panel with the requested message.
 */
void
OpenHelpPanel(widg, panel, cbs)
Widget	widg;
VIEWPANEL	*panel;
XmAnyCallbackStruct	*cbs;
	{
	hi = panel->help;
	XmTextSetString(helppanel->titletext, panel->title);
	LoadHelpPanel(NULL, 0, NULL);
	OpenViewPanel(NULL, helppanel, NULL);
	}
