#include <unistd.h>
#include <stdio.h>
#include <sys/fcntl.h>
#include <linux/autoconf.h>

#define BUFSIZE 1024
/* If you do not speak Spanish:
 * valor_simbolo_actual: current_symbol_value
 * valor_simbolo_siguiente: next_symbol_value
 * simbolo_actual: current_symbol
 * simbolo_siguiente: next_symbol
 * leidos: read (past participle)
 * total: total
*/
int main(void)
{
	int fp= open("/proc/profile",O_RDONLY);
	FILE *kmap = fopen ("/usr/src/linux/System.map","r");
	int valor_simbolo_actual , valor_simbolo_siguiente;
	char simbolo_actual[80] , simbolo_siguiente[80];
	int leidos , total = 0, j;
	fscanf(kmap , "%x %*s %s\n" , &valor_simbolo_actual , simbolo_actual );
	fscanf(kmap , "%x %*s %s\n" , &valor_simbolo_siguiente , simbolo_siguiente );
	lseek (fp , sizeof(unsigned int) , SEEK_SET);
/* Uncomment the following if you do not patch the kernel */
/*	lseek (fp , (valor_simbolo_actual-1)*sizeof(unsigned int) >> CONFIG_PROFILE_SHIFT , SEEK_CUR); */
	for (;;) {
		unsigned int buffer[(valor_simbolo_siguiente - valor_simbolo_actual) >> CONFIG_PROFILE_SHIFT];
		unsigned int tiempo = 0;
		leidos = read (fp , buffer , sizeof(buffer) );
		for ( j = 0 ; j < leidos/sizeof(unsigned int) ; j++)
			tiempo += buffer[j];
		if (tiempo != 0) 
			printf("%s %x %u\n" , simbolo_actual , valor_simbolo_actual, tiempo);
			fflush(stdout);
		total += tiempo;
		if (leidos < (valor_simbolo_siguiente -valor_simbolo_actual)
				>> CONFIG_PROFILE_SHIFT * sizeof(unsigned long) || 
			valor_simbolo_siguiente == valor_simbolo_actual )
			break;
		strcpy ( simbolo_actual , simbolo_siguiente );
		valor_simbolo_actual = valor_simbolo_siguiente;
		fscanf(kmap , "%x %*s %s\n" , &valor_simbolo_siguiente , simbolo_siguiente );
	}
	printf("In all: %d\n" ,total);
	return(0);
}
