#ifndef UTILS_H
#define UTILS_H

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

typedef struct extd_move
{
	unsigned char	dummy_1[16];	/* filled with zeroes */
	unsigned short  s_seglength;	/* source seg length */
	unsigned char	s_segaddr[3];	/* source in linear */
	unsigned char	s_access;	/* source access rights (93h) */
	unsigned short	dummy_2;	/* zero */
	unsigned short  d_seglength;	/* dest seg length */
	unsigned char	d_segaddr[3];	/* dest in linear */
	unsigned char	d_access;	/* dest access rights (93h) */
	unsigned char	dummy_3[18];	/* zeroes */
} EXTD_MOVE;

/* asmstuff.asm */
extern long     longswap(long l);
extern unsigned int intswap(int i);
extern int      ipcheck(char *s, int len);
extern int      tcpcheck(char *psptr, char *tcpptr, int tcplen);
extern void     n_putchar(char c);
extern int      n_getch(void);
extern int      n_kbhit(void);
extern short    segss(void);
extern short    segds(void);
extern short    segcs(void);
extern long     n_ldiv(long dividend, long divisor);
extern long     n_lmul(long mul1, long mul2);
extern void     dos_exit(int val);
extern void     n_chkexit(void);
extern int	n_lmove(EXTD_MOVE *mptr, unsigned wcnt);
extern unsigned short	n_mamount(void);
extern unsigned long far2long(void far *ptr);
extern void far *cannon(void far *ptr);
extern void far *long2far(unsigned long l);


/* general */
extern void     n_putscrlf(char *s);
extern void     n_puts(char *s);
extern void     n_printf(char *format, ...);
extern long     n_secs(void);
extern long     n_ticks(void);
extern void     startrand(unsigned int seed);
extern int      random(int limit);
extern void     n_putscrlf(char *s);
extern int  	monitor_check(void);
extern int	do_boot_process(char *ifname);

/* string */
extern char     * strcpy(char *dest, const char *src);
extern int      strcmp(const char *a, const char *b);
extern int      strncmp(const char *a, const char *b, size_t len);
extern void     * memset(void  *buffer, int c, size_t len);
extern char     * strncpy(char *dest, const char *src, size_t maxlen);
extern void     * memcpy(void  *dest, const void *src, size_t cnt);
extern int      memcmp(const void *a, const void *b, size_t len);
extern char     * strchr(const char *str, int c);
extern size_t   strlen(const char *str);
extern void far * fmemcpy(void far *dst, const void far * src, size_t len);
extern void     lmemcpy(unsigned long dest, void *data, size_t len);

#endif

