/*************************************************************
 *                                                           *
 *    ths  Filesystem                  04.10.94      V1.1    *
 *                                                           *
 *    Thomas Scheuermann     ths@ai-lab.fh-furtwangen.de     *
 *                                                           *
 *************************************************************/

#ifndef _THS_H
#define _THS_H
/*
#define DEBUG
*/
#include "ths_i.h"

#define THS_MAGIC 0x00746873
#define THS_ROOT_INODE 1
/*
 * Umwandlung der Bytefolge des MSDOS-Filesystems
 * fuer 16 und 32 Bit Integer
 */
#define CHS(i) ((unsigned short)i[0]|(unsigned short)i[1]<<8)
#define CHL(i) ((unsigned long)i[0]|(unsigned long)i[1]<<8|(unsigned long)i[2]<<16|(unsigned long)i[3]<<24)
/*
 * super.c
 */
struct super_block *ths_read_super(struct super_block *,void *, int);
struct super_block *ths_read_super_normal(struct super_block *,void *, int);
struct super_block *ths_read_super_dblspace(struct super_block *,void *, int);
void superfill(struct super_block *, struct ths_sb_info *, struct ths_boot_sektor *);
short findeStartCluster(struct super_block *,long , short , char *);
void ths_put_super(struct super_block *);
void ths_write_super(struct super_block *);
void ths_statfs(struct super_block *, struct statfs *);
/*
 * fat.c
 */
void fatmem2(struct super_block *);
void fatfree(struct super_block *);
void cvffill(struct super_block *);
void cvffree(struct super_block *);
/*
 * inode.c
 */
void ths_read_inode(struct inode *);
/*
 * divers.c
 */
long time_ms2u(unsigned short, unsigned short);
int vergleich(struct ths_dir *, const char *, int);
/*
 * dir.c
 */
int ths_readdir(struct inode *, struct file *,struct dirent *, int);
int ths_dir_read(struct inode *, struct file *, char *, int);
int ths_lookup(struct inode *,const char *, int, struct inode **);
/*
 * transfer.c
 */
int ths_read_sektor(struct super_block *, unsigned long, struct ths_buffer *);
void ths_free_sektor(struct ths_buffer *);
int ths_read_cluster(struct super_block *,unsigned short ,long , struct ths_buffer *); 
void ths_free_cluster(struct ths_buffer *);
char *ths_uread_sektor(long , int , struct buffer_head **);
char *ths_uread(struct super_block *, long , struct buffer_head **);
long dblsektor(struct super_block *, unsigned short );
/*
 * file.c
 */
int ths_read(struct inode *, struct file *, char *, int);
/*
 * kompr.c
 */
void decompress(struct super_block *, struct ths_buffer *, int);
int arttest(long *);
void nextdata(unsigned char **,int *,int *,long *,struct super_block *,long,struct buffer_head **);
#endif
