/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  version.c                                                    */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <ntape.h>
#include <version.h>

/*************************************************************************/
/* Name:     print_version                                               */
/* Purpose:  Prints the version in the footer.                           */
/*************************************************************************/
void print_version()
{
    char welcome[MAXLEN];

    sprintf(welcome,"Welcome to NTAPE %s compiled at %s...",
	    VERSION,COMPILE_TIME);
    print_footer(welcome);
}


/*************************************************************************/
/* Copyright (C) 1995 Matthias Hanisch, Wuerzburg                        */
/*************************************************************************/

