/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  statusline.c                                                 */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <ntape.h>


/*************************************************************************/
/* Name:     print_statusline                                            */
/* Purpose:  prints some tape information in the second line             */
/*************************************************************************/
void print_statusline(int cur_archive,int no_archives)
{
    char text[MAXLEN];
    int percent;
    
    if (no_archives > 0)
	percent = (100 * cur_archive) / no_archives;
    else
    {
	cur_archive = 0;
	percent = 100;
    }
    
    if (tape->id == 0)
    {
	sprintf(text," No tape selected");
    }
    else
    {
	sprintf(text," Current tape: %s",tape->name);
    }
    mvwaddstr(tapestatus,0,0,text);
    winclrtoeol(tapestatus);

    sprintf(text,"%d/%d archives   %d%% ",cur_archive,no_archives,percent);
    mvwaddstr(tapestatus,0,COLS-strlen(text),text);

    touchwin(tapestatus);
    wrefresh(tapestatus);
}


/*************************************************************************/
/* Copyright (C) 1994,1995 Matthias Hanisch, Wuerzburg                   */
/*************************************************************************/
