#ifndef	__MEMPOOL_H__
#define	__MEMPOOL_H__

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifndef	__PAGER_H__
#include <sys_pager.h>
#endif

typedef	struct
{
	PAGE	mp_page;
	int		mp_count;
	char	mp_pool[0];
}	POOLPAGE;

#define	MEMPOOL	PAGER
#define	destroy_mempool(p)	destroy_pager(p)
#define	memfreq(p, size)	request_mempool((POOLPAGE *)p->c_headpage, size)
#define	memlreq(p, size)	request_mempool((POOLPAGE *)p->c_tailpage, size)
#define	strfreq(p, s)	strreq_mempool((POOLPAGE *)p->c_headpage, s)
#define	strlreq(p, s)	strreq_mempool((POOLPAGE *)p->c_tailpage, s)

IMPORT	PAGER	*create_mempool PROTO((int poolsize, int maxpages));
IMPORT	void	realloc_mempool PROTO((PAGER *mempool));
IMPORT	PTR		request_mempool PROTO((POOLPAGE *page, int size));
IMPORT	char	*strreq_mempool PROTO((POOLPAGE *page, char *str));

#endif
