#define	ED_PALMASK	0x3f
#define	ED_READONLY	0x40
#define	ED_NEWLINE	0x80

typedef	struct _edlin
{
	struct	_edlin	*ed_next, *ed_prev;
	unsigned char	ed_mask;
	char	ed_data[0];
}	EDLINE;

typedef	struct
{
	EDLINE	*ed_current;
	EDLINE	*ed_free;
	EDLINE	*ed_last;
	EDLINE	*ed_first;
	char	*ed_wrap;
	char	*ed_statline;
	int		ed_clineno;
	int		ed_llineno;
}	EDCTRL;

typedef	struct
{
	int		ed_lineno;
	int		ed_number;
	int		ed_left;
	int		ed_width;
	BOOL	ed_scroll;
	BOOL	ed_wrap;
	BOOL	ed_dirty;
	BOOL	ed_update;
}	EDOPTS;

#define	VUSetEdNbr(vu, flag)	(((EDOPTS *)vu->vuoptions)->ed_number = flag)

PORT(VUViewPad);
PORT(VUEditPad);
PORT(VUTextPad);
PORT(VUMemoPad);
PORT(VUMemoCtrlPad);
CONTROL(VUMemoControl);

#define	MEMO_CONTROL(obj, r, c, l, w)	{VUMemoControl, (char *)obj, r, c, l,w, 0, 0, NULL}, 

IMPORT	void PASCAL VUUpdatePad PROTO((VU vu));
IMPORT	int PASCAL VUScrollPad PROTO((VU vu, int lines, BOOL flag));
IMPORT	int PASCAL	VUNewEditText PROTO((VU vu, char mode));
IMPORT	int PASCAL	VUAddEditText PROTO((VU vu, char mode, char *text));
IMPORT	int PASCAL 	VURewEditText PROTO((VU vu));
IMPORT	char * PASCAL 	VUReadEditText PROTO((VU vu));
IMPORT	int	PASCAL	VUInsEditText PROTO((VU vu, char *text, char mode));
IMPORT	int	PASCAL	VUDelEditText PROTO((VU vu, int lines));	
IMPORT	int	PASCAL	VURepEditText PROTO((VU vu, char *text));

