/****************************************************************************
                          login1.c      Sep 6, 1994
 ****************************************************************************

   This program is Copyright (c) 1994 Joseph R.M. Zbiciak.  All Rights Reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products
      derived from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
   IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
   OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
   IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
   NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
   THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

   Thank you and have a nice day.

 ****************************************************************************
        Description:    Wrapper program for insecure /bin/login
                        Fixes problems with -f and -h options.
        Usage:          login (options for old /bin/login)
        Author:         Joseph R.M. Zbiciak, Sep 6, 1994
 ****************************************************************************
        Please report all bugs to the author.  The author may be reached
        via email at the following addresses:  (listed in order of pref.)

                im14u2c@bradley.edu
                im14u2c@cegt201.bradley.edu

        Also, the author may be reached via snail-mail at the following
        address:
                Joseph R.M. Zbiciak
                406 W State Road
                Hastings, MI  49058-1131


 ****************************************************************************/

#include <strings.h>
#include <unistd.h>
#include <stdio.h>

#ifndef LOGINDIR
#define LOGINDIR "/bin"
#endif

main (int argc, char * argv[], char * envp[])
{
        char **av=argv;
        int ac=argc;


        if (argc>1) {
                while(--ac>0) {
                        if (**(++av)=='-' && strlen(*av)>1) {
                                 *((*av)+2)=0;
                                 if (*((*av)+1)=='h' && getuid()>100) {
                                        fprintf(stderr,"login: -h for superuser only.\n");
                                        exit (1);
                                 }
                        }
                }
        }

        execve(LOGINDIR "/_login",argv,envp);
        return 0;
}
