/* Default message for users not allowed on certain computers	 
   Set the users shell to this to disable them from using the computer
	Syslogging done under auth.debug	
   Written by Ken Wilcox <wilcox@kpw104.rh.psu.edu>
*/
/* Major includes */

#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <syslog.h>
#include <sys/types.h>
#include <unistd.h>
#ifndef MAIL_FLAG
#define MAIL_FLAG sysadmin
#endif
#ifndef ADMIN_FLAG
#define ADMIN_FLAG sysadmin
#endif
#ifndef ROOM_FLAG
#define ROOM_FLAG sysadmin
#endif
/* Variables needed */
int uid_user; 			/* users uid */
struct passwd *get_passwd;	/* the passwd entry for user */
char *t;			/* the tty name */

main(){
/* Syslogging */
	t = ttyname(STDIN_FILENO);
	uid_user = getuid();
	get_passwd = getpwuid(uid_user);
	openlog("message",LOG_PID,LOG_AUTH);
	syslog(LOG_DEBUG, "user %s got the default msg on %s", get_passwd->pw_name, t); 
	closelog();
/* The message */
	printf("\n\n\n");
	printf("You have been denied access to this machine for one reason or another.\n");
	printf("If you are concerned about this or would like to see about having\n");
	printf("access to this machine. Please send mail to ");
	printf(MAIL_FLAG);
	printf(" or stop and\n");
	printf("talk to ");
	printf(ADMIN_FLAG);
	printf(" in room\n");
	printf(ROOM_FLAG);
	printf(". Thank You!!\n\n\n\n");
	printf("Systems Staff\n\n\n\n");
	usleep(15*1000000);
}
