/* The Generic message for disabling users
   Set users shell to this for disabling them
	Syslogging done to auth.debug
Written by Ken Wilcox <wilcox@kpw104.rh.psu.edu>
*/
/* Needed includes and defines */

#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <syslog.h>
#include <sys/types.h>
#include <unistd.h>
#ifndef MAIL_FLAG
#define MAIL_FLAG sysadmin
#endif
#ifndef ADMIN_FLAG
#define ADMIN_FLAG sysadmin
#endif
#ifndef ROOM_FLAG
#define ROOM_FLAG sysadmin
#endif
/* needed variables */

int uid_user;			/* users uid */
struct passwd *get_passwd;	/* the users passwd information */
char *t;			/* the tty */

main(){
/* The syslogging */
	t = ttyname(STDIN_FILENO);
	uid_user = getuid();
	get_passwd = getpwuid(uid_user);
	openlog("disabled",LOG_PID,LOG_AUTH);
	syslog(LOG_DEBUG, "user %s got the disabled msg on %s", get_passwd->pw_name, t); 
	closelog();
/* The Message */
	printf("\n\n\n");
	printf("Your account has been disabled. To see about having\n");
	printf("your account re-activated, Pleae send mail to ");
	printf(MAIL_FLAG);
	printf(" or stop and\n");
	printf("talk to ");
	printf(ADMIN_FLAG);
	printf(" in room\n");
	printf(ROOM_FLAG);
	printf(" . Thank You!!\n\n\n\n");
	printf("Systems Staff\n\n\n\n");
	usleep(15*1000000);
}
