
// This module only runs under Linux.
#if defined(HAVE_VGA) && defined(linux) && !defined(VGA_Graphics_h)
#define VGA_Graphics_h

// This module provides the VGA interface for the TTY module

#include <vga.h>
#include <vgagl.h>

// The number of VGA/SVGA registers handed us by svgalib.
#define MAX_REGS	269

// The VGA graphics module:

class VGA_Graphics : public TTY_Graphics {

public:
	VGA_Graphics();
	virtual ~VGA_Graphics();
	virtual int has_graphics(void);
	virtual int ibm_charset(void);
	virtual void flush(void);
	virtual void set_grmode(int newmode);
	virtual void set_colormap(struct color colormap[256]);
	virtual void clr_grscreen(void);
	virtual void put_graphics_txt(int x, int y, char *string, 
							unsigned char color);
	virtual void drawpoint(int x, int y, unsigned char color);

private:
	GraphicsContext *Screen, *Virtual;
	char saved_font[8192];
	char new_regs[MAX_REGS];
	char saved_regs[MAX_REGS];
	int  new_rows, saved_rows;
	int  new_cols, saved_cols;

	void detect_vtsize(int *cols, int *rows);
	int resize_vt(int cols, int rows);
	void to_50lines(char *regs);
	void to_25lines(char *regs);
};

#endif /* linux */
