// DeHackEd version 2.3
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!

#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>

#include "dehacked.h"
#include "playview.h"

#undef TEXT				// Defined in dehacked.h
#undef WIDTH				// Defined in dehacked.h
#undef HEIGHT				// Defined in dehacked.h
#include "ttyobj.h"

// Plays the actual sound (maybe)
int Play(ResourceS entry)
{
	struct snd_header header;
	int audio_fd;
	unsigned char *chunk;
	int i, samplei;
	unsigned char ulaw;
	float sum = 0, increment;

	fseek(doomwadfp, entry.resstart, SEEK_SET);
	fread((void *)&header, sizeof(header), 1, doomwadfp);
	if ( NEED_SEX ) {
		bytesec(header.magic);
		bytesec(header.sample_rate);
		bytesec(header.num_samples);
	}

	if ( header.magic != SND_MAGIC ) {
		Printwindow("Not a sound resource!", ERROR);
		return(-1);
	}
	chunk = new unsigned char[header.num_samples];
	if ( chunk == NULL ) {
		Printwindow("Not enough memory!", ERROR);
		return(-1);
	}

	if ((audio_fd=open(_PATH_DEVAUDIO, O_WRONLY, 0)) <0)
	{
		if ( errno == EBUSY )
			Printwindow("Sound card in use!", ERROR);
		else
			Printwindow("Sound card not found!", ERROR);
		return -1;
	}
	fread((void *)chunk, 1, header.num_samples, doomwadfp);

	/* increment is the number of bytes to read each time */
	increment = ((float)header.sample_rate)/8000;


	/* Write to the sound card */
	for ( i=0; i<header.num_samples; ) {
		/* convert the excess 128 to two's complement */
		samplei = 0x80 - chunk[i];
		/* increase the volume, convert to uLAW */
		ulaw = (unsigned char)sample_cvt(samplei * 16);
		/* Output the converted sample */
		write(audio_fd, (char *)&ulaw, 1);

		/* skip input to compensate for sampling frequency diff */
		sum += increment;
		while(sum > 0) {
			++i; --sum;
		}
	}
	close(audio_fd);
	return 0;
}

// Plays a sound.

int Playsound(long soundnum)
{
	ResourceS entry = {0, 0, ""};
	char nametemp[7];
	char soundname[9] = "DS";

	Getsoundname((int)soundnum, nametemp);

	if (strcmp(nametemp, "none") == 0)
		return -1;
	else if (strcmp(nametemp, "ERROR") == 0)
	{
		Printwindow("Not a valid sound number!", ERROR);
		return -1;
	}

	strcat(soundname, strupr(nametemp));

	// Find the correct sound
	if (Searchforentry(soundname, &entry) == 0)
	{
		Printwindow("Could not find sound in the DOOM.WAD file!", ERROR);
		return -1;
	}

	Play(entry);

	return 0;
}


// Actually draw a frame on the screen
int Drawframe(ResourceS entry, EBool flip)
{
	int width=0, height=0, xoff=0, yoff=0;
	struct frame_header header;
	unsigned long *picoff;
	int i, j;
	unsigned char numpixels;
	unsigned char *pixinfo;
	int curoff = 0, curx, cury;
	int step;

	// Get the initial info
	fseek(doomwadfp, entry.resstart, SEEK_SET);
	fread(&header, 1, sizeof(header), doomwadfp);
	if ( NEED_SEX ) {
		bytesec(header.width);
		bytesec(header.height);
		bytesec(header.l_offset);
		bytesec(header.t_offset);
	}
	width=header.width;
	height=header.height;
	xoff=header.l_offset;
	yoff=header.t_offset;

	// Set the x and y offsets if we're dealing with a weapon picture,
	// which has a negative offset.
	if (xoff < 0)
		xoff = width/2;
	if (yoff < 0)
		yoff = 80;

	yoff = 100 - yoff/2;

	// If we have to flip the image along the y axis, set the x variable
	// to go left instead of right, and start it on the right side of the
	// image.
	if (flip)
	{
		step = -1;
		curx = 160 + xoff;
	}
	else
	{
		step = 1;
		curx = 160 - xoff;
	}

	// Get memory for image
	picoff = new unsigned long[width];
	pixinfo = new unsigned char[entry.reslength];

	if (picoff == NULL || pixinfo == NULL)
		return -1;

	// Get the column info
	fread(picoff, width, 4, doomwadfp);
	if ( NEED_SEX ) {
		for ( int sexi=0; sexi<width; ++sexi )
			picoff[sexi] = bytesex(picoff[sexi]);
	}

	// Read in the rest of the image stuff
	fseek(doomwadfp, entry.resstart+picoff[0], SEEK_SET);
	fread(pixinfo, (unsigned int)(entry.reslength-picoff[0]), 1, doomwadfp);

	// Loop through each column
	for (i=0; i<width; i++, curx += step)
	{
		curoff = (int)(picoff[i]-picoff[0]);

		while (i != width-1 && (curoff != picoff[i+1]-picoff[0]-1))
		{
			cury = yoff + pixinfo[curoff];
			numpixels = pixinfo[curoff+1];
			curoff += 3;
			for (j=0; j<numpixels; j++, cury++) {
				if (curx <= 319 && cury <= 199) {
					drawpoint(curx, cury,
							pixinfo[curoff++]);
				}
			}
			curoff++;
		}
	}

	// Free memory
	delete[] picoff;
	delete[] pixinfo;
	return 0;
}


// General driving forces behind showing a frame.
int Showframe(long framenum)
{
	int curview = 1;
	ResourceS entry = {0, 0, ""};
	EBool ExitLoop = NO;
	EBool flip, draw = YES;
	char framename[9];
	char input;
	struct color colormap[256];

#ifdef HAVE_MOUSE
	unsigned int x, y;		// Mouse x and y
	EButton lbutton, rbutton;// State of left and right buttons
#endif
	char order[9] = {0, 5, 8, 7, 6, 1, 4, 3, 2};

	if ( ! has_graphics() ) {
		Printwindow(
			"Not running in a graphics capable display!", ERROR);
		return -1;
	}
	
	Getframename((int)framenum, framename);

	if (strcmp(framename, "none") == 0)
		return -1;
	else if (strcmp(framename, "ERROR") == 0) {
		Printwindow("Not a valid frame number!", ERROR);
		return -1;
	}


	// Find the Doom palette
	if (Searchforentry("PLAYPAL", &entry) == 0)
	{
		Printwindow("Could not find the default palette!", ERROR);
		return -1;
	}

	// Get the palette setup correctly.
	fseek(doomwadfp, entry.resstart, SEEK_SET);
	fread(&colormap, sizeof(struct color), 256, doomwadfp);

	// Search for the generic frame ending in '0' first
	framename[5] = '0';
	framename[6] = 0;
	if (Searchforentry(framename, &entry) == 0)
	{
		framename[5] = '1';
		if (Searchforentry(framename, &entry) == 0)
		{
			framename[5] = '5';
			if (Searchforentry(framename, &entry) == 0)
			{
				Printwindow("Could not find frame in the Doom WAD file!", ERROR);
				return -1;
			}
		}
	}

	// Init graphics, my crude way
	toMCGA();
	set_colormap(colormap);

	// While they haven't exited the frame viewer...
	while (ExitLoop == NO)
	{
		// Don't flip the image by default
		flip = NO;

		// Get the frame name of the current frame to draw and find that
		// entry in the WAD file.
		// If the sixth character is '0', we'll ASSUME it's been read into
		// entry already, and is ready to display.
		if (framename[5] != '0')
		{
			framename[5] = '0' + curview;
			if (Searchforentry(framename, &entry) == 0)
			{
				framename[5] = '0' + order[curview];
				if (Searchforentry(framename, &entry) == 0)
				{
					ExitLoop = YES;
					break;
				}
				else
					flip = YES;
			}
		}

		// Only redraw if we have to.
		if (draw == YES)
		{
			clsMCGA();
			MCGAPutsXY(0, 0, "Escape: quit", 92);
			MCGAPutsXY(0, 1, "Space: Next Frame", 92);

			if (entry.resname[5] != '0')
				MCGAPutsXY(0, 2, "Left/right: rotate", 92);

			// If drawing the last frame failed for some reason, quit
			if (Drawframe(entry, flip) == -1)
			{
				ExitLoop = YES;
				break;
			}
			flush();
			draw = NO;
		}

		if (Waitforevent(NO))
		{
			input = getch();

			// If the first input character is 0, it's an extended key
			// (function or arrow, basically).  We only care about arrow
			// keys if the picture can be rotated, so check that too.
			if (!input)
			{
				input = getch();
				if (input == RIGHT && (entry.resname[5] != '0'))
				{
					if (curview > 1)
						curview--;
					else
						curview = 8;
					draw = YES;
				}
				else if (input == LEFT && (entry.resname[5] != '0'))
				{
					if (curview < 8)
						curview++;
					else
						curview = 1;
					draw = YES;
				}
				input = 0;
			}
		}
#ifdef HAVE_MOUSE
		else
		{
			input = 0;
			getLastEvent(&x, &y, &lbutton, &rbutton);

			if (rbutton == buttonUp && LastEventButtons & RIGHTBUTTON)
				input = ESC;
			if (lbutton == buttonUp && LastEventButtons & LEFTBUTTON)
				input = ' ';
		}
#endif

		switch (tolower(input))
		{
			case ESC:
				ExitLoop = YES;
				break;
			case ' ':
				if (framedata[framenum][NEXTFRAME] == 0)
					ExitLoop = YES;
				else
				{
					framenum = framedata[framenum][NEXTFRAME];
					Getframename((int)framenum, framename);
					if (strcmp(framename, "none") == 0 ||
						 strcmp(framename, "ERROR") == 0)
					{
						ExitLoop = YES;
						break;
					}

					// Search for the generic frame ending in '0' first
					framename[5] = '0';
					framename[6] = 0;
					if (Searchforentry(framename, &entry) == 0)
						framename[5] = '1';
					draw = YES;
				}
				break;
		}
	}

	// Reinit text, my very crude way
	totext();
	_setcursortype(_NOCURSOR);
	return 0;
}
