
// Prototypes for the Linux compatibility routines

#include <unistd.h>

extern "C" {
	int ioctl(int d, int request, ...);
	int close(int fd);
	int fchmod(int fd, mode_t mode);
	uid_t getuid(void);
	int setuid(uid_t uid);
};
	
// Function prototypes for functions from linux.cpp
extern int linux_init(void);
extern void linux_end(void);
extern void tty_raw(int raw);
extern int pending_input(float do_wait);
extern int getch(void);
extern void wherexy(int *x, int *y);
extern void gotoxy(int x, int y);
extern void clrbox(int x, int y, int width, int height);
extern void clreol(void);
extern void cls(void);
extern void textattr(int attr);
extern void highlight_loc(int x, int y, int attr);
extern void pokew(int x, int y, unsigned ch);
extern void putch(int c);
extern void cputs(char *s);
extern void cprintf(char *s, ...);
extern void gettext(int left, int top, int right, int bottom, int *buffer);
extern void puttext(int left, int top, int right, int bottom, int *buffer);
extern int stricmp(char *s1, char *s2);
extern int strcmpi(char *s1, char *s2);
extern char *strupr(char *s);
extern int has_graphics(void);
extern void textmode(int mode);
extern void toMCGA(void);
extern void set_colormap(struct color colormap[256]);
extern void clsMCGA(void);
extern void MCGAPutsXY (int x, int y, char *string, unsigned char color);
extern void drawpoint(int x, int y, unsigned char color);
extern void totext(void);
extern void flush(void);
extern void  _setcursortype(int type);
extern int spawn(char *exe, char **args);

/* Different text modes */
#define C80	0
#define C4350	1

#define _PATH_DEVDSP	"/dev/dsp"	// The device file for the sound card.

extern int IBM_CHARSET;			// Can we display IBM characters?
