
#include <stdio.h>
#include <sys/stat.h>

extern void csearch(char *pattern, int plen, FILE *input);
extern void sound_search(char *pattern, int plen, FILE *input);


main(int argc, char *argv[])
{
	void (*searchfunc)()=NULL;
	char *pattern, *patleft;
	int len, lenleft, i;
	struct stat sb;
	FILE *doomexe, *data;

	if ( argc != 3 ) {
		fprintf(stderr, "Usage: %s <datafile> <doomexe>\n", argv[0]);
		exit(1);
	}
		searchfunc=csearch;

	if ( ! searchfunc ) {
		fprintf(stderr, 
"Don't know what search function to use for %s\n", argv[1]);
		exit(1);
	}
	if ( (doomexe=fopen(argv[2], "r")) == NULL ) {
		fprintf(stderr, "Can't open DOOM! executable %s: ", argv[2]);
		perror("");
		exit(2);
	}
	if ( stat(argv[1], &sb) != 0 ) {
		fprintf(stderr, "Can't stat %s: ", argv[1]);
		perror("");
		exit(2);
	}
	lenleft=len=sb.st_size;
	if ( (patleft=pattern=(char *)malloc(len)) == NULL ) {
		fprintf(stderr, "Can't malloc %d bytes: ", len);
		perror("");
		exit(3);
	}

	/* Read in the data to search for ... */
	if ( (data=fopen(argv[1], "r")) == NULL ) {
		fprintf(stderr, "Can't open data file %s: ", argv[1]);
		perror("");
		exit(2);
	}
	while ( lenleft > 0 ) {
		if ( (i=fread(patleft, 1, lenleft, data)) < 0 ) {
			perror("Read error on data file");
			exit(3);
		}
		lenleft-=i;
		patleft+=i;
	}
	fclose(data);

	/* Now perform the search */
	(*searchfunc)(pattern, len, doomexe);
	exit(0);
}
