
/* This module handles all the VGA functions, for text mode switching,
   font loading, etc.
*/
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <linux/vt.h>
#include <signal.h>
#include <termio.h>
#include <stdio.h>
#include <vga.h>

#include "8x8font.h"
#include "8x16font.h"

void resize_vt(int cols, int rows)
{
	struct vt_sizes vtsize;
	struct winsize win;
	struct stat    st;

	vtsize.v_cols = cols;
	vtsize.v_rows = rows;
	vtsize.v_scrollsize = 0;

	(void) ioctl(2, VT_RESIZE, &vtsize);

	win.ws_row = rows;
	win.ws_col = cols;
	(void) ioctl(2, TIOCSWINSZ, &win);

	/* Check to see if /tmp/selection.pid exists */
	if ( stat("/tmp/selection.pid", &st) == 0 ) {
		/* If owned by root and only writable by root, */
		if ( (st.st_uid == 0) && !(st.st_mode&022) ) {
			/* Try to open the file and kill the selection pid */
			FILE *pidfile;
			if ( (pidfile=fopen("/tmp/selection.pid", "r")) ) {
				char buf[93]; int pid;
				if ( fgets(buf, 92, pidfile) && 
							(pid=atoi(buf)) ) {
					(void) kill(pid, SIGWINCH);
				}
				(void) fclose(pidfile);
			}
		}
	}
}

void to_50lines(char *regs)
{
	regs[9]  = 0x47;
	regs[10] = 0x06;
	regs[11] = 0x07;
	regs[12] = 0x00;
	regs[13] = 0x00;

	vga_settextmoderegs(regs);
	vga_puttextfont(font8x8_data);
	vga_setmode(TEXT);
	resize_vt(80, 50);
}

void to_25lines(char *regs)
{
	regs[9]  = 0x4F;
	regs[10] = 0x0D;
	regs[11] = 0x0E;
	regs[12] = 0x03;
	regs[13] = 0x70;

	vga_settextmoderegs(regs);
	vga_puttextfont(font8x16_data);
	vga_setmode(TEXT);
	resize_vt(80, 25);
}


main(int argc, char *argv[])
{
	struct vt_stat stats;
	unsigned char regs[269];

	if ( ioctl(2, VT_GETSTATE, &stats) != 0 ) {
		fprintf(stderr, "Not in a console.\n");
		exit(255);
	}

	/* Okay, we're in a console, initialize 50-line mode */
	vga_disabledriverreport();
	vga_setchipset(VGA);		/* avoid SVGA detection */
	vga_init();
	vga_setmode(TEXT);
	vga_gettextmoderegs(regs);
	switch (atoi(argv[1] ? argv[1] : "0")) {
		case 50:	to_50lines(regs);
				break;
		case 25:	to_25lines(regs);
				break;
		default:	fprintf(stderr, "How many lines was that?\n");
				exit(1);
	}
	exit(0);
}
