#!/bin/sh
#
#	cook - file construction tool
#	Copyright (C) 1994 Peter Miller.
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# MANIFEST: Test the make2cook vpath functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the make2cook vpath functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test the make2cook vpath functionality
#
cat > test.in << 'fubar'
VPATH = $(SRC)/nasal:$(SRC)/mucus
override SRC = $(HOME)/src
vpath %.o obj:old-obj
vpath % other:/junk
.SUFFIXES:
.SUFFIXES: .o .c
test: foo
fubar
if test $? -ne 0 ; then fail; fi

sed 's/X$//' > test.ok << 'fubar'
if [not [defined CPPFLAGS]] thenX
	CPPFLAGS = [getenv CPPFLAGS];X
if [not [defined CFLAGS]] thenX
	CFLAGS = [getenv CFLAGS];X
if [not [defined TARGET_ARCH]] thenX
	TARGET_ARCH = [getenv TARGET_ARCH];X
if [not [defined CC]] thenX
{X
	CC = [getenv CC];X
	if [not [CC]] thenX
		CC = cc;X
}X
if [not [defined COMPILE.c]] thenX
{X
	COMPILE.c = [getenv COMPILE.c];X
	if [not [COMPILE.c]] thenX
		COMPILE.c = [CC] [CFLAGS] [CPPFLAGS] [TARGET_ARCH] -c;X
}X
if [not [defined LDFLAGS]] thenX
	LDFLAGS = [getenv LDFLAGS];X
if [not [defined LINK.c]] thenX
{X
	LINK.c = [getenv LINK.c];X
	if [not [LINK.c]] thenX
		LINK.c = [CC] [CFLAGS] [CPPFLAGS] [LDFLAGS] [TARGET_ARCH];X
}X
if [not [defined LDLIBS]] thenX
	LDLIBS = [getenv LDLIBS];X
if [not [defined LOADLIBES]] thenX
	LOADLIBES = [getenv LOADLIBES];X
if [not [defined LINK.o]] thenX
{X
	LINK.o = [getenv LINK.o];X
	if [not [LINK.o]] thenX
		LINK.o = [CC] [LDFLAGS] [TARGET_ARCH];X
}X
if [not [defined HOME]] thenX
	HOME = [getenv HOME];X
#line 2 "test.in"X
SRC = [HOME]/src;X
X
X
X
X
test: foo;X
search_list = . X
#line 3 "test.in"X
obj old-obj X
other /junk X
#line 1 "test.in"X
[SRC]/nasal [SRC]/mucus;X
X
%: %.oX
{X
	[LINK.o] [resolve [need]] [LOADLIBES] [LDLIBS] -o [target];X
}X
%: %.cX
{X
	[LINK.c] [resolve [need]] [LOADLIBES] [LDLIBS] -o [target];X
}X
%.o: %.cX
{X
	[COMPILE.c] [resolve [head [need]]];X
}X
fubar
if test $? -ne 0 ; then fail; fi

$bin/make2cook test.in test.out -ln
if test $? -ne 0 ; then fail; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
