#!/bin/sh
#
#	cook - file construction tool
#	Copyright (C) 1994 Peter Miller.
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# MANIFEST: Test the search-list functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the search-list functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# make sure targets are not deeper than ingredients
#
cat > Howto.cook << 'fubar'
set fingerprint update;
search_list = . bl;
test: test.c
{
	cc -o test test.c;
}
fubar
if test $? -ne 0 ; then fail; fi

cat > test.c << 'fubar'
main(){exit(42);}
fubar
if test $? -ne 0 ; then fail; fi

$bin/cook -nl -silent
if test $? -ne 0 ; then fail; fi

./test
if test $? -ne 42 ; then fail; fi

#
# move into "bl"
#
mkdir bl
if test $? -ne 0 ; then fail; fi

mv test test.c bl
if test $? -ne 0 ; then fail; fi

#
# new file in front of list
#
sleep 1
cat > test.c << 'fubar'
main(){exit(0);}
fubar
if test $? -ne 0 ; then fail; fi

#
# irrelevant update in back of list
#
sleep 1
cc -o bl/test bl/test.c
if test $? -ne 0 ; then fail; fi

#
# this should cook in front list
#
$bin/cook -nl -silent
if test $? -ne 0 ; then fail; fi

./test
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
