#!/bin/sh
#
#	cook - file construction tool
#	Copyright (C) 1994 Peter Miller.
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# MANIFEST: Test the newest/oldest mtime functionality
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the newest/oldest mtime functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap \"fail\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# create the input files
#
cat > Howto.cook << 'fubar'
set fingerprint update;
test: first second
{
	sleep 1
		set silent;
	cat first second > test;
}

first: same
{
	if [exists first] then
	{
		echo this should not happen
			set silent;
		fail;
	}
	sleep 1
		set silent;
	cat same same > first;
}

second: different
{
	sleep 1
		set silent;
	cat different different > second;
}

same different: leaf
{
	sleep 1
		set silent;
	echo same > same;
	date > different;
	cat leaf leaf >> different;
}
fubar
if test $? -ne 0 ; then fail; fi
echo "boring" > leaf
if test $? -ne 0 ; then fail; fi

#
# let the clock tick over
#
sleep 1

#
# cook everything up
#
$bin/cook -nl -silent
if test $? -ne 0 ; then fail; fi

#
# let the clock tick over
#
sleep 1

#
# change the leaf-most file
#
echo "ha ha" > leaf

#
# cook everything up
#	should not hit the "fail" action
#
$bin/cook -nl -silent
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
