#!/bin/sh
#
#	cook - file construction tool
#	Copyright (C) 1993, 1994 Peter Miller.
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# MANIFEST: Test the "resolve" builtin function
#
work=/tmp/$$
PAGER=cat
export PAGER
umask 022
unset COOK
here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

fail()
{
	set +x
	echo 'FAILED test of the builtin function "resolve"' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# test cookbook
#
cat > book << 'fubar'
search_list  = . bl;
%.o: %.c
{
	cc -O -c [resolve %.c];
}

test: a.o b.o
{
	cc -o test [resolve a.o b.o];
}
fubar
if test $? -ne 0 ; then fail; fi

#
# the first source file
#
cat > a.c << 'fubar'
main()
{
	b();
	exit(0);
}
fubar
if test $? -ne 0 ; then fail; fi

#
# the second source file
#
mkdir bl
if test $? -ne 0 ; then fail; fi
cat > bl/b.c << 'fubar'
b()
{
	printf("Hello, World!\n");
}
fubar
if test $? -ne 0 ; then fail; fi

#
# try it out
#
sleep 1
$bin/cook -book book -nl > /dev/null 2>&1
if test $? -ne 0 ; then fail; fi

#
# make sure works for object in search list, too
#
mv b.o bl/b.o
if test $? -ne 0 ; then fail; fi
rm test
if test $? -ne 0 ; then fail; fi
sleep 1
$bin/cook -book book -nl > /dev/null 2>&1
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
