/*
 *	cook - file construction tool
 *	Copyright (C) 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to manipulate statements
 */

#include <mem.h>
#include <stmt.h>
#include <trace.h>


stmt_ty *
stmt_alloc(mp)
	stmt_method_ty	*mp;
{
	stmt_ty		*result;

	trace(("stmt_alloc(mp = %08lX)\n{\n"/*}*/, (long)mp));
	result = mem_alloc(mp->size);
	result->method = mp;
	result->white_space = 0;
	wl_zero(&result->mdef);
	wl_zero(&result->cdef);
	wl_zero(&result->ref);
	wl_zero(&result->rref);
	if (mp->constructor)
		mp->constructor(result);
	trace(("return %08lX;\n", (long)result));
	trace((/*{*/"}\n"));
	return result;
}


void
stmt_emit(sp)
	stmt_ty		*sp;
{
	trace(("stmt_emit(sp = %08lX)\n{\n"/*}*/, (long)sp));
	if (sp->method->emit)
		sp->method->emit(sp);
	trace((/*{*/"}\n"));
}


void
stmt_free(sp)
	stmt_ty		*sp;
{
	trace(("stmt_free(sp = %08lX)\n{\n"/*}*/, (long)sp));
	if (sp->method->destructor)
		sp->method->destructor(sp);
	wl_free(&sp->mdef);
	wl_free(&sp->cdef);
	wl_free(&sp->ref);
	wl_free(&sp->rref);
	mem_free(sp);
	trace((/*{*/"}\n"));
}


void
stmt_variable_merge(parent, child)
	stmt_ty		*parent;
	stmt_ty		*child;
{
	size_t		j;

	for (j = 0; j < child->mdef.wl_nwords; ++j)
		wl_append_unique(&parent->mdef, child->mdef.wl_word[j]);
	for (j = 0; j < child->cdef.wl_nwords; ++j)
		wl_append_unique(&parent->cdef, child->cdef.wl_word[j]);
	for (j = 0; j < child->ref.wl_nwords; ++j)
		wl_append_unique(&parent->ref, child->ref.wl_word[j]);
	for (j = 0; j < child->rref.wl_nwords; ++j)
		wl_append_unique(&parent->rref, child->rref.wl_word[j]);
}


void
stmt_regroup(sp)
	stmt_ty		*sp;
{
	if (sp->method->regroup)
		sp->method->regroup(sp);
}


void
stmt_sort(sp)
	stmt_ty		*sp;
{
	if (sp->method->sort)
		sp->method->sort(sp);
}
