/*
 *	cook - file construction tool
 *	Copyright (C) 1990, 1991, 1992, 1993 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to isolate operating system interface
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>

#include <error.h>
#include <os.h>

/*
 *  NAME
 *	os_exists - tests for the existence of a file
 *
 *  SYNOPSIS
 *	int os_exists(char *filename);
 *
 *  DESCRIPTION
 *	Os_returns 1 if the file exists, 0 if it does not.
 */

int
os_exists(filename)
	char	*filename;
{
	struct stat	st;

	if (stat(filename, &st))
	{
		switch (errno)
		{
		case ENOENT:
		case ENOTDIR:
			break;

		default:
			nfatal("%s", filename);
		}
		return 0;
	}
	return 1;
}
