/*
 *	cook - file construction tool
 *	Copyright (C) 1990, 1991, 1992, 1993, 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: interface definition for cook/option.c
 */

#ifndef OPTION_H
#define OPTION_H

#include <main.h>

#include <str.h>
#include <word.h>

/*
 * option levels, highest to lowest
 * (room for 16 levels in a 32 bit unsigned)
 */
enum option_level_ty
{
	OPTION_LEVEL_ERROR,
	OPTION_LEVEL_AUTO,
	OPTION_LEVEL_COMMAND_LINE,
	OPTION_LEVEL_EXECUTE,
	OPTION_LEVEL_RECIPE,
	OPTION_LEVEL_COOKBOOK,
	OPTION_LEVEL_ENVIRONMENT,
	OPTION_LEVEL_DEFAULT
};
typedef enum option_level_ty option_level_ty;

enum option_number_ty
{
	OPTION_PERSEVERE,	/* keep trying if have errors */
	OPTION_SILENT,		/* do not echo any command */
	OPTION_ERROK,		/* ignore error returns from commands */
	OPTION_ACTION,		/* do not execute the command */
	OPTION_TOUCH,		/* do not execute the command, just touch */
	OPTION_FORCE,		/* always execute the commands */
	OPTION_PRECIOUS,	/* do not delete failed targets */
	OPTION_TERMINAL,	/* enable tty output when logging */
	OPTION_TRACE,		/* emit tracing information */
	OPTION_CMDFILE,		/* generate a command file */
	OPTION_METER,		/* meter each command */
	OPTION_LOGGING,
	OPTION_BOOK,
	OPTION_INVALIDATE_STAT_CACHE,
	OPTION_STAR,		/* emit progress stars */
	OPTION_FINGERPRINT,	/* remember file fingerprints */
	OPTION_UPDATE,		/* update utime for consistency */
	OPTION_STRIP_DOT,	/* strip leading ./ from paths */
	OPTION_max
};
typedef enum option_number_ty option_number_ty;

typedef struct option_ty option_ty;
struct option_ty
{
	unsigned	o_flag[OPTION_max];
	wlist		o_target;
	string_ty	*o_book;
	string_ty	*o_logfile;
	wlist		o_search_path;
	wlist		o_vardef;
};

extern	option_ty	option;
extern	char		*progname;

int option_already _((option_number_ty, option_level_ty));
int option_test _((option_number_ty));
void option_set _((option_number_ty, option_level_ty, int));
void option_undo _((option_number_ty, option_level_ty));
void option_undo_level _((option_level_ty));
void option_set_errors _((void));
void option_tidy_up _((void));

#endif /* OPTION_H */
